/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rsa;

import codec.asn1.ASN1Type;
import codec.pkcs1.DigestInfo;
import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.common.util.ByteUtils;
import de.flexiprovider.core.rsa.PKCS1Exception;
import de.flexiprovider.core.rsa.interfaces.RSAPrivateCrtKey;
import de.flexiprovider.core.rsa.interfaces.RSAPrivateKey;
import de.flexiprovider.core.rsa.interfaces.RSAPublicKey;
import de.flexiprovider.pki.AlgorithmIdentifier;

public final class PKCS1Operations {
    private static final PKCS1Exception encryptionError = new PKCS1Exception("encryption error");
    private static final PKCS1Exception decryptionError = new PKCS1Exception("decryption error");

    private PKCS1Operations() {
    }

    private static byte[] hash(byte[] M, MessageDigest md) {
        md.reset();
        if (M != null) {
            md.update(M);
        }
        return md.digest();
    }

    public static byte[] I2OSP(FlexiBigInt x, int xLen) throws PKCS1Exception {
        int len = x.bitLength() + 7 >> 3;
        if (xLen == 0) {
            xLen = len;
        }
        if (len > xLen) {
            throw new PKCS1Exception("integer too large");
        }
        byte[] tmp = x.toByteArray();
        if (tmp.length == xLen) {
            return tmp;
        }
        byte[] X = new byte[xLen];
        if (x.bitLength() >> 3 == xLen && (x.bitLength() & 7) == 0) {
            System.arraycopy(tmp, 1, X, 0, xLen);
        } else {
            System.arraycopy(tmp, 0, X, xLen - tmp.length, tmp.length);
        }
        return X;
    }

    public static FlexiBigInt OS2IP(byte[] X) {
        return new FlexiBigInt(1, X);
    }

    protected static FlexiBigInt RSAEP(RSAPublicKey pubKey, FlexiBigInt m) throws PKCS1Exception {
        FlexiBigInt n = pubKey.getN();
        FlexiBigInt e = pubKey.getE();
        if (m.compareTo(n) > 0 || m.signum() < 0) {
            throw encryptionError;
        }
        if (e.equals(FlexiBigInt.valueOf(3L))) {
            return m.multiply(m).mod(n).multiply(m).mod(n);
        }
        return m.modPow(e, n);
    }

    protected static FlexiBigInt RSADP(RSAPrivateKey privKey, FlexiBigInt c) throws PKCS1Exception {
        FlexiBigInt n = privKey.getN();
        FlexiBigInt d = privKey.getD();
        if (c.compareTo(n) > 0 || c.signum() < 0) {
            throw decryptionError;
        }
        if (privKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey crtKey = (RSAPrivateCrtKey)privKey;
            FlexiBigInt p = crtKey.getP();
            FlexiBigInt q = crtKey.getQ();
            FlexiBigInt dP = crtKey.getDp();
            FlexiBigInt dQ = crtKey.getDq();
            FlexiBigInt qInv = crtKey.getCRTCoeff();
            FlexiBigInt m1 = c.remainder(p).modPow(dP, p);
            FlexiBigInt m2 = c.remainder(q).modPow(dQ, q);
            FlexiBigInt h = qInv.multiply(m1.subtract(m2).remainder(p)).mod(p);
            return h.multiply(q).add(m2);
        }
        return c.modPow(d, n);
    }

    public static byte[] EME_OAEP_ENCODE(byte[] M, byte[] L, int k, MessageDigest md, SecureRandom prng) {
        byte[] lHash = PKCS1Operations.hash(L, md);
        int hLen = lHash.length;
        byte[] DB = new byte[k - hLen - 1];
        System.arraycopy(lHash, 0, DB, 0, hLen);
        DB[DB.length - M.length - 1] = 1;
        System.arraycopy(M, 0, DB, DB.length - M.length, M.length);
        byte[] seed = new byte[hLen];
        prng.nextBytes(seed);
        byte[] dbMask = PKCS1Operations.MGF1(seed, k - hLen - 1, md);
        byte[] maskedDB = ByteUtils.xor(DB, dbMask);
        byte[] seedMask = PKCS1Operations.MGF1(maskedDB, hLen, md);
        byte[] maskedSeed = ByteUtils.xor(seed, seedMask);
        byte[] EM = new byte[k];
        System.arraycopy(maskedSeed, 0, EM, 1, maskedSeed.length);
        System.arraycopy(maskedDB, 0, EM, 1 + maskedSeed.length, maskedDB.length);
        return EM;
    }

    public static byte[] EME_OAEP_DECODE(byte[] EM, byte[] L, int k, MessageDigest md) throws PKCS1Exception {
        boolean error = false;
        byte[] lHash = PKCS1Operations.hash(L, md);
        int hLen = lHash.length;
        byte Y = EM[0];
        byte[] maskedSeed = new byte[hLen];
        byte[] maskedDB = new byte[k - hLen - 1];
        System.arraycopy(EM, 1, maskedSeed, 0, hLen);
        System.arraycopy(EM, 1 + hLen, maskedDB, 0, k - hLen - 1);
        byte[] seedMask = PKCS1Operations.MGF1(maskedDB, hLen, md);
        byte[] seed = ByteUtils.xor(maskedSeed, seedMask);
        byte[] dbMask = PKCS1Operations.MGF1(seed, k - hLen - 1, md);
        byte[] DB = ByteUtils.xor(maskedDB, dbMask);
        byte[] lHash2 = new byte[hLen];
        System.arraycopy(DB, 0, lHash2, 0, hLen);
        int pos = hLen;
        while (DB[pos] != 1 && pos < DB.length - 1) {
            if (DB[pos] != 0) {
                error = true;
            }
            ++pos;
        }
        if (DB[pos] != 1) {
            error = true;
        }
        byte[] M = new byte[DB.length - pos - 1];
        System.arraycopy(DB, pos + 1, M, 0, DB.length - pos - 1);
        if (!ByteUtils.equals(lHash, lHash2) || Y != 0 || error) {
            throw decryptionError;
        }
        return M;
    }

    public static byte[] EMSA_PSS_ENCODE(byte[] M, int emBits, MessageDigest md, byte[] salt) throws PKCS1Exception {
        int hLen = md.getDigestLength();
        int emLen = emBits + 7 >> 3;
        int sLen = salt.length;
        if ((long)M.length > 0x1FFFFFFFFFFFFFFFL) {
            throw new PKCS1Exception("message too long");
        }
        byte[] mHash = PKCS1Operations.hash(M, md);
        if (emLen < hLen + sLen + 2) {
            throw new PKCS1Exception("encoding error");
        }
        byte[] M2 = new byte[8 + hLen + sLen];
        System.arraycopy(mHash, 0, M2, 8, hLen);
        System.arraycopy(salt, 0, M2, 8 + hLen, sLen);
        byte[] H = PKCS1Operations.hash(M2, md);
        byte[] DB = new byte[emLen - hLen - 1];
        DB[DB.length - sLen - 1] = 1;
        System.arraycopy(salt, 0, DB, DB.length - sLen, sLen);
        byte[] dbMask = PKCS1Operations.MGF1(H, emLen - hLen - 1, md);
        byte[] maskedDB = ByteUtils.xor(DB, dbMask);
        maskedDB[0] = (byte)(maskedDB[0] & (1 << 8 - (8 * emLen - emBits)) - 1);
        byte[] EM = new byte[emLen];
        System.arraycopy(maskedDB, 0, EM, 0, maskedDB.length);
        System.arraycopy(H, 0, EM, maskedDB.length, hLen);
        EM[EM.length - 1] = -68;
        return EM;
    }

    public static boolean EMSA_PSS_VERIFY(byte[] M, byte[] EM, int emBits, MessageDigest md) {
        int hLen = md.getDigestLength();
        int emLen = EM.length;
        if ((long)M.length > 0x1FFFFFFFFFFFFFFFL) {
            return false;
        }
        byte[] mHash = PKCS1Operations.hash(M, md);
        if (emLen < hLen + 2 || (EM[emLen - 1] & 0xFF) != 188) {
            return false;
        }
        byte[] maskedDB = new byte[emLen - hLen - 1];
        byte[] H = new byte[hLen];
        System.arraycopy(EM, 0, maskedDB, 0, maskedDB.length);
        System.arraycopy(EM, maskedDB.length, H, 0, H.length);
        int bitMask = (1 << 8 - (8 * emLen - emBits)) - 1;
        if ((maskedDB[0] & ~bitMask) != 0) {
            return false;
        }
        byte[] dbMask = PKCS1Operations.MGF1(H, emLen - hLen - 1, md);
        byte[] DB = ByteUtils.xor(maskedDB, dbMask);
        DB[0] = (byte)(DB[0] & bitMask);
        int i = 0;
        while (DB[i] == 0 && i < DB.length - 1) {
            ++i;
        }
        if (DB[i++] != 1) {
            return false;
        }
        int sLen = DB.length - i;
        if (emLen < hLen + sLen + 2) {
            return false;
        }
        byte[] M2 = new byte[8 + hLen + sLen];
        System.arraycopy(mHash, 0, M2, 8, hLen);
        System.arraycopy(DB, i, M2, 8 + hLen, sLen);
        byte[] H2 = PKCS1Operations.hash(M2, md);
        return ByteUtils.equals(H, H2);
    }

    public static byte[] EMSA_PKCS1_v1_5_ENCODE(byte[] H, int emLen, AlgorithmIdentifier aid) throws PKCS1Exception {
        DigestInfo digestInfo = new DigestInfo((codec.x509.AlgorithmIdentifier)aid, H);
        byte[] T = ASN1Tools.derEncode((ASN1Type)digestInfo);
        int tLen = T.length;
        if (emLen < tLen) {
            throw new PKCS1Exception("intended encoded message length too short.");
        }
        byte[] EM = new byte[emLen];
        EM[0] = 0;
        EM[1] = 1;
        int i = 2;
        while (i < emLen - tLen - 1) {
            EM[i] = -1;
            ++i;
        }
        EM[i] = 0;
        System.arraycopy(T, 0, EM, emLen - tLen, tLen);
        return EM;
    }

    public static byte[] MGF1(byte[] seed, int length, MessageDigest md) {
        int digestLength = md.getDigestLength();
        int end = length / digestLength;
        byte[] c = new byte[4];
        byte[] out = new byte[length];
        md.reset();
        int counter = 0;
        while (counter <= end) {
            c[0] = (byte)(counter >> 24 & 0xFF);
            c[1] = (byte)(counter >> 16 & 0xFF);
            c[2] = (byte)(counter >> 8 & 0xFF);
            c[3] = (byte)(counter & 0xFF);
            md.update(seed);
            byte[] digest = md.digest(c);
            if (counter < end) {
                System.arraycopy(digest, 0, out, counter * digestLength, digestLength);
            } else {
                System.arraycopy(digest, 0, out, counter * digestLength, length - counter * digestLength);
            }
            ++counter;
        }
        return out;
    }
}

