/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rsa;

import de.flexiprovider.api.parameters.AlgorithmParameterSpec;

public class PSSParameterSpec
implements AlgorithmParameterSpec {
    public static final String DEFAULT_MD = "1.3.14.3.2.26";
    public static final String DEFAULT_MGF = "1.2.840.113549.1.1.8";
    public static final int DEFAULT_SALT_LENGTH = 20;
    public static final int DEFAULT_TRAILER_FIELD = 1;
    private String md;
    private int saltLength;

    public PSSParameterSpec() {
        this.md = DEFAULT_MD;
        this.saltLength = 20;
    }

    public PSSParameterSpec(String md, int saltLength) {
        this.md = md == null ? DEFAULT_MD : md;
        this.saltLength = saltLength < 0 ? 20 : saltLength;
    }

    public String getMD() {
        return this.md;
    }

    public int getSaltLength() {
        return this.saltLength;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof PSSParameterSpec)) {
            return false;
        }
        PSSParameterSpec otherSpec = (PSSParameterSpec)other;
        return this.md.equals(otherSpec.md) && this.saltLength == otherSpec.saltLength;
    }

    public int hashCode() {
        return this.md.hashCode() + DEFAULT_MGF.hashCode() + this.saltLength + 1;
    }

    public String toString() {
        String result = "PSS parameters:\n";
        result = result + "MD OID       : " + this.md + "\n";
        result = result + "MGF OID      : 1.2.840.113549.1.1.8\n";
        result = result + "salt length  : " + this.saltLength + "\n";
        result = result + "trailer field: 1\n";
        return result;
    }

    public static final class SHA256
    extends PSSParameterSpec {
        public SHA256() {
            super("2.16.840.1.101.3.4.2.1", 32);
        }
    }

    public static final class SHA1
    extends PSSParameterSpec {
        public SHA1() {
            super(PSSParameterSpec.DEFAULT_MD, 20);
        }
    }
}

