/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rsa;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.KeyPair;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.core.rsa.RSAKeyGenParameterSpec;
import de.flexiprovider.core.rsa.RSAPrivateCrtKey;
import de.flexiprovider.core.rsa.RSAPublicKey;

public final class RSAKeyPairGenerator
extends de.flexiprovider.core.rsa.interfaces.RSAKeyPairGenerator {
    private static final int CERTAINTY = 80;
    private static final FlexiBigInt ONE = FlexiBigInt.ONE;
    private int keySize;
    private FlexiBigInt e;
    private SecureRandom random = Registry.getSecureRandom();
    private boolean initialized;

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        RSAKeyGenParameterSpec rsaParams;
        if (params == null) {
            rsaParams = new RSAKeyGenParameterSpec();
        } else if (params instanceof RSAKeyGenParameterSpec) {
            rsaParams = (RSAKeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = rsaParams.getKeySize();
        this.e = rsaParams.getE();
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void initialize(int keySize, SecureRandom random) {
        RSAKeyGenParameterSpec params = new RSAKeyGenParameterSpec(keySize);
        try {
            this.initialize(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    private void initializeDefault() {
        RSAKeyGenParameterSpec defaultParams = new RSAKeyGenParameterSpec();
        try {
            this.initialize(defaultParams, Registry.getSecureRandom());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public KeyPair genKeyPair() {
        FlexiBigInt qm;
        FlexiBigInt pm;
        FlexiBigInt q;
        FlexiBigInt p;
        FlexiBigInt phi;
        FlexiBigInt n;
        if (!this.initialized) {
            this.initializeDefault();
        }
        int bitsp = this.keySize + 1 >> 1;
        int bitsq = this.keySize - bitsp;
        do {
            p = new FlexiBigInt(bitsp, 80, this.random);
            while (p.equals(q = new FlexiBigInt(bitsq, 80, this.random))) {
            }
            n = p.multiply(q);
            pm = p.subtract(ONE);
            qm = q.subtract(ONE);
            phi = pm.multiply(qm);
        } while (n.bitLength() < this.keySize || this.e.gcd(phi).compareTo(ONE) != 0);
        FlexiBigInt d = this.e.modInverse(phi);
        FlexiBigInt dp = d.mod(pm);
        FlexiBigInt dq = d.mod(qm);
        FlexiBigInt crt = q.modInverse(p);
        RSAPublicKey pubKey = new RSAPublicKey(n, this.e);
        RSAPrivateCrtKey privKey = new RSAPrivateCrtKey(n, this.e, d, p, q, dp, dq, crt);
        return new KeyPair(pubKey, privKey);
    }
}

