/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rsa;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.Signature;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.SignatureException;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ByteUtils;
import de.flexiprovider.core.md.NullDigest;
import de.flexiprovider.core.rsa.PKCS1Exception;
import de.flexiprovider.core.rsa.PKCS1Operations;
import de.flexiprovider.core.rsa.interfaces.RSAPrivateKey;
import de.flexiprovider.core.rsa.interfaces.RSAPublicKey;
import de.flexiprovider.pki.AlgorithmIdentifier;

public abstract class RSASignaturePKCS1v15
extends Signature {
    private MessageDigest md;
    private AlgorithmIdentifier aid;
    private RSAPublicKey pubKey;
    private RSAPrivateKey privKey;
    private int modBitLen;

    protected RSASignaturePKCS1v15(String oidStr, MessageDigest md) {
        try {
            this.aid = new AlgorithmIdentifier(new ASN1ObjectIdentifier(oidStr), (ASN1Type)new ASN1Null());
        }
        catch (ASN1Exception ae) {
            throw new RuntimeException("Internal error in CoDec.");
        }
        this.md = md;
    }

    public void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("key is not a RSAPrivateKey.");
        }
        this.privKey = (RSAPrivateKey)privateKey;
        this.modBitLen = this.privKey.getN().bitLength();
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("key is not a RSAPublicKey.");
        }
        this.pubKey = (RSAPublicKey)publicKey;
        this.modBitLen = this.pubKey.getN().bitLength();
    }

    public void setParameters(AlgorithmParameterSpec params) {
    }

    public void update(byte[] b, int offset, int length) {
        this.md.update(b, offset, length);
    }

    public void update(byte b) {
        this.md.update(b);
    }

    public byte[] sign() throws SignatureException {
        FlexiBigInt s;
        byte[] EM;
        int k = this.modBitLen + 7 >> 3;
        try {
            EM = PKCS1Operations.EMSA_PKCS1_v1_5_ENCODE(this.md.digest(), k, this.aid);
        }
        catch (PKCS1Exception pkcs1e) {
            throw new SignatureException(pkcs1e.getMessage());
        }
        FlexiBigInt m = PKCS1Operations.OS2IP(EM);
        try {
            s = PKCS1Operations.RSADP(this.privKey, m);
        }
        catch (PKCS1Exception pkcs1e) {
            throw new SignatureException("encoding error.");
        }
        try {
            return PKCS1Operations.I2OSP(s, k);
        }
        catch (PKCS1Exception pkcs1e) {
            throw new SignatureException("internal error.");
        }
    }

    public boolean verify(byte[] signature) {
        byte[] EM2;
        byte[] EM;
        int k = this.modBitLen + 7 >> 3;
        if (signature.length != k) {
            return false;
        }
        FlexiBigInt s = PKCS1Operations.OS2IP(signature);
        try {
            FlexiBigInt m = PKCS1Operations.RSAEP(this.pubKey, s);
            EM = PKCS1Operations.I2OSP(m, k);
            EM2 = PKCS1Operations.EMSA_PKCS1_v1_5_ENCODE(this.md.digest(), k, this.aid);
        }
        catch (PKCS1Exception pkcs1e) {
            return false;
        }
        return ByteUtils.equals(EM, EM2);
    }

    public static class RawRIPEMD160
    extends RSASignaturePKCS1v15 {
        public RawRIPEMD160() {
            super("1.3.36.3.2.1", new NullDigest());
        }
    }

    public static class RawSHA512
    extends RSASignaturePKCS1v15 {
        public RawSHA512() {
            super("2.16.840.1.101.3.4.2.3", new NullDigest());
        }
    }

    public static class RawSHA384
    extends RSASignaturePKCS1v15 {
        public RawSHA384() {
            super("2.16.840.1.101.3.4.2.2", new NullDigest());
        }
    }

    public static class RawSHA256
    extends RSASignaturePKCS1v15 {
        public RawSHA256() {
            super("2.16.840.1.101.3.4.2.1", new NullDigest());
        }
    }

    public static class RawSHA224
    extends RSASignaturePKCS1v15 {
        public RawSHA224() {
            super("2.16.840.1.101.3.4.2.4", new NullDigest());
        }
    }

    public static class RawSHA1
    extends RSASignaturePKCS1v15 {
        public RawSHA1() {
            super("1.3.14.3.2.26", new NullDigest());
        }
    }

    public static class RawMD5
    extends RSASignaturePKCS1v15 {
        public RawMD5() {
            super("1.2.840.113549.2.5", new NullDigest());
        }
    }

    public static class RIPEMD160
    extends RSASignaturePKCS1v15 {
        public static final String OID = "1.3.36.3.3.1.2";

        public RIPEMD160() {
            super("1.3.36.3.2.1", new de.flexiprovider.core.md.RIPEMD160());
        }
    }

    public static class SHA512
    extends RSASignaturePKCS1v15 {
        public static final String OID = "1.2.840.113549.1.1.13";

        public SHA512() {
            super("2.16.840.1.101.3.4.2.3", new de.flexiprovider.core.md.SHA512());
        }
    }

    public static class SHA384
    extends RSASignaturePKCS1v15 {
        public static final String OID = "1.2.840.113549.1.1.12";

        public SHA384() {
            super("2.16.840.1.101.3.4.2.2", new de.flexiprovider.core.md.SHA384());
        }
    }

    public static class SHA256
    extends RSASignaturePKCS1v15 {
        public static final String OID = "1.2.840.113549.1.1.11";

        public SHA256() {
            super("2.16.840.1.101.3.4.2.1", new de.flexiprovider.core.md.SHA256());
        }
    }

    public static class SHA224
    extends RSASignaturePKCS1v15 {
        public static final String OID = "1.2.840.113549.1.1.14";

        public SHA224() {
            super("2.16.840.1.101.3.4.2.4", new de.flexiprovider.core.md.SHA224());
        }
    }

    public static class SHA1
    extends RSASignaturePKCS1v15 {
        public static final String OID = "1.2.840.113549.1.1.5";
        public static final String ALTERNATIVE_OID = "1.3.14.3.2.29";

        public SHA1() {
            super("1.3.14.3.2.26", new de.flexiprovider.core.md.SHA1());
        }
    }

    public static class MD5
    extends RSASignaturePKCS1v15 {
        public static final String OID = "1.2.840.113549.1.1.4";
        public static final String ALTERNATIVE_OID = "1.3.14.3.2.25";

        public MD5() {
            super("1.2.840.113549.2.5", new de.flexiprovider.core.md.MD5());
        }
    }
}

