/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rsa;

import de.flexiprovider.api.AsymmetricBlockCipher;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.BadPaddingException;
import de.flexiprovider.api.exceptions.IllegalBlockSizeException;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.core.rsa.PKCS1Exception;
import de.flexiprovider.core.rsa.PKCS1Operations;
import de.flexiprovider.core.rsa.interfaces.RSAKey;
import de.flexiprovider.core.rsa.interfaces.RSAPrivateCrtKey;
import de.flexiprovider.core.rsa.interfaces.RSAPrivateKey;
import de.flexiprovider.core.rsa.interfaces.RSAPublicKey;

public class RSA_PKCS1_v1_5
extends AsymmetricBlockCipher {
    public static final String OID = "1.2.840.113549.1.1.1";
    private static final int HEADER_SIZE = 11;
    private SecureRandom secureRandom;
    private byte blocktype;
    private RSAPublicKey pubKey;
    private RSAPrivateKey privKey;

    public String getName() {
        return "RSA_PKCS1_v1_5";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (key instanceof RSAKey) {
            return ((RSAKey)((Object)key)).getN().bitLength();
        }
        throw new InvalidKeyException("RSA_PKCS1_v1_5: the key is not suitable for RSA the algorithm.");
    }

    protected void initCipherEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException("RSA_PKCS1_v1_5: the key is not suitable for RSA encryption.");
        }
        this.pubKey = (RSAPublicKey)key;
        this.blocktype = (byte)2;
        this.secureRandom = secureRandom != null ? secureRandom : Registry.getSecureRandom();
        this.cipherTextSize = this.pubKey.getN().bitLength() + 7 >> 3;
        this.maxPlainTextSize = this.cipherTextSize - 11;
        if (this.maxPlainTextSize <= 0) {
            throw new InvalidAlgorithmParameterException("Illegal modulus size.");
        }
    }

    protected void initCipherDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof RSAPrivateCrtKey) && !(key instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("RSA_PKCS1_v1_5: the key is not suitable for RSA decryption.");
        }
        this.privKey = (RSAPrivateKey)key;
        this.blocktype = (byte)2;
        this.cipherTextSize = this.privKey.getN().bitLength() + 7 >> 3;
        this.maxPlainTextSize = this.cipherTextSize - 11;
        if (this.maxPlainTextSize <= 0) {
            throw new InvalidAlgorithmParameterException("Illegal modulus size.");
        }
    }

    protected byte[] messageEncrypt(byte[] input) throws BadPaddingException {
        FlexiBigInt x = null;
        FlexiBigInt bigInt = null;
        int padLength = 0;
        int inLength = 0;
        byte[] cBytes = null;
        byte[] m = null;
        byte[] ps = null;
        m = new byte[this.cipherTextSize];
        m[0] = 0;
        m[1] = this.blocktype;
        padLength = 8;
        inLength = input.length;
        if (inLength < this.maxPlainTextSize) {
            padLength += this.maxPlainTextSize - inLength;
        }
        ps = new byte[padLength];
        this.secureRandom.nextBytes(ps);
        int i = padLength;
        while (--i >= 0) {
            if (ps[i] != 0) continue;
            ps[i] = (byte)(i % 254 + 1);
        }
        System.arraycopy(ps, 0, m, 2, padLength);
        m[padLength + 2] = 0;
        System.arraycopy(input, 0, m, padLength + 3, inLength);
        bigInt = new FlexiBigInt(1, m);
        try {
            x = PKCS1Operations.RSAEP(this.pubKey, bigInt);
            cBytes = PKCS1Operations.I2OSP(x, this.cipherTextSize);
        }
        catch (PKCS1Exception pkcs1ex) {
            throw new BadPaddingException("PKCS1Exception: " + pkcs1ex.getMessage());
        }
        return cBytes;
    }

    protected byte[] messageDecrypt(byte[] input) throws IllegalBlockSizeException, BadPaddingException {
        if (this.cipherTextSize != input.length) {
            throw new IllegalBlockSizeException("RSA_PKCS1_v1_5 decryption error: the length of the input is not equal to the expected ciphertext length.");
        }
        if (this.cipherTextSize < 11) {
            throw new IllegalBlockSizeException("RSA_PKCS1_v1_5 decryption error: the length of the header is greaterthan the expected ciphertext length.");
        }
        byte[] cBytes = new byte[this.cipherTextSize];
        System.arraycopy(input, 0, cBytes, 0, this.cipherTextSize);
        FlexiBigInt c = PKCS1Operations.OS2IP(cBytes);
        FlexiBigInt m = null;
        byte[] mBytes = null;
        try {
            m = PKCS1Operations.RSADP(this.privKey, c);
            mBytes = PKCS1Operations.I2OSP(m, this.cipherTextSize);
        }
        catch (PKCS1Exception pkcs1ex) {
            throw new BadPaddingException("PKCS1Exception: " + pkcs1ex.getMessage());
        }
        if (mBytes[1] != 2) {
            throw new BadPaddingException("RSA_PKCS1_v1_5 decrpytion error: wrong blocktype (should be 0x02).");
        }
        int i = 2;
        while (mBytes[i] != 0) {
            ++i;
        }
        if (i < 10) {
            throw new BadPaddingException("RSA_PKCS1_v1_5 decryption error: the header does not match the expected header.");
        }
        int cSizeI = this.cipherTextSize - ++i;
        byte[] out = new byte[cSizeI];
        System.arraycopy(mBytes, i, out, 0, cSizeI);
        return out;
    }
}

