/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rsa;

import de.flexiprovider.api.AsymmetricBlockCipher;
import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.Signature;
import de.flexiprovider.api.exceptions.BadPaddingException;
import de.flexiprovider.api.exceptions.IllegalBlockSizeException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.SignatureException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.md.MD5;
import de.flexiprovider.core.md.SHA1;
import de.flexiprovider.core.rsa.RSA_PKCS1_v1_5;

public class SSLSignature
extends Signature {
    private SecureRandom secureRandom_;
    private MessageDigest mdMD5_;
    private MessageDigest mdSHA1_;
    private AsymmetricBlockCipher cipher_;

    private void initCommon() {
        this.mdSHA1_ = new SHA1();
        this.mdMD5_ = new MD5();
        this.cipher_ = new RSA_PKCS1_v1_5();
    }

    public void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.secureRandom_ = secureRandom;
        this.cipher_.initEncrypt((Key)privateKey, this.secureRandom_);
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.initCommon();
        this.cipher_.initDecrypt(publicKey);
    }

    public void setParameters(AlgorithmParameterSpec params) {
    }

    public void update(byte[] b, int offset, int length) {
        this.mdMD5_.update(b, offset, length);
        this.mdSHA1_.update(b, offset, length);
    }

    public void update(byte b) {
        this.mdMD5_.update(b);
        this.mdSHA1_.update(b);
    }

    public byte[] sign() throws SignatureException {
        byte[] out = null;
        byte[] shaMBytes = this.mdSHA1_.digest();
        byte[] mdMBytes = this.mdMD5_.digest();
        byte[] plainSig = new byte[36];
        System.arraycopy(mdMBytes, 0, plainSig, 0, 16);
        System.arraycopy(shaMBytes, 0, plainSig, 16, 20);
        try {
            out = this.cipher_.doFinal(plainSig);
            return out;
        }
        catch (IllegalBlockSizeException ibse) {
            throw new SignatureException("SSLSignature: failure in cipher.doFinal() (illegal block size)");
        }
        catch (BadPaddingException bpe) {
            throw new SignatureException("SSLSignature: failure in cipher.doFinal() (bad padding)");
        }
    }

    public boolean verify(byte[] signature) {
        byte[] shaMBytes = this.mdSHA1_.digest();
        byte[] mdMBytes = this.mdMD5_.digest();
        try {
            byte[] plain = this.cipher_.doFinal(signature);
            int i = 0;
            while (i < 16) {
                if (plain[i] != mdMBytes[i]) {
                    return false;
                }
                if (plain[16 + i] != shaMBytes[i]) {
                    return false;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < 4) {
                if (plain[32 + i2] != shaMBytes[16 + i2]) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        catch (IllegalBlockSizeException ibse) {
            System.err.println("RSASignature: cipher.doFinal");
            ibse.printStackTrace();
        }
        catch (BadPaddingException bpe) {
            System.err.println("RSASignature: cipher.doFinal");
            bpe.printStackTrace();
        }
        return false;
    }
}

