/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rsa.interfaces;

import de.flexiprovider.api.keys.KeyFactory;
import de.flexiprovider.api.keys.KeySpec;
import de.flexiprovider.core.rsa.RSAPrivateCrtKeySpec;
import de.flexiprovider.core.rsa.RSAPrivateKeySpec;
import de.flexiprovider.core.rsa.RSAPublicKeySpec;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;

public abstract class RSAKeyFactory
extends KeyFactory {
    protected PublicKey engineGeneratePublic(java.security.spec.KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec != null && !(keySpec instanceof KeySpec) && keySpec instanceof java.security.spec.RSAPublicKeySpec) {
            RSAPublicKeySpec rsaKeySpec = new RSAPublicKeySpec((java.security.spec.RSAPublicKeySpec)keySpec);
            return super.engineGeneratePublic(rsaKeySpec);
        }
        return super.engineGeneratePublic(keySpec);
    }

    protected PrivateKey engineGeneratePrivate(java.security.spec.KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec != null && !(keySpec instanceof KeySpec)) {
            if (keySpec instanceof java.security.spec.RSAPrivateCrtKeySpec) {
                RSAPrivateCrtKeySpec rsaKeySpec = new RSAPrivateCrtKeySpec((java.security.spec.RSAPrivateCrtKeySpec)keySpec);
                return super.engineGeneratePrivate(rsaKeySpec);
            }
            if (keySpec instanceof java.security.spec.RSAPrivateKeySpec) {
                RSAPrivateKeySpec rsaKeySpec = new RSAPrivateKeySpec((java.security.spec.RSAPrivateKeySpec)keySpec);
                return super.engineGeneratePrivate(rsaKeySpec);
            }
        }
        return super.engineGeneratePrivate(keySpec);
    }
}

