/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.saferplus;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.saferplus.SAFERPlusKey;
import de.flexiprovider.core.saferplus.SAFERPlusKeyGenParameterSpec;

public class SAFERPlusKeyGenerator
extends SecretKeyGenerator {
    private int keySize;
    private SecureRandom random;
    private boolean initialized;

    public void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        SAFERPlusKeyGenParameterSpec saferPlusParams;
        if (params == null) {
            saferPlusParams = new SAFERPlusKeyGenParameterSpec();
        } else if (params instanceof SAFERPlusKeyGenParameterSpec) {
            saferPlusParams = (SAFERPlusKeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = saferPlusParams.getKeySize() >> 3;
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void init(int keySize, SecureRandom random) {
        SAFERPlusKeyGenParameterSpec params = new SAFERPlusKeyGenParameterSpec(keySize);
        try {
            this.init(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public void init(SecureRandom random) {
        SAFERPlusKeyGenParameterSpec defaultParams = new SAFERPlusKeyGenParameterSpec();
        try {
            this.init(defaultParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public SecretKey generateKey() {
        if (!this.initialized) {
            this.init(Registry.getSecureRandom());
        }
        byte[] keyBytes = new byte[this.keySize];
        this.random.nextBytes(keyBytes);
        return new SAFERPlusKey(keyBytes);
    }
}

