/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.saferplusplus;

import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.saferplusplus.SAFERPlusPlusKey;

public class SAFERPlusPlus
extends BlockCipher {
    private static final int blockSize = 16;
    private int rounds;
    private int[] x = new int[16];
    private int[] x2 = new int[16];
    private int[][] subKeys = new int[21][16];
    private int[] expTable = new int[256];
    private int[] logTable = new int[256];
    private int[][] biasTable = new int[22][16];

    public SAFERPlusPlus() {
        this.initCipher();
    }

    public String getName() {
        return "SAFERPlusPlus";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof SAFERPlusPlusKey) && !(key instanceof SecretKeySpec)) {
            throw new InvalidKeyException("not a SAFER+ key.");
        }
        int keyLen = key.getEncoded().length;
        if (keyLen != 16 && keyLen != 32) {
            throw new InvalidKeyException("invalid key size");
        }
        return keyLen << 3;
    }

    public int getCipherBlockSize() {
        return 16;
    }

    protected void initCipherEncrypt(SecretKey key, AlgorithmParameterSpec paramSpec) throws InvalidKeyException {
        if (!(key instanceof SAFERPlusPlusKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        this.keySchedule(key.getEncoded());
    }

    protected void initCipherDecrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        this.initCipherEncrypt(key, params);
    }

    private void keySchedule(byte[] key) throws InvalidKeyException {
        int j;
        int i;
        int[] expandedKey = new int[17];
        if (key.length != 16 && key.length != 32) {
            throw new InvalidKeyException("invalid key size: " + (key.length << 3) + " bits.");
        }
        if (key.length == 16 || key.length == 32) {
            i = 0;
            while (i < 16) {
                expandedKey[i] = key[i] & 0xFF;
                ++i;
            }
        }
        expandedKey[16] = 0;
        i = 0;
        while (i < 16) {
            expandedKey[16] = expandedKey[16] ^ expandedKey[i];
            ++i;
        }
        i = 1;
        while (i <= 21) {
            j = 0;
            while (j < 16) {
                this.subKeys[i - 1][j] = expandedKey[(j + i - 1) % 17] + this.biasTable[i - 1][j] & 0xFF;
                ++j;
            }
            j = 0;
            while (j < 17) {
                expandedKey[j] = (expandedKey[j] << 6 | expandedKey[j] >> 2) & 0xFF;
                ++j;
            }
            i += 2;
        }
        if (key.length == 32) {
            i = 0;
            while (i < 16) {
                expandedKey[i] = key[i + 16] & 0xFF;
                ++i;
            }
            this.rounds = 10;
        } else if (key.length == 16) {
            i = 0;
            while (i < 16) {
                expandedKey[i] = key[i] & 0xFF;
                ++i;
            }
            this.rounds = 7;
        }
        expandedKey[16] = 0;
        i = 0;
        while (i < 16) {
            expandedKey[16] = expandedKey[16] ^ expandedKey[i];
            ++i;
        }
        j = 0;
        while (j < 17) {
            expandedKey[j] = (expandedKey[j] << 3 | expandedKey[j] >> 5) & 0xFF;
            ++j;
        }
        i = 2;
        while (i <= 20) {
            j = 0;
            while (j < 16) {
                this.subKeys[i - 1][j] = expandedKey[(j + i - 1) % 17] + this.biasTable[i - 1][j] & 0xFF;
                ++j;
            }
            j = 0;
            while (j < 17) {
                expandedKey[j] = (expandedKey[j] << 6 | expandedKey[j] >> 2) & 0xFF;
                ++j;
            }
            i += 2;
        }
        i = 0;
        while (i < 17) {
            expandedKey[i] = 0;
            ++i;
        }
    }

    protected void singleBlockEncrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        int lastidx = this.rounds << 1;
        int i = 0;
        while (i < 16) {
            this.x[i] = in[inOffset + i] & 0xFF;
            ++i;
        }
        i = 0;
        while (i < this.rounds) {
            this.roundFunctionEncrypt(this.subKeys[i << 1], this.subKeys[(i << 1) + 1]);
            ++i;
        }
        out[outOffset++] = (byte)(this.x[0] ^ this.subKeys[lastidx][0]);
        out[outOffset++] = (byte)(this.x[1] + this.subKeys[lastidx][1]);
        out[outOffset++] = (byte)(this.x[2] + this.subKeys[lastidx][2]);
        out[outOffset++] = (byte)(this.x[3] ^ this.subKeys[lastidx][3]);
        out[outOffset++] = (byte)(this.x[4] ^ this.subKeys[lastidx][4]);
        out[outOffset++] = (byte)(this.x[5] + this.subKeys[lastidx][5]);
        out[outOffset++] = (byte)(this.x[6] + this.subKeys[lastidx][6]);
        out[outOffset++] = (byte)(this.x[7] ^ this.subKeys[lastidx][7]);
        out[outOffset++] = (byte)(this.x[8] ^ this.subKeys[lastidx][8]);
        out[outOffset++] = (byte)(this.x[9] + this.subKeys[lastidx][9]);
        out[outOffset++] = (byte)(this.x[10] + this.subKeys[lastidx][10]);
        out[outOffset++] = (byte)(this.x[11] ^ this.subKeys[lastidx][11]);
        out[outOffset++] = (byte)(this.x[12] ^ this.subKeys[lastidx][12]);
        out[outOffset++] = (byte)(this.x[13] + this.subKeys[lastidx][13]);
        out[outOffset++] = (byte)(this.x[14] + this.subKeys[lastidx][14]);
        out[outOffset] = (byte)(this.x[15] ^ this.subKeys[lastidx][15]);
    }

    protected void singleBlockDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        int lastidx = this.rounds << 1;
        this.x[0] = (input[inOff++] ^ this.subKeys[lastidx][0]) & 0xFF;
        this.x[1] = input[inOff++] - this.subKeys[lastidx][1] & 0xFF;
        this.x[2] = input[inOff++] - this.subKeys[lastidx][2] & 0xFF;
        this.x[3] = (input[inOff++] ^ this.subKeys[lastidx][3]) & 0xFF;
        this.x[4] = (input[inOff++] ^ this.subKeys[lastidx][4]) & 0xFF;
        this.x[5] = input[inOff++] - this.subKeys[lastidx][5] & 0xFF;
        this.x[6] = input[inOff++] - this.subKeys[lastidx][6] & 0xFF;
        this.x[7] = (input[inOff++] ^ this.subKeys[lastidx][7]) & 0xFF;
        this.x[8] = (input[inOff++] ^ this.subKeys[lastidx][8]) & 0xFF;
        this.x[9] = input[inOff++] - this.subKeys[lastidx][9] & 0xFF;
        this.x[10] = input[inOff++] - this.subKeys[lastidx][10] & 0xFF;
        this.x[11] = (input[inOff++] ^ this.subKeys[lastidx][11]) & 0xFF;
        this.x[12] = (input[inOff++] ^ this.subKeys[lastidx][12]) & 0xFF;
        this.x[13] = input[inOff++] - this.subKeys[lastidx][13] & 0xFF;
        this.x[14] = input[inOff++] - this.subKeys[lastidx][14] & 0xFF;
        this.x[15] = (input[inOff++] ^ this.subKeys[lastidx][15]) & 0xFF;
        int i = this.rounds - 1;
        while (i >= 0) {
            this.roundFunctionDecrypt(this.subKeys[(i << 1) + 1], this.subKeys[i << 1]);
            --i;
        }
        i = 0;
        while (i < 16) {
            output[outOff + i] = (byte)this.x[i];
            ++i;
        }
    }

    private void initCipher() {
        int j;
        this.expTable[0] = 1;
        int i = 1;
        while (i < 256) {
            this.expTable[i] = this.expTable[i - 1] * 45 % 257;
            ++i;
        }
        this.expTable[128] = 0;
        i = 0;
        while (i < 256) {
            this.logTable[this.expTable[i]] = i;
            ++i;
        }
        i = 2;
        while (i <= 15) {
            j = 1;
            while (j <= 16) {
                this.biasTable[i - 1][j - 1] = this.expTable[this.expTable[17 * i + j & 0xFF]];
                ++j;
            }
            ++i;
        }
        i = 16;
        while (i <= 21) {
            j = 1;
            while (j <= 16) {
                this.biasTable[i - 1][j - 1] = this.expTable[17 * i + j & 0xFF];
                ++j;
            }
            ++i;
        }
    }

    private void shuffle4PHT(int[] in, int[] out, int inoff1, int inoff2, int inoff3, int inoff4, int outoff) {
        int a = in[inoff1];
        int b = in[inoff2];
        int c = in[inoff3];
        int d = in[inoff4];
        out[outoff] = a + (d += a + b + c) & 0xFF;
        out[outoff + 1] = b + d & 0xFF;
        out[outoff + 2] = c + d & 0xFF;
        out[outoff + 3] = d & 0xFF;
    }

    private void inverseShuffle4IPHT(int[] in, int[] out, int inoff, int outoff1, int outoff2, int outoff3, int outoff4) {
        int a = in[inoff];
        int b = in[inoff + 1];
        int c = in[inoff + 2];
        int d = in[inoff + 3];
        a = a - d & 0xFF;
        b = b - d & 0xFF;
        c = c - d & 0xFF;
        out[outoff1] = a;
        out[outoff2] = b;
        out[outoff3] = c;
        out[outoff4] = d - a - b - c & 0xFF;
    }

    private void roundFunctionEncrypt(int[] subKey1, int[] subKey2) {
        this.x[0] = this.expTable[this.x[0] ^ subKey1[0] & 0xFF] + subKey2[0] & 0xFF;
        this.x[1] = (this.logTable[this.x[1] + subKey1[1] & 0xFF] ^ subKey2[1]) & 0xFF;
        this.x[2] = (this.logTable[this.x[2] + subKey1[2] & 0xFF] ^ subKey2[2]) & 0xFF;
        this.x[3] = this.expTable[this.x[3] ^ subKey1[3] & 0xFF] + subKey2[3] & 0xFF;
        this.x[4] = this.expTable[this.x[4] ^ subKey1[4] & 0xFF] + subKey2[4] & 0xFF;
        this.x[5] = (this.logTable[this.x[5] + subKey1[5] & 0xFF] ^ subKey2[5]) & 0xFF;
        this.x[6] = (this.logTable[this.x[6] + subKey1[6] & 0xFF] ^ subKey2[6]) & 0xFF;
        this.x[7] = this.expTable[this.x[7] ^ subKey1[7] & 0xFF] + subKey2[7] & 0xFF;
        this.x[8] = this.expTable[this.x[8] ^ subKey1[8] & 0xFF] + subKey2[8] & 0xFF;
        this.x[9] = (this.logTable[this.x[9] + subKey1[9] & 0xFF] ^ subKey2[9]) & 0xFF;
        this.x[10] = (this.logTable[this.x[10] + subKey1[10] & 0xFF] ^ subKey2[10]) & 0xFF;
        this.x[11] = this.expTable[this.x[11] ^ subKey1[11] & 0xFF] + subKey2[11] & 0xFF;
        this.x[12] = this.expTable[this.x[12] ^ subKey1[12] & 0xFF] + subKey2[12] & 0xFF;
        this.x[13] = (this.logTable[this.x[13] + subKey1[13] & 0xFF] ^ subKey2[13]) & 0xFF;
        this.x[14] = (this.logTable[this.x[14] + subKey1[14] & 0xFF] ^ subKey2[14]) & 0xFF;
        this.x[15] = this.expTable[this.x[15] ^ subKey1[15] & 0xFF] + subKey2[15] & 0xFF;
        this.shuffle4PHT(this.x, this.x2, 8, 5, 2, 15, 0);
        this.shuffle4PHT(this.x, this.x2, 0, 13, 10, 7, 4);
        this.shuffle4PHT(this.x, this.x2, 4, 1, 14, 11, 8);
        this.shuffle4PHT(this.x, this.x2, 12, 9, 6, 3, 12);
        this.shuffle4PHT(this.x2, this.x, 8, 5, 2, 15, 0);
        this.shuffle4PHT(this.x2, this.x, 0, 13, 10, 7, 4);
        this.shuffle4PHT(this.x2, this.x, 4, 1, 14, 11, 8);
        this.shuffle4PHT(this.x2, this.x, 12, 9, 6, 3, 12);
    }

    private void roundFunctionDecrypt(int[] subKey1, int[] subKey2) {
        this.inverseShuffle4IPHT(this.x, this.x2, 0, 8, 5, 2, 15);
        this.inverseShuffle4IPHT(this.x, this.x2, 4, 0, 13, 10, 7);
        this.inverseShuffle4IPHT(this.x, this.x2, 8, 4, 1, 14, 11);
        this.inverseShuffle4IPHT(this.x, this.x2, 12, 12, 9, 6, 3);
        this.inverseShuffle4IPHT(this.x2, this.x, 0, 8, 5, 2, 15);
        this.inverseShuffle4IPHT(this.x2, this.x, 4, 0, 13, 10, 7);
        this.inverseShuffle4IPHT(this.x2, this.x, 8, 4, 1, 14, 11);
        this.inverseShuffle4IPHT(this.x2, this.x, 12, 12, 9, 6, 3);
        this.x[0] = (this.logTable[this.x[0] - subKey1[0] & 0xFF] ^ subKey2[0]) & 0xFF;
        this.x[1] = this.expTable[this.x[1] ^ subKey1[1] & 0xFF] - subKey2[1] & 0xFF;
        this.x[2] = this.expTable[this.x[2] ^ subKey1[2] & 0xFF] - subKey2[2] & 0xFF;
        this.x[3] = (this.logTable[this.x[3] - subKey1[3] & 0xFF] ^ subKey2[3]) & 0xFF;
        this.x[4] = (this.logTable[this.x[4] - subKey1[4] & 0xFF] ^ subKey2[4]) & 0xFF;
        this.x[5] = this.expTable[this.x[5] ^ subKey1[5] & 0xFF] - subKey2[5] & 0xFF;
        this.x[6] = this.expTable[this.x[6] ^ subKey1[6] & 0xFF] - subKey2[6] & 0xFF;
        this.x[7] = (this.logTable[this.x[7] - subKey1[7] & 0xFF] ^ subKey2[7]) & 0xFF;
        this.x[8] = (this.logTable[this.x[8] - subKey1[8] & 0xFF] ^ subKey2[8]) & 0xFF;
        this.x[9] = this.expTable[this.x[9] ^ subKey1[9] & 0xFF] - subKey2[9] & 0xFF;
        this.x[10] = this.expTable[this.x[10] ^ subKey1[10] & 0xFF] - subKey2[10] & 0xFF;
        this.x[11] = (this.logTable[this.x[11] - subKey1[11] & 0xFF] ^ subKey2[11]) & 0xFF;
        this.x[12] = (this.logTable[this.x[12] - subKey1[12] & 0xFF] ^ subKey2[12]) & 0xFF;
        this.x[13] = this.expTable[this.x[13] ^ subKey1[13] & 0xFF] - subKey2[13] & 0xFF;
        this.x[14] = this.expTable[this.x[14] ^ subKey1[14] & 0xFF] - subKey2[14] & 0xFF;
        this.x[15] = (this.logTable[this.x[15] - subKey1[15] & 0xFF] ^ subKey2[15]) & 0xFF;
    }
}

