/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.saferplusplus;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.saferplusplus.SAFERPlusPlusKey;
import de.flexiprovider.core.saferplusplus.SAFERPlusPlusKeyGenParameterSpec;

public class SAFERPlusPlusKeyGenerator
extends SecretKeyGenerator {
    private int keySize;
    private SecureRandom random;
    private boolean initialized;

    public void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        SAFERPlusPlusKeyGenParameterSpec saferPlusPlusParams;
        if (params == null) {
            saferPlusPlusParams = new SAFERPlusPlusKeyGenParameterSpec();
        } else if (params instanceof SAFERPlusPlusKeyGenParameterSpec) {
            saferPlusPlusParams = (SAFERPlusPlusKeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = saferPlusPlusParams.getKeySize() >> 3;
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void init(int keySize, SecureRandom random) {
        SAFERPlusPlusKeyGenParameterSpec params = new SAFERPlusPlusKeyGenParameterSpec(keySize);
        try {
            this.init(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public void init(SecureRandom random) {
        SAFERPlusPlusKeyGenParameterSpec defaultParams = new SAFERPlusPlusKeyGenParameterSpec();
        try {
            this.init(defaultParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public SecretKey generateKey() {
        if (!this.initialized) {
            this.init(Registry.getSecureRandom());
        }
        byte[] keyBytes = new byte[this.keySize];
        this.random.nextBytes(keyBytes);
        return new SAFERPlusPlusKey(keyBytes);
    }
}

