/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.serpent;

import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.NoSuchModeException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.serpent.SerpentKey;

public class Serpent
extends BlockCipher {
    public static final String OID = "1.3.6.1.4.1.11591.13.2";
    private static final int blockSize = 16;
    private int keySize;
    private boolean keySizeIsMutable;
    private int[] K = new int[132];

    protected Serpent(String modeName, int keySize) {
        this.keySize = keySize;
        this.keySizeIsMutable = false;
        try {
            this.setMode(modeName);
        }
        catch (NoSuchModeException e) {
            throw new RuntimeException("Internal error: could not find mode '" + modeName + "'.");
        }
    }

    public Serpent() {
        this.keySizeIsMutable = true;
    }

    public String getName() {
        return "Serpent";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof SerpentKey) && !(key instanceof SecretKeySpec)) {
            throw new InvalidKeyException("not a Serpent Key");
        }
        int keySize = key.getEncoded().length;
        if (keySize > 32 || (keySize & 3) != 0) {
            throw new InvalidKeyException("invalid key size");
        }
        return keySize;
    }

    public int getCipherBlockSize() {
        return 16;
    }

    protected void initCipherEncrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (!(key instanceof SerpentKey)) {
            throw new InvalidKeyException("not a Serpent Key");
        }
        byte[] keyBytes = key.getEncoded();
        if (this.keySizeIsMutable) {
            this.keySize = keyBytes.length << 3;
        } else if (keyBytes.length != this.keySize >> 3) {
            throw new InvalidKeyException("key size does not match specified length.");
        }
        this.keyExpansion(keyBytes);
    }

    protected void initCipherDecrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        this.initCipherEncrypt(key, params);
    }

    private void keyExpansion(byte[] key) {
        int t15;
        int t14;
        int t12;
        int t10;
        int t9;
        int t8;
        int t6;
        int t5;
        int t4;
        int t3;
        int t2;
        int t1;
        int tmp;
        int R = -1640531527;
        int offset = 0;
        int n = key.length / 4;
        int i = 0;
        while (i < n) {
            this.K[i] = key[offset++] & 0xFF | (key[offset++] & 0xFF) << 8 | (key[offset++] & 0xFF) << 16 | (key[offset++] & 0xFF) << 24;
            ++i;
        }
        if (n < 8) {
            this.K[i++] = 1;
        }
        while (i < 8) {
            this.K[i++] = 0;
        }
        i = 8;
        while (i < 16) {
            tmp = this.K[i - 8] ^ this.K[i - 5] ^ this.K[i - 3] ^ this.K[i - 1] ^ R ^ i - 8;
            this.K[i] = tmp << 11 | tmp >>> 21;
            ++i;
        }
        i = 8;
        int j = 0;
        while (i < 16) {
            this.K[j] = this.K[i];
            ++i;
            ++j;
        }
        i = 8;
        while (i < 132) {
            tmp = this.K[i - 8] ^ this.K[i - 5] ^ this.K[i - 3] ^ this.K[i - 1] ^ R ^ i;
            this.K[i] = tmp << 11 | tmp >>> 21;
            ++i;
        }
        i = 0;
        while (i < 4) {
            j = i << 5;
            t1 = this.K[j] ^ this.K[j + 1];
            t2 = this.K[j] & this.K[j + 2];
            t3 = this.K[j] | this.K[j + 3];
            t4 = this.K[j + 2] ^ this.K[j + 3];
            t5 = t1 & t3;
            t6 = t2 | t5;
            this.K[j + 2] = t4 ^ t6;
            t8 = this.K[j + 1] ^ t3;
            t9 = t6 ^ t8;
            t10 = t4 & t9;
            this.K[j] = t1 ^ t10;
            t12 = this.K[j + 2] & this.K[j];
            tmp = this.K[j + 1];
            this.K[j + 1] = t9 ^ t12;
            t14 = tmp | this.K[j + 3];
            t15 = t4 ^ t12;
            this.K[j + 3] = t14 ^ t15;
            t1 = ~this.K[j += 4];
            t2 = this.K[j + 1] ^ this.K[j + 3];
            t3 = this.K[j + 2] & t1;
            tmp = this.K[j];
            this.K[j] = t2 ^ t3;
            t5 = this.K[j + 2] ^ t1;
            t6 = this.K[j + 2] ^ this.K[j];
            int t7 = this.K[j + 1] & t6;
            int tmp1 = this.K[j + 3];
            this.K[j + 3] = t5 ^ t7;
            t9 = tmp1 | t7;
            t10 = this.K[j] | t5;
            int t11 = t9 & t10;
            this.K[j + 2] = tmp ^ t11;
            int t13 = tmp1 | t1;
            t14 = t2 ^ this.K[j + 3];
            t15 = this.K[j + 2] ^ t13;
            this.K[j + 1] = t14 ^ t15;
            t1 = ~this.K[j += 4];
            t2 = this.K[j + 1] ^ t1;
            t3 = this.K[j] | t2;
            t4 = this.K[j + 3] | t2;
            t5 = this.K[j + 2] ^ t3;
            this.K[j + 2] = this.K[j + 3] ^ t5;
            t7 = this.K[j + 1] ^ t4;
            t8 = t2 ^ this.K[j + 2];
            t9 = t5 & t7;
            this.K[j + 3] = t8 ^ t9;
            t11 = t5 ^ t7;
            this.K[j + 1] = this.K[j + 3] ^ t11;
            t13 = t11 & t8;
            this.K[j] = t5 ^ t13;
            t1 = this.K[j += 4] ^ this.K[j + 3];
            t2 = this.K[j] & this.K[j + 3];
            t3 = this.K[j + 2] ^ t1;
            t4 = this.K[j + 1] ^ t3;
            this.K[j + 3] = t2 ^ t4;
            t6 = this.K[j + 1] & t1;
            t7 = this.K[j] ^ t6;
            t8 = this.K[j + 2] | t7;
            this.K[j + 2] = t4 ^ t8;
            t10 = ~t3;
            t11 = t3 ^ t7;
            t12 = this.K[j + 3] & t11;
            this.K[j + 1] = t10 ^ t12;
            t14 = ~t7;
            this.K[j] = t12 ^ t14;
            t1 = this.K[(j += 4) + 1] ^ this.K[j + 2];
            t2 = this.K[j + 2] & t1;
            t3 = this.K[j + 3] ^ t2;
            t4 = this.K[j] ^ t3;
            t5 = this.K[j + 3] | t1;
            t6 = t4 & t5;
            this.K[j + 1] = this.K[j + 1] ^ t6;
            t8 = t3 | this.K[j + 1];
            t9 = this.K[j] & t4;
            this.K[j + 3] = t1 ^ t9;
            t11 = t4 ^ t8;
            t12 = this.K[j + 3] & t11;
            this.K[j + 2] = t3 ^ t12;
            t14 = ~t11;
            t15 = this.K[j + 2] & this.K[j + 3];
            this.K[j] = t14 ^ t15;
            t1 = ~this.K[j += 4];
            t2 = this.K[j] ^ this.K[j + 3];
            t3 = this.K[j + 1] ^ t2;
            t4 = t1 | t2;
            t5 = this.K[j + 2] ^ t4;
            this.K[j + 1] = this.K[j + 1] ^ t5;
            t7 = t2 | this.K[j + 1];
            t8 = this.K[j + 3] ^ t7;
            t9 = t5 & t8;
            this.K[j + 2] = t3 ^ t9;
            t11 = t5 ^ t8;
            this.K[j] = this.K[j + 2] ^ t11;
            t13 = ~t5;
            t14 = t3 & t11;
            this.K[j + 3] = t13 ^ t14;
            t1 = ~this.K[j += 4];
            t2 = this.K[j] ^ this.K[j + 1];
            t3 = this.K[j] ^ this.K[j + 3];
            t4 = this.K[j + 2] ^ t1;
            t5 = t2 | t3;
            this.K[j] = t4 ^ t5;
            t7 = this.K[j + 3] & this.K[j];
            t8 = t2 ^ this.K[j];
            tmp = this.K[j + 1];
            this.K[j + 1] = t7 ^ t8;
            t10 = t1 | this.K[j];
            t11 = t2 | t7;
            t12 = t3 ^ t10;
            this.K[j + 2] = t11 ^ t12;
            t14 = tmp ^ t7;
            t15 = this.K[j + 1] & t12;
            this.K[j + 3] = t14 ^ t15;
            t1 = this.K[j += 4] ^ this.K[j + 3];
            t2 = this.K[j + 3] & t1;
            t3 = this.K[j + 2] ^ t2;
            t4 = this.K[j + 1] | t3;
            this.K[j + 3] = t1 ^ t4;
            t6 = ~this.K[j + 1];
            t7 = t1 | t6;
            tmp = this.K[j];
            this.K[j] = t3 ^ t7;
            t9 = tmp & this.K[j];
            t10 = t1 ^ t6;
            t11 = t4 & t10;
            this.K[j + 2] = t9 ^ t11;
            t13 = tmp ^ t3;
            t14 = t10 & this.K[j + 2];
            this.K[j + 1] = t13 ^ t14;
            ++i;
        }
        j = 128;
        t1 = this.K[j] ^ this.K[j + 1];
        t2 = this.K[j] & this.K[j + 2];
        t3 = this.K[j] | this.K[j + 3];
        t4 = this.K[j + 2] ^ this.K[j + 3];
        t5 = t1 & t3;
        t6 = t2 | t5;
        this.K[j + 2] = t4 ^ t6;
        t8 = this.K[j + 1] ^ t3;
        t9 = t6 ^ t8;
        t10 = t4 & t9;
        this.K[j] = t1 ^ t10;
        t12 = this.K[j + 2] & this.K[j];
        tmp = this.K[j + 1];
        this.K[j + 1] = t9 ^ t12;
        t14 = tmp | this.K[j + 3];
        t15 = t4 ^ t12;
        this.K[j + 3] = t14 ^ t15;
    }

    protected void singleBlockEncrypt(byte[] in, int inoffset, byte[] out, int outoffset) {
        int d0 = in[inoffset++] & 0xFF | (in[inoffset++] & 0xFF) << 8 | (in[inoffset++] & 0xFF) << 16 | (in[inoffset++] & 0xFF) << 24;
        int d1 = in[inoffset++] & 0xFF | (in[inoffset++] & 0xFF) << 8 | (in[inoffset++] & 0xFF) << 16 | (in[inoffset++] & 0xFF) << 24;
        int d2 = in[inoffset++] & 0xFF | (in[inoffset++] & 0xFF) << 8 | (in[inoffset++] & 0xFF) << 16 | (in[inoffset++] & 0xFF) << 24;
        int d3 = in[inoffset++] & 0xFF | (in[inoffset++] & 0xFF) << 8 | (in[inoffset++] & 0xFF) << 16 | (in[inoffset++] & 0xFF) << 24;
        int i = 0;
        while (i < 4) {
            int j = i << 5;
            d0 ^= this.K[j++];
            d1 ^= this.K[j++];
            int n = j++;
            int t1 = d0 ^ (d3 ^= this.K[j++]);
            int t2 = d0 & d3;
            int t3 = (d2 ^= this.K[n]) ^ t1;
            int t4 = d1 ^ t3;
            d3 = t2 ^ t4;
            int t6 = d1 & t1;
            int t7 = d0 ^ t6;
            int t8 = d2 | t7;
            d2 = t4 ^ t8;
            int t10 = ~t3;
            int t11 = t3 ^ t7;
            int t12 = d3 & t11;
            d1 = t10 ^ t12;
            int t14 = ~t7;
            d0 = t12 ^ t14;
            d0 = d0 << 13 | d0 >>> 19;
            d2 = d2 << 3 | d2 >>> 29;
            d1 = d1 ^ d0 ^ d2;
            d3 = d3 ^ d2 ^ d0 << 3;
            d1 = d1 << 1 | d1 >>> 31;
            d3 = d3 << 7 | d3 >>> 25;
            d0 = d0 ^ d1 ^ d3;
            d2 = d2 ^ d3 ^ d1 << 7;
            d0 = d0 << 5 | d0 >>> 27;
            d2 = d2 << 22 | d2 >>> 10;
            d0 ^= this.K[j++];
            d1 ^= this.K[j++];
            d2 ^= this.K[j++];
            int n2 = j++;
            t1 = ~d0;
            t2 = d1 ^ t1;
            t3 = d0 | t2;
            t4 = (d3 ^= this.K[n2]) | t2;
            int t5 = d2 ^ t3;
            d2 = d3 ^ t5;
            t7 = d1 ^ t4;
            t8 = t2 ^ d2;
            int t9 = t5 & t7;
            d3 = t8 ^ t9;
            t11 = t5 ^ t7;
            d1 = d3 ^ t11;
            int t13 = t11 & t8;
            d0 = t5 ^ t13;
            d0 = d0 << 13 | d0 >>> 19;
            d2 = d2 << 3 | d2 >>> 29;
            d1 = d1 ^ d0 ^ d2;
            d3 = d3 ^ d2 ^ d0 << 3;
            d1 = d1 << 1 | d1 >>> 31;
            d3 = d3 << 7 | d3 >>> 25;
            d0 = d0 ^ d1 ^ d3;
            d2 = d2 ^ d3 ^ d1 << 7;
            d0 = d0 << 5 | d0 >>> 27;
            d2 = d2 << 22 | d2 >>> 10;
            d0 ^= this.K[j++];
            d1 ^= this.K[j++];
            int n3 = j++;
            int n4 = j++;
            t1 = ~d0;
            t2 = d1 ^ (d3 ^= this.K[n4]);
            t3 = (d2 ^= this.K[n3]) & t1;
            int tmp = d0;
            d0 = t2 ^ t3;
            t5 = d2 ^ t1;
            t6 = d2 ^ d0;
            t7 = d1 & t6;
            int tmp1 = d3;
            d3 = t5 ^ t7;
            t9 = tmp1 | t7;
            t10 = d0 | t5;
            t11 = t9 & t10;
            d2 = tmp ^ t11;
            t13 = tmp1 | t1;
            t14 = t2 ^ d3;
            int t15 = d2 ^ t13;
            d1 = t14 ^ t15;
            d0 = d0 << 13 | d0 >>> 19;
            d2 = d2 << 3 | d2 >>> 29;
            d1 = d1 ^ d0 ^ d2;
            d3 = d3 ^ d2 ^ d0 << 3;
            d1 = d1 << 1 | d1 >>> 31;
            d3 = d3 << 7 | d3 >>> 25;
            d0 = d0 ^ d1 ^ d3;
            d2 = d2 ^ d3 ^ d1 << 7;
            d0 = d0 << 5 | d0 >>> 27;
            d2 = d2 << 22 | d2 >>> 10;
            d0 ^= this.K[j++];
            int n5 = j++;
            int n6 = j++;
            int n7 = j++;
            t1 = d0 ^ (d1 ^= this.K[n5]);
            t2 = d0 & (d2 ^= this.K[n6]);
            t3 = d0 | (d3 ^= this.K[n7]);
            t4 = d2 ^ d3;
            t5 = t1 & t3;
            t6 = t2 | t5;
            d2 = t4 ^ t6;
            t8 = d1 ^ t3;
            t9 = t6 ^ t8;
            t10 = t4 & t9;
            d0 = t1 ^ t10;
            t12 = d2 & d0;
            tmp = d1;
            d1 = t9 ^ t12;
            t14 = tmp | d3;
            t15 = t4 ^ t12;
            d3 = t14 ^ t15;
            d0 = d0 << 13 | d0 >>> 19;
            d2 = d2 << 3 | d2 >>> 29;
            d1 = d1 ^ d0 ^ d2;
            d3 = d3 ^ d2 ^ d0 << 3;
            d1 = d1 << 1 | d1 >>> 31;
            d3 = d3 << 7 | d3 >>> 25;
            d0 = d0 ^ d1 ^ d3;
            d2 = d2 ^ d3 ^ d1 << 7;
            d0 = d0 << 5 | d0 >>> 27;
            d2 = d2 << 22 | d2 >>> 10;
            d0 ^= this.K[j++];
            d1 ^= this.K[j++];
            int n8 = j++;
            t1 = d0 ^ (d3 ^= this.K[j++]);
            t2 = d3 & t1;
            t3 = (d2 ^= this.K[n8]) ^ t2;
            t4 = d1 | t3;
            d3 = t1 ^ t4;
            t6 = ~d1;
            t7 = t1 | t6;
            tmp = d0;
            d0 = t3 ^ t7;
            t9 = tmp & d0;
            t10 = t1 ^ t6;
            t11 = t4 & t10;
            d2 = t9 ^ t11;
            t13 = tmp ^ t3;
            t14 = t10 & d2;
            d1 = t13 ^ t14;
            d0 = d0 << 13 | d0 >>> 19;
            d2 = d2 << 3 | d2 >>> 29;
            d1 = d1 ^ d0 ^ d2;
            d3 = d3 ^ d2 ^ d0 << 3;
            d1 = d1 << 1 | d1 >>> 31;
            d3 = d3 << 7 | d3 >>> 25;
            d0 = d0 ^ d1 ^ d3;
            d2 = d2 ^ d3 ^ d1 << 7;
            d0 = d0 << 5 | d0 >>> 27;
            d2 = d2 << 22 | d2 >>> 10;
            d0 ^= this.K[j++];
            d1 ^= this.K[j++];
            int n9 = j++;
            int n10 = j++;
            t1 = ~d0;
            t2 = d0 ^ d1;
            t3 = d0 ^ (d3 ^= this.K[n10]);
            t4 = (d2 ^= this.K[n9]) ^ t1;
            t5 = t2 | t3;
            d0 = t4 ^ t5;
            t7 = d3 & d0;
            t8 = t2 ^ d0;
            tmp = d1;
            d1 = t7 ^ t8;
            t10 = t1 | d0;
            t11 = t2 | t7;
            t12 = t3 ^ t10;
            d2 = t11 ^ t12;
            t14 = tmp ^ t7;
            t15 = d1 & t12;
            d3 = t14 ^ t15;
            d0 = d0 << 13 | d0 >>> 19;
            d2 = d2 << 3 | d2 >>> 29;
            d1 = d1 ^ d0 ^ d2;
            d3 = d3 ^ d2 ^ d0 << 3;
            d1 = d1 << 1 | d1 >>> 31;
            d3 = d3 << 7 | d3 >>> 25;
            d0 = d0 ^ d1 ^ d3;
            d2 = d2 ^ d3 ^ d1 << 7;
            d0 = d0 << 5 | d0 >>> 27;
            d2 = d2 << 22 | d2 >>> 10;
            d0 ^= this.K[j++];
            d1 ^= this.K[j++];
            d2 ^= this.K[j++];
            int n11 = j++;
            t1 = ~d0;
            t2 = d0 ^ (d3 ^= this.K[n11]);
            t3 = d1 ^ t2;
            t4 = t1 | t2;
            t5 = d2 ^ t4;
            t7 = t2 | (d1 ^= t5);
            t8 = d3 ^ t7;
            t9 = t5 & t8;
            d2 = t3 ^ t9;
            t11 = t5 ^ t8;
            d0 = d2 ^ t11;
            t13 = ~t5;
            t14 = t3 & t11;
            d3 = t13 ^ t14;
            d0 = d0 << 13 | d0 >>> 19;
            d2 = d2 << 3 | d2 >>> 29;
            d1 = d1 ^ d0 ^ d2;
            d3 = d3 ^ d2 ^ d0 << 3;
            d1 = d1 << 1 | d1 >>> 31;
            d3 = d3 << 7 | d3 >>> 25;
            d0 = d0 ^ d1 ^ d3;
            d2 = d2 ^ d3 ^ d1 << 7;
            d0 = d0 << 5 | d0 >>> 27;
            d2 = d2 << 22 | d2 >>> 10;
            d0 ^= this.K[j++];
            int n12 = j++;
            int n13 = j++;
            int n14 = j++;
            t1 = (d1 ^= this.K[n12]) ^ (d2 ^= this.K[n13]);
            t2 = d2 & t1;
            t3 = (d3 ^= this.K[n14]) ^ t2;
            t4 = d0 ^ t3;
            t5 = d3 | t1;
            t6 = t4 & t5;
            t8 = t3 | (d1 ^= t6);
            t9 = d0 & t4;
            d3 = t1 ^ t9;
            t11 = t4 ^ t8;
            t12 = d3 & t11;
            d2 = t3 ^ t12;
            t14 = ~t11;
            t15 = d2 & d3;
            d0 = t14 ^ t15;
            if (i < 3) {
                d0 = d0 << 13 | d0 >>> 19;
                d2 = d2 << 3 | d2 >>> 29;
                d1 = d1 ^ d0 ^ d2;
                d3 = d3 ^ d2 ^ d0 << 3;
                d1 = d1 << 1 | d1 >>> 31;
                d3 = d3 << 7 | d3 >>> 25;
                d0 = d0 ^ d1 ^ d3;
                d2 = d2 ^ d3 ^ d1 << 7;
                d0 = d0 << 5 | d0 >>> 27;
                d2 = d2 << 22 | d2 >>> 10;
            }
            ++i;
        }
        d1 ^= this.K[129];
        d2 ^= this.K[130];
        d3 ^= this.K[131];
        out[outoffset++] = (byte)(d0 ^= this.K[128]);
        out[outoffset++] = (byte)(d0 >> 8);
        out[outoffset++] = (byte)(d0 >> 16);
        out[outoffset++] = (byte)(d0 >> 24);
        out[outoffset++] = (byte)d1;
        out[outoffset++] = (byte)(d1 >> 8);
        out[outoffset++] = (byte)(d1 >> 16);
        out[outoffset++] = (byte)(d1 >> 24);
        out[outoffset++] = (byte)d2;
        out[outoffset++] = (byte)(d2 >> 8);
        out[outoffset++] = (byte)(d2 >> 16);
        out[outoffset++] = (byte)(d2 >> 24);
        out[outoffset++] = (byte)d3;
        out[outoffset++] = (byte)(d3 >> 8);
        out[outoffset++] = (byte)(d3 >> 16);
        out[outoffset++] = (byte)(d3 >> 24);
    }

    protected void singleBlockDecrypt(byte[] in, int inoffset, byte[] out, int outoffset) {
        int d0 = in[inoffset++] & 0xFF | (in[inoffset++] & 0xFF) << 8 | (in[inoffset++] & 0xFF) << 16 | (in[inoffset++] & 0xFF) << 24;
        int d1 = in[inoffset++] & 0xFF | (in[inoffset++] & 0xFF) << 8 | (in[inoffset++] & 0xFF) << 16 | (in[inoffset++] & 0xFF) << 24;
        int d2 = in[inoffset++] & 0xFF | (in[inoffset++] & 0xFF) << 8 | (in[inoffset++] & 0xFF) << 16 | (in[inoffset++] & 0xFF) << 24;
        int d3 = in[inoffset++] & 0xFF | (in[inoffset++] & 0xFF) << 8 | (in[inoffset++] & 0xFF) << 16 | (in[inoffset++] & 0xFF) << 24;
        d0 ^= this.K[128];
        d1 ^= this.K[129];
        d2 ^= this.K[130];
        d3 ^= this.K[131];
        int i = 3;
        while (i >= 0) {
            int j = (i << 5) + 28;
            if (i < 3) {
                d2 = d2 << 10 | d2 >>> 22;
                d0 = d0 << 27 | d0 >>> 5;
                d2 = d2 ^ d3 ^ d1 << 7;
                d0 = d0 ^ d1 ^ d3;
                d3 = d3 << 25 | d3 >>> 7;
                d1 = d1 << 31 | d1 >>> 1;
                d3 = d3 ^ d2 ^ d0 << 3;
                d1 = d1 ^ d0 ^ d2;
                d2 = d2 << 29 | d2 >>> 3;
                d0 = d0 << 19 | d0 >>> 13;
            }
            int t1 = d0 & d1;
            int t2 = d0 | d1;
            int t3 = d2 | t1;
            int t4 = d3 & t2;
            int tmp = d3;
            d3 = t3 ^ t4;
            int t6 = ~tmp;
            int t7 = d1 ^ t4;
            int t8 = d3 ^ t6;
            int t9 = t7 | t8;
            d1 = d0 ^ t9;
            int t11 = d2 ^ t7;
            int t12 = tmp | d1;
            tmp = d0;
            d0 = t11 ^ t12;
            int t14 = tmp & d3;
            int t15 = t3 ^ d1;
            int t16 = d0 ^ t14;
            d2 = t15 ^ t16;
            d0 ^= this.K[j++];
            d1 ^= this.K[j++];
            d2 ^= this.K[j++];
            d3 ^= this.K[j];
            j = (i << 5) + 24;
            d2 = d2 << 10 | d2 >>> 22;
            d0 = d0 << 27 | d0 >>> 5;
            d2 = d2 ^ d3 ^ d1 << 7;
            d0 = d0 ^ d1 ^ d3;
            d3 = d3 << 25 | d3 >>> 7;
            d1 = d1 << 31 | d1 >>> 1;
            d3 = d3 ^ d2 ^ d0 << 3;
            d1 = d1 ^ d0 ^ d2;
            d2 = d2 << 29 | d2 >>> 3;
            d0 = d0 << 19 | d0 >>> 13;
            t1 = ~d0;
            t2 = d0 ^ d1;
            t3 = d2 ^ t2;
            t4 = d2 | t1;
            int t5 = d3 ^ t4;
            tmp = d1;
            d1 = t3 ^ t5;
            t7 = t3 & t5;
            t8 = t2 ^ t7;
            t9 = tmp | t8;
            int tmp1 = d3;
            d3 = t5 ^ t9;
            t11 = tmp | d3;
            d0 = t8 ^ t11;
            int t13 = tmp1 & t1;
            t14 = t3 ^ t11;
            d2 = t13 ^ t14;
            d0 ^= this.K[j++];
            d1 ^= this.K[j++];
            d2 ^= this.K[j++];
            d3 ^= this.K[j];
            j = (i << 5) + 20;
            d2 = d2 << 10 | d2 >>> 22;
            d0 = d0 << 27 | d0 >>> 5;
            d2 = d2 ^ d3 ^ d1 << 7;
            d0 = d0 ^ d1 ^ d3;
            d3 = d3 << 25 | d3 >>> 7;
            d1 = d1 << 31 | d1 >>> 1;
            d3 = d3 ^ d2 ^ d0 << 3;
            d1 = d1 ^ d0 ^ d2;
            d2 = d2 << 29 | d2 >>> 3;
            d0 = d0 << 19 | d0 >>> 13;
            t1 = ~d2;
            t2 = d1 & t1;
            t3 = d3 ^ t2;
            t4 = d0 & t3;
            t5 = d1 ^ t1;
            tmp = d3;
            d3 = t4 ^ t5;
            t7 = d1 | d3;
            t8 = d0 & t7;
            tmp1 = d1;
            d1 = t3 ^ t8;
            int t10 = d0 | tmp;
            t11 = t1 ^ t7;
            tmp = d0;
            d0 = t10 ^ t11;
            t13 = tmp ^ d2;
            t14 = tmp1 & t10;
            t15 = t4 | t13;
            d2 = t14 ^ t15;
            d0 ^= this.K[j++];
            d1 ^= this.K[j++];
            d2 ^= this.K[j++];
            d3 ^= this.K[j];
            j = (i << 5) + 16;
            d2 = d2 << 10 | d2 >>> 22;
            d0 = d0 << 27 | d0 >>> 5;
            d2 = d2 ^ d3 ^ d1 << 7;
            d0 = d0 ^ d1 ^ d3;
            d3 = d3 << 25 | d3 >>> 7;
            d1 = d1 << 31 | d1 >>> 1;
            d3 = d3 ^ d2 ^ d0 << 3;
            d1 = d1 ^ d0 ^ d2;
            d2 = d2 << 29 | d2 >>> 3;
            d0 = d0 << 19 | d0 >>> 13;
            t1 = d2 | d3;
            t2 = d0 & t1;
            t3 = d1 ^ t2;
            t4 = d0 & t3;
            t5 = d2 ^ t4;
            d1 = d3 ^ t5;
            t7 = ~d0;
            t8 = t5 & d1;
            tmp1 = d3;
            d3 = t3 ^ t8;
            t10 = d1 | t7;
            t11 = tmp1 ^ t10;
            d0 = d3 ^ t11;
            t13 = t3 & t11;
            t14 = d1 ^ t7;
            d2 = t13 ^ t14;
            d0 ^= this.K[j++];
            d1 ^= this.K[j++];
            d2 ^= this.K[j++];
            d3 ^= this.K[j];
            j = (i << 5) + 12;
            d2 = d2 << 10 | d2 >>> 22;
            d0 = d0 << 27 | d0 >>> 5;
            d2 = d2 ^ d3 ^ d1 << 7;
            d0 = d0 ^ d1 ^ d3;
            d3 = d3 << 25 | d3 >>> 7;
            d1 = d1 << 31 | d1 >>> 1;
            d3 = d3 ^ d2 ^ d0 << 3;
            d1 = d1 ^ d0 ^ d2;
            d2 = d2 << 29 | d2 >>> 3;
            d0 = d0 << 19 | d0 >>> 13;
            t1 = d0 | d1;
            t2 = d1 ^ d2;
            t3 = d1 & t2;
            t4 = d0 ^ t3;
            t5 = d2 ^ t4;
            t6 = d3 | t4;
            d0 = t2 ^ t6;
            t8 = t2 | t6;
            t9 = d3 ^ t8;
            d2 = t5 ^ t9;
            t11 = t1 ^ t9;
            t12 = d0 & t11;
            d3 = t4 ^ t12;
            t14 = d0 ^ t11;
            d1 = d3 ^ t14;
            d0 ^= this.K[j++];
            d1 ^= this.K[j++];
            d2 ^= this.K[j++];
            d3 ^= this.K[j];
            j = (i << 5) + 8;
            d2 = d2 << 10 | d2 >>> 22;
            d0 = d0 << 27 | d0 >>> 5;
            d2 = d2 ^ d3 ^ d1 << 7;
            d0 = d0 ^ d1 ^ d3;
            d3 = d3 << 25 | d3 >>> 7;
            d1 = d1 << 31 | d1 >>> 1;
            d3 = d3 ^ d2 ^ d0 << 3;
            d1 = d1 ^ d0 ^ d2;
            d2 = d2 << 29 | d2 >>> 3;
            d0 = d0 << 19 | d0 >>> 13;
            t1 = d1 ^ d3;
            t2 = ~t1;
            t3 = d0 ^ d2;
            t4 = d2 ^ t1;
            t5 = d1 & t4;
            tmp = d0;
            d0 = t3 ^ t5;
            t7 = tmp | t2;
            t8 = d3 ^ t7;
            t9 = t3 | t8;
            tmp = d3;
            d3 = t1 ^ t9;
            t11 = ~t4;
            t12 = d0 | d3;
            d1 = t11 ^ t12;
            t14 = tmp & t11;
            t15 = t3 ^ t12;
            d2 = t14 ^ t15;
            d0 ^= this.K[j++];
            d1 ^= this.K[j++];
            d2 ^= this.K[j++];
            d3 ^= this.K[j];
            j = (i << 5) + 4;
            d2 = d2 << 10 | d2 >>> 22;
            d0 = d0 << 27 | d0 >>> 5;
            d2 = d2 ^ d3 ^ d1 << 7;
            d0 = d0 ^ d1 ^ d3;
            d3 = d3 << 25 | d3 >>> 7;
            d1 = d1 << 31 | d1 >>> 1;
            d3 = d3 ^ d2 ^ d0 << 3;
            d1 = d1 ^ d0 ^ d2;
            d2 = d2 << 29 | d2 >>> 3;
            d0 = d0 << 19 | d0 >>> 13;
            t1 = d1 ^ d3;
            t2 = d1 & t1;
            t3 = d0 ^ t2;
            t4 = t1 ^ t3;
            d3 = d2 ^ t4;
            t6 = t1 & t3;
            t7 = d1 ^ t6;
            t8 = d3 | t7;
            d1 = t3 ^ t8;
            t10 = ~d1;
            t11 = d3 ^ t7;
            d0 = t10 ^ t11;
            t13 = t10 | t11;
            d2 = t4 ^ t13;
            d0 ^= this.K[j++];
            d1 ^= this.K[j++];
            d2 ^= this.K[j++];
            d3 ^= this.K[j];
            j = i << 5;
            d2 = d2 << 10 | d2 >>> 22;
            d0 = d0 << 27 | d0 >>> 5;
            d2 = d2 ^ d3 ^ d1 << 7;
            d0 = d0 ^ d1 ^ d3;
            d3 = d3 << 25 | d3 >>> 7;
            d1 = d1 << 31 | d1 >>> 1;
            d3 = d3 ^ d2 ^ d0 << 3;
            d1 = d1 ^ d0 ^ d2;
            d2 = d2 << 29 | d2 >>> 3;
            d0 = d0 << 19 | d0 >>> 13;
            t1 = ~d0;
            t2 = d0 ^ d1;
            t3 = t1 | t2;
            t4 = d3 ^ t3;
            t5 = d2 ^ t4;
            d2 = t2 ^ t5;
            t7 = d3 & t2;
            t8 = t1 ^ t7;
            t9 = d2 & t8;
            d1 = t4 ^ t9;
            t11 = d0 & t4;
            t12 = t5 | d1;
            d3 = t11 ^ t12;
            t14 = t5 ^ t8;
            d0 = d3 ^ t14;
            d0 ^= this.K[j++];
            d1 ^= this.K[j++];
            d2 ^= this.K[j++];
            d3 ^= this.K[j];
            --i;
        }
        out[outoffset++] = (byte)d0;
        out[outoffset++] = (byte)(d0 >> 8);
        out[outoffset++] = (byte)(d0 >> 16);
        out[outoffset++] = (byte)(d0 >> 24);
        out[outoffset++] = (byte)d1;
        out[outoffset++] = (byte)(d1 >> 8);
        out[outoffset++] = (byte)(d1 >> 16);
        out[outoffset++] = (byte)(d1 >> 24);
        out[outoffset++] = (byte)d2;
        out[outoffset++] = (byte)(d2 >> 8);
        out[outoffset++] = (byte)(d2 >> 16);
        out[outoffset++] = (byte)(d2 >> 24);
        out[outoffset++] = (byte)d3;
        out[outoffset++] = (byte)(d3 >> 8);
        out[outoffset++] = (byte)(d3 >> 16);
        out[outoffset++] = (byte)(d3 >> 24);
    }

    public static class Serpent256_CFB
    extends Serpent {
        public static final String OID = "1.3.6.1.4.1.11591.13.2.44";

        public Serpent256_CFB() {
            super("CFB", 8);
        }
    }

    public static class Serpent256_OFB
    extends Serpent {
        public static final String OID = "1.3.6.1.4.1.11591.13.2.43";

        public Serpent256_OFB() {
            super("OFB", 8);
        }
    }

    public static class Serpent256_CBC
    extends Serpent {
        public static final String OID = "1.3.6.1.4.1.11591.13.2.42";

        public Serpent256_CBC() {
            super("CBC", 8);
        }
    }

    public static class Serpent256_ECB
    extends Serpent {
        public static final String OID = "1.3.6.1.4.1.11591.13.2.41";

        public Serpent256_ECB() {
            super("ECB", 8);
        }
    }

    public static class Serpent192_CFB
    extends Serpent {
        public static final String OID = "1.3.6.1.4.1.11591.13.2.24";

        public Serpent192_CFB() {
            super("CFB", 6);
        }
    }

    public static class Serpent192_OFB
    extends Serpent {
        public static final String OID = "1.3.6.1.4.1.11591.13.2.23";

        public Serpent192_OFB() {
            super("OFB", 6);
        }
    }

    public static class Serpent192_CBC
    extends Serpent {
        public static final String OID = "1.3.6.1.4.1.11591.13.2.22";

        public Serpent192_CBC() {
            super("CBC", 6);
        }
    }

    public static class Serpent192_ECB
    extends Serpent {
        public static final String OID = "1.3.6.1.4.1.11591.13.2.21";

        public Serpent192_ECB() {
            super("ECB", 6);
        }
    }

    public static class Serpent128_CFB
    extends Serpent {
        public static final String OID = "1.3.6.1.4.1.11591.13.2.4";

        public Serpent128_CFB() {
            super("CFB", 4);
        }
    }

    public static class Serpent128_OFB
    extends Serpent {
        public static final String OID = "1.3.6.1.4.1.11591.13.2.3";

        public Serpent128_OFB() {
            super("OFB", 4);
        }
    }

    public static class Serpent128_CBC
    extends Serpent {
        public static final String OID = "1.3.6.1.4.1.11591.13.2.2";

        public Serpent128_CBC() {
            super("CBC", 4);
        }
    }

    public static class Serpent128_ECB
    extends Serpent {
        public static final String OID = "1.3.6.1.4.1.11591.13.2.1";

        public Serpent128_ECB() {
            super("ECB", 4);
        }
    }
}

