/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.serpent;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.serpent.SerpentKey;
import de.flexiprovider.core.serpent.SerpentKeyGenParameterSpec;

public class SerpentKeyGenerator
extends SecretKeyGenerator {
    private int keySize;
    private SecureRandom random;
    private boolean initialized;

    public void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        SerpentKeyGenParameterSpec serpentParams;
        if (params == null) {
            serpentParams = new SerpentKeyGenParameterSpec();
        } else if (params instanceof SerpentKeyGenParameterSpec) {
            serpentParams = (SerpentKeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = serpentParams.getKeySize() >> 3;
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void init(int keySize, SecureRandom random) {
        SerpentKeyGenParameterSpec params = new SerpentKeyGenParameterSpec(keySize);
        try {
            this.init(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public void init(SecureRandom random) {
        SerpentKeyGenParameterSpec defaultParams = new SerpentKeyGenParameterSpec();
        try {
            this.init(defaultParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public SecretKey generateKey() {
        if (!this.initialized) {
            this.init(Registry.getSecureRandom());
        }
        byte[] keyBytes = new byte[this.keySize];
        this.random.nextBytes(keyBytes);
        return new SerpentKey(keyBytes);
    }
}

