/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.shacal;

import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.util.BigEndianConversions;
import de.flexiprovider.core.shacal.ShacalKey;

public class Shacal
extends BlockCipher {
    private static final int k1 = 1518500249;
    private static final int k2 = 1859775393;
    private static final int k3 = -1894007588;
    private static final int k4 = -899497514;
    private static final int BLOCK_SIZE = 20;
    private int[] w = new int[80];

    public String getName() {
        return "SHACAL";
    }

    protected int getCipherBlockSize() {
        return 20;
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof ShacalKey) && !(key instanceof SecretKeySpec)) {
            throw new InvalidKeyException("not a Shacal Key");
        }
        int keyLen = key.getEncoded().length;
        if (keyLen != 16 && keyLen != 24 && keyLen != 32 && keyLen != 40 && keyLen != 48 && keyLen != 64) {
            throw new InvalidKeyException("invalid key size");
        }
        return keyLen << 3;
    }

    private void keySchedule(byte[] key) {
        int i;
        byte[] buffer = new byte[64];
        int n = key.length << 3;
        if (n == 128 || n == 192 || n == 256 || n == 320 || n == 384 || n == 448) {
            i = 0;
            while (i < n >> 3) {
                buffer[i] = key[i];
                ++i;
            }
            int i2 = n >> 3;
            while (i2 < 64) {
                buffer[i2] = 0;
                ++i2;
            }
        } else if (n == 512) {
            System.arraycopy(key, 0, buffer, 0, key.length);
        }
        this.w[0] = (buffer[0] & 0xFF) << 24 | (buffer[1] & 0xFF) << 16 | (buffer[2] & 0xFF) << 8 | buffer[3] & 0xFF;
        this.w[1] = (buffer[4] & 0xFF) << 24 | (buffer[5] & 0xFF) << 16 | (buffer[6] & 0xFF) << 8 | buffer[7] & 0xFF;
        this.w[2] = (buffer[8] & 0xFF) << 24 | (buffer[9] & 0xFF) << 16 | (buffer[10] & 0xFF) << 8 | buffer[11] & 0xFF;
        this.w[3] = (buffer[12] & 0xFF) << 24 | (buffer[13] & 0xFF) << 16 | (buffer[14] & 0xFF) << 8 | buffer[15] & 0xFF;
        this.w[4] = (buffer[16] & 0xFF) << 24 | (buffer[17] & 0xFF) << 16 | (buffer[18] & 0xFF) << 8 | buffer[19] & 0xFF;
        this.w[5] = (buffer[20] & 0xFF) << 24 | (buffer[21] & 0xFF) << 16 | (buffer[22] & 0xFF) << 8 | buffer[23] & 0xFF;
        this.w[6] = (buffer[24] & 0xFF) << 24 | (buffer[25] & 0xFF) << 16 | (buffer[26] & 0xFF) << 8 | buffer[27] & 0xFF;
        this.w[7] = (buffer[28] & 0xFF) << 24 | (buffer[29] & 0xFF) << 16 | (buffer[30] & 0xFF) << 8 | buffer[31] & 0xFF;
        this.w[8] = (buffer[32] & 0xFF) << 24 | (buffer[33] & 0xFF) << 16 | (buffer[34] & 0xFF) << 8 | buffer[35] & 0xFF;
        this.w[9] = (buffer[36] & 0xFF) << 24 | (buffer[37] & 0xFF) << 16 | (buffer[38] & 0xFF) << 8 | buffer[39] & 0xFF;
        this.w[10] = (buffer[40] & 0xFF) << 24 | (buffer[41] & 0xFF) << 16 | (buffer[42] & 0xFF) << 8 | buffer[43] & 0xFF;
        this.w[11] = (buffer[44] & 0xFF) << 24 | (buffer[45] & 0xFF) << 16 | (buffer[46] & 0xFF) << 8 | buffer[47] & 0xFF;
        this.w[12] = (buffer[48] & 0xFF) << 24 | (buffer[49] & 0xFF) << 16 | (buffer[50] & 0xFF) << 8 | buffer[51] & 0xFF;
        this.w[13] = (buffer[52] & 0xFF) << 24 | (buffer[53] & 0xFF) << 16 | (buffer[54] & 0xFF) << 8 | buffer[55] & 0xFF;
        this.w[14] = (buffer[56] & 0xFF) << 24 | (buffer[57] & 0xFF) << 16 | (buffer[58] & 0xFF) << 8 | buffer[59] & 0xFF;
        this.w[15] = (buffer[60] & 0xFF) << 24 | (buffer[61] & 0xFF) << 16 | (buffer[62] & 0xFF) << 8 | buffer[63] & 0xFF;
        i = 16;
        while (i < 80) {
            int register = this.w[i - 3] ^ this.w[i - 8] ^ this.w[i - 14] ^ this.w[i - 16];
            this.w[i] = register << 1 | register >>> 31;
            ++i;
        }
    }

    protected void initCipherEncrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (!(key instanceof ShacalKey) && !(key instanceof SecretKeySpec)) {
            throw new InvalidKeyException("not a Shacal Key");
        }
        this.keySchedule(key.getEncoded());
    }

    protected void initCipherDecrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        this.initCipherEncrypt(key, params);
    }

    protected void singleBlockDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        int[] inputInt = new int[5];
        int i = 0;
        while (i < 5) {
            inputInt[i] = BigEndianConversions.OS2IP(input, 4 * i + inOff);
            ++i;
        }
        int a = inputInt[0];
        int b = inputInt[1];
        int c = inputInt[2];
        int d = inputInt[3];
        int e = inputInt[4];
        c = c >>> 30 | c << 2;
        a -= -899497514 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[79];
        d = d >>> 30 | d << 2;
        b -= -899497514 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[78];
        e = e >>> 30 | e << 2;
        c -= -899497514 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[77];
        a = a >>> 30 | a << 2;
        d -= -899497514 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[76];
        b = b >>> 30 | b << 2;
        e -= -899497514 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[75];
        c = c >>> 30 | c << 2;
        a -= -899497514 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[74];
        d = d >>> 30 | d << 2;
        b -= -899497514 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[73];
        e = e >>> 30 | e << 2;
        c -= -899497514 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[72];
        a = a >>> 30 | a << 2;
        d -= -899497514 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[71];
        b = b >>> 30 | b << 2;
        e -= -899497514 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[70];
        c = c >>> 30 | c << 2;
        a -= -899497514 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[69];
        d = d >>> 30 | d << 2;
        b -= -899497514 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[68];
        e = e >>> 30 | e << 2;
        c -= -899497514 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[67];
        a = a >>> 30 | a << 2;
        d -= -899497514 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[66];
        b = b >>> 30 | b << 2;
        e -= -899497514 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[65];
        c = c >>> 30 | c << 2;
        a -= -899497514 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[64];
        d = d >>> 30 | d << 2;
        b -= -899497514 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[63];
        e = e >>> 30 | e << 2;
        c -= -899497514 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[62];
        a = a >>> 30 | a << 2;
        d -= -899497514 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[61];
        b = b >>> 30 | b << 2;
        e -= -899497514 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[60];
        c = c >>> 30 | c << 2;
        a -= -1894007588 + (b << 5 | b >>> 27) + (c & d | c & e | d & e) + this.w[59];
        d = d >>> 30 | d << 2;
        b -= -1894007588 + (c << 5 | c >>> 27) + (d & e | d & a | e & a) + this.w[58];
        e = e >>> 30 | e << 2;
        c -= -1894007588 + (d << 5 | d >>> 27) + (e & a | e & b | a & b) + this.w[57];
        a = a >>> 30 | a << 2;
        d -= -1894007588 + (e << 5 | e >>> 27) + (a & b | a & c | b & c) + this.w[56];
        b = b >>> 30 | b << 2;
        e -= -1894007588 + (a << 5 | a >>> 27) + (b & c | b & d | c & d) + this.w[55];
        c = c >>> 30 | c << 2;
        a -= -1894007588 + (b << 5 | b >>> 27) + (c & d | c & e | d & e) + this.w[54];
        d = d >>> 30 | d << 2;
        b -= -1894007588 + (c << 5 | c >>> 27) + (d & e | d & a | e & a) + this.w[53];
        e = e >>> 30 | e << 2;
        c -= -1894007588 + (d << 5 | d >>> 27) + (e & a | e & b | a & b) + this.w[52];
        a = a >>> 30 | a << 2;
        d -= -1894007588 + (e << 5 | e >>> 27) + (a & b | a & c | b & c) + this.w[51];
        b = b >>> 30 | b << 2;
        e -= -1894007588 + (a << 5 | a >>> 27) + (b & c | b & d | c & d) + this.w[50];
        c = c >>> 30 | c << 2;
        a -= -1894007588 + (b << 5 | b >>> 27) + (c & d | c & e | d & e) + this.w[49];
        d = d >>> 30 | d << 2;
        b -= -1894007588 + (c << 5 | c >>> 27) + (d & e | d & a | e & a) + this.w[48];
        e = e >>> 30 | e << 2;
        c -= -1894007588 + (d << 5 | d >>> 27) + (e & a | e & b | a & b) + this.w[47];
        a = a >>> 30 | a << 2;
        d -= -1894007588 + (e << 5 | e >>> 27) + (a & b | a & c | b & c) + this.w[46];
        b = b >>> 30 | b << 2;
        e -= -1894007588 + (a << 5 | a >>> 27) + (b & c | b & d | c & d) + this.w[45];
        c = c >>> 30 | c << 2;
        a -= -1894007588 + (b << 5 | b >>> 27) + (c & d | c & e | d & e) + this.w[44];
        d = d >>> 30 | d << 2;
        b -= -1894007588 + (c << 5 | c >>> 27) + (d & e | d & a | e & a) + this.w[43];
        e = e >>> 30 | e << 2;
        c -= -1894007588 + (d << 5 | d >>> 27) + (e & a | e & b | a & b) + this.w[42];
        a = a >>> 30 | a << 2;
        d -= -1894007588 + (e << 5 | e >>> 27) + (a & b | a & c | b & c) + this.w[41];
        b = b >>> 30 | b << 2;
        e -= -1894007588 + (a << 5 | a >>> 27) + (b & c | b & d | c & d) + this.w[40];
        c = c >>> 30 | c << 2;
        a -= 1859775393 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[39];
        d = d >>> 30 | d << 2;
        b -= 1859775393 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[38];
        e = e >>> 30 | e << 2;
        c -= 1859775393 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[37];
        a = a >>> 30 | a << 2;
        d -= 1859775393 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[36];
        b = b >>> 30 | b << 2;
        e -= 1859775393 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[35];
        c = c >>> 30 | c << 2;
        a -= 1859775393 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[34];
        d = d >>> 30 | d << 2;
        b -= 1859775393 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[33];
        e = e >>> 30 | e << 2;
        c -= 1859775393 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[32];
        a = a >>> 30 | a << 2;
        d -= 1859775393 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[31];
        b = b >>> 30 | b << 2;
        e -= 1859775393 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[30];
        c = c >>> 30 | c << 2;
        a -= 1859775393 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[29];
        d = d >>> 30 | d << 2;
        b -= 1859775393 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[28];
        e = e >>> 30 | e << 2;
        c -= 1859775393 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[27];
        a = a >>> 30 | a << 2;
        d -= 1859775393 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[26];
        b = b >>> 30 | b << 2;
        e -= 1859775393 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[25];
        c = c >>> 30 | c << 2;
        a -= 1859775393 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[24];
        d = d >>> 30 | d << 2;
        b -= 1859775393 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[23];
        e = e >>> 30 | e << 2;
        c -= 1859775393 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[22];
        a = a >>> 30 | a << 2;
        d -= 1859775393 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[21];
        b = b >>> 30 | b << 2;
        e -= 1859775393 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[20];
        c = c >>> 30 | c << 2;
        a -= 1518500249 + (b << 5 | b >>> 27) + (c & d | ~c & e) + this.w[19];
        d = d >>> 30 | d << 2;
        b -= 1518500249 + (c << 5 | c >>> 27) + (d & e | ~d & a) + this.w[18];
        e = e >>> 30 | e << 2;
        c -= 1518500249 + (d << 5 | d >>> 27) + (e & a | ~e & b) + this.w[17];
        a = a >>> 30 | a << 2;
        d -= 1518500249 + (e << 5 | e >>> 27) + (a & b | ~a & c) + this.w[16];
        b = b >>> 30 | b << 2;
        e -= 1518500249 + (a << 5 | a >>> 27) + (b & c | ~b & d) + this.w[15];
        c = c >>> 30 | c << 2;
        a -= 1518500249 + (b << 5 | b >>> 27) + (c & d | ~c & e) + this.w[14];
        d = d >>> 30 | d << 2;
        b -= 1518500249 + (c << 5 | c >>> 27) + (d & e | ~d & a) + this.w[13];
        e = e >>> 30 | e << 2;
        c -= 1518500249 + (d << 5 | d >>> 27) + (e & a | ~e & b) + this.w[12];
        a = a >>> 30 | a << 2;
        d -= 1518500249 + (e << 5 | e >>> 27) + (a & b | ~a & c) + this.w[11];
        b = b >>> 30 | b << 2;
        e -= 1518500249 + (a << 5 | a >>> 27) + (b & c | ~b & d) + this.w[10];
        c = c >>> 30 | c << 2;
        a -= 1518500249 + (b << 5 | b >>> 27) + (c & d | ~c & e) + this.w[9];
        d = d >>> 30 | d << 2;
        b -= 1518500249 + (c << 5 | c >>> 27) + (d & e | ~d & a) + this.w[8];
        e = e >>> 30 | e << 2;
        c -= 1518500249 + (d << 5 | d >>> 27) + (e & a | ~e & b) + this.w[7];
        a = a >>> 30 | a << 2;
        d -= 1518500249 + (e << 5 | e >>> 27) + (a & b | ~a & c) + this.w[6];
        b = b >>> 30 | b << 2;
        e -= 1518500249 + (a << 5 | a >>> 27) + (b & c | ~b & d) + this.w[5];
        c = c >>> 30 | c << 2;
        a -= 1518500249 + (b << 5 | b >>> 27) + (c & d | ~c & e) + this.w[4];
        d = d >>> 30 | d << 2;
        b -= 1518500249 + (c << 5 | c >>> 27) + (d & e | ~d & a) + this.w[3];
        e = e >>> 30 | e << 2;
        c -= 1518500249 + (d << 5 | d >>> 27) + (e & a | ~e & b) + this.w[2];
        a = a >>> 30 | a << 2;
        d -= 1518500249 + (e << 5 | e >>> 27) + (a & b | ~a & c) + this.w[1];
        b = b >>> 30 | b << 2;
        inputInt[0] = a;
        inputInt[1] = b;
        inputInt[2] = c;
        inputInt[3] = d;
        inputInt[4] = e -= 1518500249 + (a << 5 | a >>> 27) + (b & c | ~b & d) + this.w[0];
        int i2 = 0;
        while (i2 < 5) {
            BigEndianConversions.I2OSP(inputInt[i2], output, 4 * i2 + outOff);
            ++i2;
        }
    }

    protected void singleBlockEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
        int[] inputInt = new int[5];
        int i = 0;
        while (i < 5) {
            inputInt[i] = BigEndianConversions.OS2IP(input, 4 * i + inOff);
            ++i;
        }
        int a = inputInt[0];
        int b = inputInt[1];
        int c = inputInt[2];
        int d = inputInt[3];
        int e = inputInt[4];
        e += 1518500249 + (a << 5 | a >>> 27) + (b & c | ~b & d) + this.w[0];
        b = b << 30 | b >>> 2;
        d += 1518500249 + (e << 5 | e >>> 27) + (a & b | ~a & c) + this.w[1];
        a = a << 30 | a >>> 2;
        c += 1518500249 + (d << 5 | d >>> 27) + (e & a | ~e & b) + this.w[2];
        e = e << 30 | e >>> 2;
        b += 1518500249 + (c << 5 | c >>> 27) + (d & e | ~d & a) + this.w[3];
        d = d << 30 | d >>> 2;
        a += 1518500249 + (b << 5 | b >>> 27) + (c & d | ~c & e) + this.w[4];
        c = c << 30 | c >>> 2;
        e += 1518500249 + (a << 5 | a >>> 27) + (b & c | ~b & d) + this.w[5];
        b = b << 30 | b >>> 2;
        d += 1518500249 + (e << 5 | e >>> 27) + (a & b | ~a & c) + this.w[6];
        a = a << 30 | a >>> 2;
        c += 1518500249 + (d << 5 | d >>> 27) + (e & a | ~e & b) + this.w[7];
        e = e << 30 | e >>> 2;
        b += 1518500249 + (c << 5 | c >>> 27) + (d & e | ~d & a) + this.w[8];
        d = d << 30 | d >>> 2;
        a += 1518500249 + (b << 5 | b >>> 27) + (c & d | ~c & e) + this.w[9];
        c = c << 30 | c >>> 2;
        e += 1518500249 + (a << 5 | a >>> 27) + (b & c | ~b & d) + this.w[10];
        b = b << 30 | b >>> 2;
        d += 1518500249 + (e << 5 | e >>> 27) + (a & b | ~a & c) + this.w[11];
        a = a << 30 | a >>> 2;
        c += 1518500249 + (d << 5 | d >>> 27) + (e & a | ~e & b) + this.w[12];
        e = e << 30 | e >>> 2;
        b += 1518500249 + (c << 5 | c >>> 27) + (d & e | ~d & a) + this.w[13];
        d = d << 30 | d >>> 2;
        a += 1518500249 + (b << 5 | b >>> 27) + (c & d | ~c & e) + this.w[14];
        c = c << 30 | c >>> 2;
        e += 1518500249 + (a << 5 | a >>> 27) + (b & c | ~b & d) + this.w[15];
        b = b << 30 | b >>> 2;
        d += 1518500249 + (e << 5 | e >>> 27) + (a & b | ~a & c) + this.w[16];
        a = a << 30 | a >>> 2;
        c += 1518500249 + (d << 5 | d >>> 27) + (e & a | ~e & b) + this.w[17];
        e = e << 30 | e >>> 2;
        b += 1518500249 + (c << 5 | c >>> 27) + (d & e | ~d & a) + this.w[18];
        d = d << 30 | d >>> 2;
        a += 1518500249 + (b << 5 | b >>> 27) + (c & d | ~c & e) + this.w[19];
        c = c << 30 | c >>> 2;
        e += 1859775393 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[20];
        b = b << 30 | b >>> 2;
        d += 1859775393 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[21];
        a = a << 30 | a >>> 2;
        c += 1859775393 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[22];
        e = e << 30 | e >>> 2;
        b += 1859775393 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[23];
        d = d << 30 | d >>> 2;
        a += 1859775393 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[24];
        c = c << 30 | c >>> 2;
        e += 1859775393 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[25];
        b = b << 30 | b >>> 2;
        d += 1859775393 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[26];
        a = a << 30 | a >>> 2;
        c += 1859775393 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[27];
        e = e << 30 | e >>> 2;
        b += 1859775393 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[28];
        d = d << 30 | d >>> 2;
        a += 1859775393 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[29];
        c = c << 30 | c >>> 2;
        e += 1859775393 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[30];
        b = b << 30 | b >>> 2;
        d += 1859775393 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[31];
        a = a << 30 | a >>> 2;
        c += 1859775393 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[32];
        e = e << 30 | e >>> 2;
        b += 1859775393 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[33];
        d = d << 30 | d >>> 2;
        a += 1859775393 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[34];
        c = c << 30 | c >>> 2;
        e += 1859775393 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[35];
        b = b << 30 | b >>> 2;
        d += 1859775393 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[36];
        a = a << 30 | a >>> 2;
        c += 1859775393 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[37];
        e = e << 30 | e >>> 2;
        b += 1859775393 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[38];
        d = d << 30 | d >>> 2;
        a += 1859775393 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[39];
        c = c << 30 | c >>> 2;
        e += -1894007588 + (a << 5 | a >>> 27) + (b & c | b & d | c & d) + this.w[40];
        b = b << 30 | b >>> 2;
        d += -1894007588 + (e << 5 | e >>> 27) + (a & b | a & c | b & c) + this.w[41];
        a = a << 30 | a >>> 2;
        c += -1894007588 + (d << 5 | d >>> 27) + (e & a | e & b | a & b) + this.w[42];
        e = e << 30 | e >>> 2;
        b += -1894007588 + (c << 5 | c >>> 27) + (d & e | d & a | e & a) + this.w[43];
        d = d << 30 | d >>> 2;
        a += -1894007588 + (b << 5 | b >>> 27) + (c & d | c & e | d & e) + this.w[44];
        c = c << 30 | c >>> 2;
        e += -1894007588 + (a << 5 | a >>> 27) + (b & c | b & d | c & d) + this.w[45];
        b = b << 30 | b >>> 2;
        d += -1894007588 + (e << 5 | e >>> 27) + (a & b | a & c | b & c) + this.w[46];
        a = a << 30 | a >>> 2;
        c += -1894007588 + (d << 5 | d >>> 27) + (e & a | e & b | a & b) + this.w[47];
        e = e << 30 | e >>> 2;
        b += -1894007588 + (c << 5 | c >>> 27) + (d & e | d & a | e & a) + this.w[48];
        d = d << 30 | d >>> 2;
        a += -1894007588 + (b << 5 | b >>> 27) + (c & d | c & e | d & e) + this.w[49];
        c = c << 30 | c >>> 2;
        e += -1894007588 + (a << 5 | a >>> 27) + (b & c | b & d | c & d) + this.w[50];
        b = b << 30 | b >>> 2;
        d += -1894007588 + (e << 5 | e >>> 27) + (a & b | a & c | b & c) + this.w[51];
        a = a << 30 | a >>> 2;
        c += -1894007588 + (d << 5 | d >>> 27) + (e & a | e & b | a & b) + this.w[52];
        e = e << 30 | e >>> 2;
        b += -1894007588 + (c << 5 | c >>> 27) + (d & e | d & a | e & a) + this.w[53];
        d = d << 30 | d >>> 2;
        a += -1894007588 + (b << 5 | b >>> 27) + (c & d | c & e | d & e) + this.w[54];
        c = c << 30 | c >>> 2;
        e += -1894007588 + (a << 5 | a >>> 27) + (b & c | b & d | c & d) + this.w[55];
        b = b << 30 | b >>> 2;
        d += -1894007588 + (e << 5 | e >>> 27) + (a & b | a & c | b & c) + this.w[56];
        a = a << 30 | a >>> 2;
        c += -1894007588 + (d << 5 | d >>> 27) + (e & a | e & b | a & b) + this.w[57];
        e = e << 30 | e >>> 2;
        b += -1894007588 + (c << 5 | c >>> 27) + (d & e | d & a | e & a) + this.w[58];
        d = d << 30 | d >>> 2;
        a += -1894007588 + (b << 5 | b >>> 27) + (c & d | c & e | d & e) + this.w[59];
        c = c << 30 | c >>> 2;
        e += -899497514 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[60];
        b = b << 30 | b >>> 2;
        d += -899497514 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[61];
        a = a << 30 | a >>> 2;
        c += -899497514 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[62];
        e = e << 30 | e >>> 2;
        b += -899497514 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[63];
        d = d << 30 | d >>> 2;
        a += -899497514 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[64];
        c = c << 30 | c >>> 2;
        e += -899497514 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[65];
        b = b << 30 | b >>> 2;
        d += -899497514 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[66];
        a = a << 30 | a >>> 2;
        c += -899497514 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[67];
        e = e << 30 | e >>> 2;
        b += -899497514 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[68];
        d = d << 30 | d >>> 2;
        a += -899497514 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[69];
        c = c << 30 | c >>> 2;
        e += -899497514 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[70];
        b = b << 30 | b >>> 2;
        d += -899497514 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[71];
        a = a << 30 | a >>> 2;
        c += -899497514 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[72];
        e = e << 30 | e >>> 2;
        b += -899497514 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[73];
        d = d << 30 | d >>> 2;
        a += -899497514 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[74];
        c = c << 30 | c >>> 2;
        e += -899497514 + (a << 5 | a >>> 27) + (b ^ c ^ d) + this.w[75];
        b = b << 30 | b >>> 2;
        d += -899497514 + (e << 5 | e >>> 27) + (a ^ b ^ c) + this.w[76];
        a = a << 30 | a >>> 2;
        c += -899497514 + (d << 5 | d >>> 27) + (e ^ a ^ b) + this.w[77];
        e = e << 30 | e >>> 2;
        b += -899497514 + (c << 5 | c >>> 27) + (d ^ e ^ a) + this.w[78];
        d = d << 30 | d >>> 2;
        a += -899497514 + (b << 5 | b >>> 27) + (c ^ d ^ e) + this.w[79];
        c = c << 30 | c >>> 2;
        inputInt[0] = a;
        inputInt[1] = b;
        inputInt[2] = c;
        inputInt[3] = d;
        inputInt[4] = e;
        int i2 = 0;
        while (i2 < 5) {
            BigEndianConversions.I2OSP(inputInt[i2], output, 4 * i2 + outOff);
            ++i2;
        }
    }
}

