/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.shacal;

import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.common.util.ByteUtils;

public class ShacalKey
implements SecretKey {
    private byte[] keyBytes;

    protected ShacalKey(byte[] keyBytes) {
        this.keyBytes = ByteUtils.clone(keyBytes);
    }

    public String getAlgorithm() {
        return "Shacal";
    }

    public byte[] getEncoded() {
        return ByteUtils.clone(this.keyBytes);
    }

    public String getFormat() {
        return "RAW";
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ShacalKey)) {
            return false;
        }
        return ByteUtils.equals(this.keyBytes, ((ShacalKey)other).keyBytes);
    }

    public int hashCode() {
        int result = 1;
        int i = 0;
        while (i < this.keyBytes.length) {
            result = 31 * result + this.keyBytes[i];
            ++i;
        }
        return result;
    }
}

