/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.shacal;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.shacal.ShacalKey;
import de.flexiprovider.core.shacal.ShacalKeyGenParameterSpec;

public class ShacalKeyGenerator
extends SecretKeyGenerator {
    private int keySize;
    private SecureRandom random;
    private boolean initialized;

    public void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        ShacalKeyGenParameterSpec shacalParams;
        if (params == null) {
            shacalParams = new ShacalKeyGenParameterSpec();
        } else if (params instanceof ShacalKeyGenParameterSpec) {
            shacalParams = (ShacalKeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = shacalParams.getKeySize();
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void init(int keySize, SecureRandom random) {
        ShacalKeyGenParameterSpec params = new ShacalKeyGenParameterSpec(keySize);
        try {
            this.init(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public void init(SecureRandom random) {
        ShacalKeyGenParameterSpec defaultParams = new ShacalKeyGenParameterSpec();
        try {
            this.init(defaultParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public SecretKey generateKey() {
        if (!this.initialized) {
            this.init(Registry.getSecureRandom());
        }
        byte[] keyBytes = new byte[this.keySize >> 3];
        this.random.nextBytes(keyBytes);
        return new ShacalKey(keyBytes);
    }
}

