/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.twofish;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.twofish.TwofishKey;
import de.flexiprovider.core.twofish.TwofishKeyGenParameterSpec;

public class TwofishKeyGenerator
extends SecretKeyGenerator {
    private int keySize;
    private SecureRandom random;
    private boolean initialized;

    public void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        TwofishKeyGenParameterSpec twofishParams;
        if (params == null) {
            twofishParams = new TwofishKeyGenParameterSpec();
        } else if (params instanceof TwofishKeyGenParameterSpec) {
            twofishParams = (TwofishKeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = twofishParams.getKeySize() >> 3;
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void init(int keySize, SecureRandom random) {
        TwofishKeyGenParameterSpec params = new TwofishKeyGenParameterSpec(keySize);
        try {
            this.init(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public void init(SecureRandom random) {
        TwofishKeyGenParameterSpec defaultParams = new TwofishKeyGenParameterSpec();
        try {
            this.init(defaultParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public SecretKey generateKey() {
        if (!this.initialized) {
            this.init(Registry.getSecureRandom());
        }
        byte[] keyBytes = new byte[this.keySize];
        this.random.nextBytes(keyBytes);
        return new TwofishKey(keyBytes);
    }
}

