/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.commonapi.testing;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.Node;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.SphereNetwork;
import rice.pastry.dist.DistPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;

public abstract class CommonAPITest {
    protected Node[] nodes;
    protected PastryNodeFactory factory;
    protected NodeIdFactory idFactory = new RandomNodeIdFactory();
    protected NetworkSimulator simulator = SIMULATOR == -1 ? new SphereNetwork() : new EuclideanNetwork();
    public static int NUM_NODES = 10;
    public static IdFactory FACTORY = new PastryIdFactory();
    public static final String SUCCESS = "SUCCESS";
    public static final String FAILURE = "FAILURE";
    protected static final int PAD_SIZE = 60;
    public static final int PROTOCOL_DIRECT = -138;
    public static final int SIMULATOR_SPHERE = -1;
    public static final int SIMULATOR_EUCLIDEAN = -2;
    public static int PORT = 5009;
    public static String BOOTSTRAP_HOST = "localhost";
    public static int BOOTSTRAP_PORT = 5009;
    public static int PROTOCOL = DistPastryNodeFactory.PROTOCOL_RMI;
    public static int SIMULATOR = -1;
    public static String INSTANCE_NAME = "DistCommonAPITest";

    public CommonAPITest() {
        this.factory = PROTOCOL == -138 ? new DirectPastryNodeFactory(this.idFactory, this.simulator) : DistPastryNodeFactory.getFactory(this.idFactory, PROTOCOL, PORT);
        this.nodes = new Node[NUM_NODES];
    }

    public void start() {
        for (int i = 0; i < NUM_NODES; ++i) {
            this.nodes[i] = this.createNode(i);
            this.simulate();
            this.processNode(i, this.nodes[i]);
            this.simulate();
            System.out.println("Created node " + i + " with id " + ((PastryNode)this.nodes[i]).getNodeId());
        }
        System.out.println("\nTest Beginning\n");
        this.runTest();
    }

    protected void simulate() {
        if (PROTOCOL == -138) {
            while (this.simulator.simulate()) {
            }
        } else {
            this.pause(500);
        }
    }

    protected Node createNode(int n) {
        if (n == 0) {
            return this.factory.newNode(null);
        }
        return this.factory.newNode(this.getBootstrap());
    }

    protected NodeHandle getBootstrap() {
        if (PROTOCOL == -138) {
            return ((DirectPastryNode)this.nodes[0]).getLocalHandle();
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(BOOTSTRAP_HOST, BOOTSTRAP_PORT);
        return ((DistPastryNodeFactory)this.factory).getNodeHandle(inetSocketAddress);
    }

    protected synchronized void pause(int n) {
        if (PROTOCOL != -138) {
            try {
                this.wait(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void kill(int n) {
        if (PROTOCOL == -138) {
            this.simulator.setAlive((NodeId)this.nodes[n].getId(), false);
        }
    }

    protected abstract void processNode(int var1, Node var2);

    protected abstract void runTest();

    protected final void sectionStart(String string) {
        System.out.println(string);
    }

    protected final void sectionDone() {
        System.out.println();
    }

    protected final void stepStart(String string) {
        System.out.print(this.pad("  " + string));
    }

    protected final void stepDone() {
        this.stepDone(SUCCESS);
    }

    protected final void stepDone(String string) {
        this.stepDone(string, "");
    }

    protected final void stepDone(String string, String string2) {
        System.out.println("[" + string + "]");
        if (string2 != null && !string2.equals("")) {
            System.out.println("     " + string2);
        }
        if (string.equals(FAILURE)) {
            System.exit(0);
        }
    }

    protected final void stepException(Exception exception) {
        System.out.println("\nException " + exception + " occurred during testing.");
        exception.printStackTrace();
        System.exit(0);
    }

    private final String pad(String string) {
        if (string.length() >= 60) {
            return string.substring(0, 60);
        }
        int n = 60 - string.length();
        char[] cArray = new char[n];
        Arrays.fill(cArray, '.');
        return string.concat(new String(cArray));
    }

    protected final void assertTrue(String string, boolean bl) {
        if (!bl) {
            this.stepDone(FAILURE, "Assertion '" + string + "' failed.");
        }
    }

    protected final void assertEquals(String string, Object object, Object object2) {
        if (!object.equals(object2)) {
            this.stepDone(FAILURE, "Assertion '" + string + "' failed, expected: '" + object + "' got: " + object2 + "'");
        }
    }

    protected static void parseArgs(String[] stringArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-help")) continue;
            System.out.println("Usage: DistCommonAPITest [-port p] [-protocol (rmi|wire)] [-bootstrap host[:port]] [-help]");
            System.exit(1);
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-nodes") || n2 + 1 >= stringArray.length) continue;
            n = Integer.parseInt(stringArray[n2 + 1]);
            if (n <= 0) break;
            NUM_NODES = n;
            break;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-port") || n2 + 1 >= stringArray.length) continue;
            n = Integer.parseInt(stringArray[n2 + 1]);
            if (n <= 0) break;
            PORT = n;
            break;
        }
        BOOTSTRAP_PORT = PORT;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-bootstrap") || n2 + 1 >= stringArray.length) continue;
            String string = stringArray[n2 + 1];
            int n3 = string.indexOf(58);
            if (n3 == -1) {
                BOOTSTRAP_HOST = string;
                BOOTSTRAP_PORT = PORT;
                break;
            }
            BOOTSTRAP_HOST = string.substring(0, n3);
            BOOTSTRAP_PORT = Integer.parseInt(string.substring(n3 + 1));
            if (BOOTSTRAP_PORT > 0) break;
            BOOTSTRAP_PORT = PORT;
            break;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-protocol") || n2 + 1 >= stringArray.length) continue;
            String string = stringArray[n2 + 1];
            if (string.equalsIgnoreCase("wire")) {
                PROTOCOL = DistPastryNodeFactory.PROTOCOL_WIRE;
                break;
            }
            if (string.equalsIgnoreCase("rmi")) {
                PROTOCOL = DistPastryNodeFactory.PROTOCOL_RMI;
                break;
            }
            if (string.equalsIgnoreCase("socket")) {
                PROTOCOL = DistPastryNodeFactory.PROTOCOL_SOCKET;
                break;
            }
            if (string.equalsIgnoreCase("direct")) {
                PROTOCOL = -138;
                break;
            }
            System.out.println("ERROR: Unsupported protocol: " + string);
            break;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-simulator") || n2 + 1 >= stringArray.length) continue;
            String string = stringArray[n2 + 1];
            if (string.equalsIgnoreCase("sphere")) {
                SIMULATOR = -1;
                break;
            }
            if (string.equalsIgnoreCase("euclidean")) {
                PROTOCOL = -2;
                break;
            }
            System.out.println("ERROR: Unsupported simulator: " + string);
            break;
        }
    }

    static {
        try {
            BOOTSTRAP_HOST = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Error determining local host: " + unknownHostException);
        }
    }
}

