/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.AML;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import rice.pastry.AML.AggrFunc;
import rice.pastry.AML.AggrFuncTable;
import rice.pastry.AML.AncestorMIB;
import rice.pastry.AML.AncestorMIBEntry;
import rice.pastry.AML.Attribute;
import rice.pastry.AML.DHTAMLInterface;
import rice.pastry.AML.Database;
import rice.pastry.AML.HashHashTable;
import rice.pastry.AML.LeaserModule;
import rice.pastry.AML.Prefix;
import rice.pastry.AML.ProbeCallBack;
import rice.pastry.AML.ProbeTable;
import rice.pastry.AML.VirtualNodeID;
import rice.pastry.AML.messaging.InstallMessage;
import rice.pastry.AML.messaging.LeaseMessage;
import rice.pastry.AML.messaging.LocalProbeMessage;
import rice.pastry.AML.messaging.ProbeMessage;
import rice.pastry.AML.messaging.UpdateMessage;
import rice.pastry.Assert;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RoutingTable;

public class AML {
    public Hashtable parentMap;
    public HashHashTable invParentMap;
    public HashHashTable childMap;
    public HashHashTable invChildMap;
    PastryNode lNode;
    public NodeHandle lnh;
    public AggrFuncTable aft;
    Hashtable neighs;
    Hashtable redDBs;
    public ProbeTable probeTable;
    Hashtable probeCallBackTable;
    AncestorMIB amib;
    public DHTAMLInterface intf;
    static int idBaseBitLength;
    static int maxDiffDigit;
    public static boolean DYNAMIC_UPDOWN;
    Hashtable lmodMap;

    public void onInstall(InstallMessage installMessage) {
        this.aft.onInstall(installMessage);
    }

    public boolean isSendValueUP(Attribute attribute, Prefix prefix, NodeHandle nodeHandle) {
        Assert.myAssert(nodeHandle != null);
        AggrFunc aggrFunc = this.aft.getAggrFunc(attribute);
        Assert.myAssert(aggrFunc != null);
        if (this.aft.isApplicableToNodeWRTName(attribute, nodeHandle.getNodeName())) {
            int n = this.getMatchingPrefixLength(prefix, attribute);
            if (n >= aggrFunc.getUp()) {
                LeaserModule leaserModule;
                return DYNAMIC_UPDOWN && (leaserModule = this.getLeaserModule(prefix, attribute)) != null && leaserModule.isLeasedToParent();
            }
            return true;
        }
        return false;
    }

    public Vector getValues(Prefix prefix, Attribute attribute) {
        Object object;
        Serializable serializable;
        Object object2;
        Hashtable hashtable = this.childMap.get(prefix);
        Vector<Object> vector = new Vector<Object>();
        if (hashtable != null) {
            object2 = hashtable.keys();
            while (object2.hasMoreElements()) {
                Object object3;
                serializable = (NodeHandle)object2.nextElement();
                object = (Database)this.neighs.get(serializable);
                if (object == null || (object3 = ((Database)object).get(attribute)) == null) continue;
                vector.add(object3);
            }
        }
        if ((object2 = (Database)this.redDBs.get(serializable = Prefix.getPrefixForIdWithLevel(this.lNode.getNodeId(), prefix.getLength() - 2))) != null && (object = ((Database)object2).get(attribute)) != null) {
            vector.add(object);
        }
        return vector;
    }

    public void sendAggregateValueUp(Prefix prefix, Attribute attribute, Object object) {
        NodeHandle nodeHandle = this.getParent(prefix);
        if (nodeHandle == null) {
            return;
        }
        if (nodeHandle.equals(this.lnh)) {
            int n = prefix.getLength();
            if (n >= Prefix.getMaxLength()) {
                if (Log.ifp(5)) {
                    System.out.println("onChildUpdate: max reached");
                }
            } else {
                Prefix prefix2 = Prefix.getPrefixForIdWithLevel(AML.getId(attribute), n);
                this.onChildUpdate(attribute, prefix2, this.lnh);
            }
        } else {
            UpdateMessage updateMessage = new UpdateMessage(this.intf.getAddress(), this.lnh, attribute, object);
            nodeHandle.receiveMessage(updateMessage);
        }
    }

    public void propagateAggregate(Prefix prefix, Attribute attribute, Object object) {
        NodeHandle nodeHandle = this.getParent(prefix);
        if (nodeHandle != null && this.isSendValueUP(attribute, prefix, nodeHandle)) {
            this.sendAggregateValueUp(prefix, attribute, object);
        }
        this.amib.propagateAMIBDown(prefix, attribute, new Vector());
    }

    public void onChildUpdate(Attribute attribute, Prefix prefix, NodeHandle nodeHandle) {
        LeaserModule leaserModule;
        Database database;
        if (Log.ifp(6)) {
            System.out.println(this.lnh + " " + prefix + ": onChildUpdate: " + attribute);
        }
        Vector vector = this.getValues(prefix, attribute);
        if (Log.ifp(6)) {
            System.out.println("vector objs: " + vector);
        }
        AggrFunc aggrFunc = null;
        Object object = null;
        if (vector.size() != 0) {
            aggrFunc = this.aft.getAggrFunc(attribute);
            Assert.myAssert(aggrFunc != null);
            object = aggrFunc.aggregate(vector.toArray());
        }
        if (Log.ifp(6)) {
            System.out.println("Aggregated value: " + object);
        }
        if ((database = (Database)this.redDBs.get(prefix)) == null) {
            database = new Database();
            this.redDBs.put(prefix, database);
        }
        Object object2 = database.get(attribute);
        boolean bl = true;
        if (object2 != null && object != null && object2.equals(object)) {
            bl = false;
        }
        if (object2 == null && object == null) {
            bl = false;
        }
        if (bl) {
            database.applyUpdate(attribute, object);
            if (Log.ifp(6)) {
                System.out.println(this.lnh + ": Applying update to redDB corresponding to prefix " + prefix);
            }
            this.propagateAggregate(prefix, attribute, object);
        }
        this.probeTable.onChildUpdate(prefix, attribute, object, nodeHandle);
        if (DYNAMIC_UPDOWN && (leaserModule = this.getLeaserModule(prefix, attribute)) != null) {
            leaserModule.onUpdateFromChild(leaserModule.getChildVID(nodeHandle));
        }
    }

    public void onUpdate(UpdateMessage updateMessage) {
        if (updateMessage.isFromParent()) {
            this.amib.onParentUpdate(updateMessage);
        } else {
            NodeHandle nodeHandle = updateMessage.getFromNode();
            Attribute attribute = updateMessage.getAttr();
            Database database = (Database)this.neighs.get(nodeHandle);
            if (database == null) {
                if (Log.ifp(7)) {
                    System.out.println(this.lnh + ": Creating a new db for node " + nodeHandle);
                }
                database = new Database();
                this.neighs.put(nodeHandle, database);
            }
            database.applyUpdate(attribute, updateMessage.getValue());
            if (nodeHandle.equals(this.lnh)) {
                Prefix prefix = new Prefix(new NodeId(), 0);
                Object object = updateMessage.getValue();
                this.propagateAggregate(prefix, attribute, object);
            } else {
                Prefix prefix = Prefix.getPrefixForId(AML.getId(attribute), nodeHandle);
                Prefix prefix2 = Prefix.getPrefixForId(AML.getId(attribute), this.lnh);
                Assert.myAssert(prefix2.getLength() >= prefix.getLength(), "onUpdate: tpref is smaller than pref?");
                this.onChildUpdate(attribute, prefix, nodeHandle);
            }
        }
    }

    public void onProbe(ProbeMessage probeMessage) {
        this.probeTable.newProbe(probeMessage);
    }

    public void onProbe(ProbeMessage probeMessage, ProbeCallBack probeCallBack) {
        this.probeCallBackTable.put(probeMessage, probeCallBack);
        this.probeTable.newProbe(probeMessage);
    }

    public int getDownValue(Attribute attribute) {
        AggrFunc aggrFunc = this.aft.getAggrFunc(attribute);
        Assert.myAssert(aggrFunc != null);
        return aggrFunc.getDown();
    }

    public int getUpValue(Attribute attribute) {
        AggrFunc aggrFunc = this.aft.getAggrFunc(attribute);
        Assert.myAssert(aggrFunc != null);
        return aggrFunc.getUp();
    }

    public AncestorMIBEntry getLocalAmibEntry(Prefix prefix, Attribute attribute) {
        NodeHandle nodeHandle = this.getParent(prefix);
        String string = this.lnh.getNodeName().toString();
        int n = this.getMatchingPrefixLength(prefix, attribute);
        AncestorMIBEntry ancestorMIBEntry = null;
        Object object = this.getRedDBValue(prefix, attribute);
        ancestorMIBEntry = nodeHandle != null ? new AncestorMIBEntry(n, string, nodeHandle.getNodeName().toString(), object) : new AncestorMIBEntry(n, string, object);
        return ancestorMIBEntry;
    }

    public Object getRedDBValue(Prefix prefix, Attribute attribute) {
        Database database = (Database)this.redDBs.get(prefix);
        if (database == null) {
            return null;
        }
        return database.get(attribute);
    }

    public int getMatchingPrefixLength(Prefix prefix, Attribute attribute) {
        NodeId nodeId = AML.getId(attribute);
        int n = 159 - this.lnh.getNodeId().indexOfMSDB(nodeId);
        int n2 = 159 - prefix.getId().indexOfMSDB(nodeId);
        if (n2 > prefix.getLength() * idBaseBitLength) {
            n2 = prefix.getLength() * idBaseBitLength;
        }
        int n3 = n2 < n ? n2 : n;
        return n3;
    }

    public LeaserModule getLeaserModule(VirtualNodeID virtualNodeID, Attribute attribute) {
        if (!DYNAMIC_UPDOWN) {
            return null;
        }
        LeaserModule leaserModule = new LeaserModule(virtualNodeID, attribute, this);
        LeaserModule leaserModule2 = (LeaserModule)this.lmodMap.get(leaserModule);
        if (leaserModule2 == null) {
            this.lmodMap.put(leaserModule, leaserModule);
            leaserModule2 = leaserModule;
        }
        return leaserModule2;
    }

    public LeaserModule getLeaserModule(Prefix prefix, String string, String string2) {
        return this.getLeaserModule(new VirtualNodeID(this.lnh, prefix), new Attribute(string, string2));
    }

    public LeaserModule getLeaserModule(Prefix prefix, Attribute attribute) {
        return this.getLeaserModule(new VirtualNodeID(this.lnh, prefix), attribute);
    }

    public void onLeaseMessage(LeaseMessage leaseMessage) {
        if (!DYNAMIC_UPDOWN) {
            return;
        }
        NodeHandle nodeHandle = leaseMessage.getFromNode();
        Assert.myAssert(!nodeHandle.equals(this.lnh));
        Prefix prefix = null;
        prefix = leaseMessage.isFromParent() ? Prefix.getPrefixForId(AML.getId(leaseMessage.getAttr()), this.lnh) : Prefix.getPrefixForId(AML.getId(leaseMessage.getAttr()), nodeHandle);
        LeaserModule leaserModule = this.getLeaserModule(prefix, leaseMessage.getAttr());
        leaserModule.onLeaseMessage(leaseMessage);
    }

    public void receiveMessage(Message message) {
        if (Log.ifp(6)) {
            System.out.println(this.lnh + ": Received msg " + message);
        }
        if (message instanceof InstallMessage) {
            this.onInstall((InstallMessage)message);
        } else if (message instanceof UpdateMessage) {
            this.onUpdate((UpdateMessage)message);
        } else if (message instanceof LocalProbeMessage) {
            this.onProbe((ProbeMessage)message, ((LocalProbeMessage)message).callback);
        } else if (message instanceof ProbeMessage) {
            this.onProbe((ProbeMessage)message);
        } else if (message instanceof LeaseMessage) {
            this.onLeaseMessage((LeaseMessage)message);
        } else {
            Assert.myAssert(false, "Unknown message received " + message);
        }
    }

    public void newParent(Prefix prefix, NodeHandle nodeHandle) {
        Database database;
        NodeHandle nodeHandle2 = this.getParent(prefix);
        Assert.myAssert(!this.lnh.equals(nodeHandle2));
        if (nodeHandle2 != null) {
            if (Log.ifp(8)) {
                System.out.println(this.lnh + ": Deleting " + nodeHandle2 + " as parent for prefix " + prefix);
            }
            if (!this.invParentMap.deleteEntry(nodeHandle2, prefix)) {
                Assert.myAssert(false, this.lnh + ": Could not Delete " + nodeHandle2 + " as parent for prefix " + prefix);
            }
        }
        this.parentMap.remove(prefix);
        if (nodeHandle != null) {
            if (Log.ifp(8)) {
                System.out.println(this.lnh + ": Adding " + nodeHandle + " as parent for prefix " + prefix);
            }
            this.parentMap.put(prefix, nodeHandle);
            this.invParentMap.insertEntry(nodeHandle, prefix);
        }
        this.probeTable.onNewParent(prefix, nodeHandle);
        if (nodeHandle != null && (database = (Database)this.redDBs.get(prefix)) != null) {
            Hashtable hashtable = database.database;
            Iterator iterator = hashtable.keySet().iterator();
            while (iterator.hasNext()) {
                Database.Entry entry = (Database.Entry)iterator.next();
                if (!this.isSendValueUP(entry.attr, prefix, nodeHandle)) continue;
                this.sendAggregateValueUp(prefix, entry.attr, entry.value);
            }
        }
    }

    public void newChild(Prefix prefix, NodeHandle nodeHandle) {
        if (this.childMap.insertEntry(prefix, nodeHandle) && Log.ifp(8)) {
            System.out.println(this.lnh + ": Added " + nodeHandle + " as child for prefix " + prefix);
        }
        this.invChildMap.insertEntry(nodeHandle, prefix);
        Database database = this.amib.getDB(prefix);
        if (database != null) {
            Hashtable hashtable = database.database;
            Iterator iterator = hashtable.keySet().iterator();
            while (iterator.hasNext()) {
                Database.Entry entry = (Database.Entry)iterator.next();
                Vector<AncestorMIBEntry> vector = new Vector<AncestorMIBEntry>((Vector)entry.value);
                AncestorMIBEntry ancestorMIBEntry = this.getLocalAmibEntry(prefix, entry.attr);
                vector.add(0, ancestorMIBEntry);
                this.amib.propagateAMIBDownToChild(prefix, entry.attr, vector, nodeHandle);
            }
        }
    }

    public void failedChild(NodeHandle nodeHandle, Prefix prefix) {
        if (Log.ifp(6)) {
            System.out.println(this.lnh + ": Removed " + nodeHandle + " as child for prefix " + prefix);
        }
        this.childMap.deleteEntry(prefix, nodeHandle);
        this.invChildMap.deleteEntry(nodeHandle, prefix);
        Database database = (Database)this.neighs.get(nodeHandle);
        if (database != null) {
            Hashtable hashtable = database.database;
            Iterator iterator = hashtable.keySet().iterator();
            while (iterator.hasNext()) {
                Database.Entry entry = (Database.Entry)iterator.next();
                Prefix prefix2 = Prefix.getPrefixForId(AML.getId(entry.attr), nodeHandle);
                if (!prefix2.equals(prefix)) continue;
                this.onChildUpdate(entry.attr, prefix2, nodeHandle);
            }
        }
    }

    public NodeHandle getParent(Prefix prefix) {
        return (NodeHandle)this.parentMap.get(prefix);
    }

    public NodeHandle getParent(NodeId nodeId) {
        Prefix prefix = Prefix.getPrefixForId(nodeId, this.lNode);
        return (NodeHandle)this.parentMap.get(prefix);
    }

    public static NodeId getId(Attribute attribute) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("No SHA support!");
        }
        return new NodeId(messageDigest.digest((attribute.name() + attribute.type()).getBytes()));
    }

    public Vector getChildrenAtAllLowerLevels(Prefix prefix) {
        Vector vector = new Vector();
        while (prefix.getLength() > 0) {
            Hashtable hashtable = this.childMap.get(prefix);
            if (hashtable != null) {
                vector.addAll(hashtable.keySet());
            }
            if (prefix.getLength() <= 1) break;
            prefix = Prefix.getPrefixForIdWithLevel(prefix.getId(), prefix.getLength() - 2);
        }
        return vector;
    }

    public Hashtable getChildren(NodeId nodeId, int n) {
        Hashtable<NodeHandle, Integer> hashtable = new Hashtable<NodeHandle, Integer>();
        if (n == -1) {
            n = 40;
        }
        for (int i = 0; i < maxDiffDigit - 1 && i < n; ++i) {
            Prefix prefix = Prefix.getPrefixForIdWithDiffDigit(nodeId, i + 1);
            Hashtable hashtable2 = this.childMap.get(prefix);
            if (hashtable2 == null) continue;
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                NodeHandle nodeHandle = (NodeHandle)enumeration.nextElement();
                if (nodeHandle.getNodeId().indexOfMSDD(nodeId, idBaseBitLength) <= i) continue;
                hashtable.put(nodeHandle, new Integer(1));
            }
        }
        return hashtable;
    }

    public AML(PastryNode pastryNode) {
        this.lNode = pastryNode;
        this.init();
    }

    public void setIntf(DHTAMLInterface dHTAMLInterface) {
        this.intf = dHTAMLInterface;
    }

    public void initParentMap() {
        this.parentMap = new Hashtable();
        NodeId nodeId = this.lNode.getNodeId();
        for (int i = 0; i < maxDiffDigit; ++i) {
            Prefix prefix = Prefix.getPrefixForIdWithLevel(nodeId, i);
            this.parentMap.put(prefix, this.lnh);
        }
    }

    public void init() {
        RoutingTable routingTable = this.lNode.getRoutingTable();
        idBaseBitLength = routingTable.baseBitLength();
        maxDiffDigit = 160 / idBaseBitLength;
        this.intf = null;
        this.lnh = this.lNode.getLocalHandle();
        this.initParentMap();
        this.childMap = new HashHashTable();
        this.invParentMap = new HashHashTable();
        this.invChildMap = new HashHashTable();
        this.aft = new AggrFuncTable(this);
        this.neighs = new Hashtable();
        this.redDBs = new Hashtable();
        this.probeTable = new ProbeTable(this);
        this.probeCallBackTable = new Hashtable();
        this.amib = new AncestorMIB(this);
        Database database = new Database();
        this.neighs.put(this.lnh, database);
        Prefix prefix = new Prefix(new NodeId(), 0);
        this.redDBs.put(prefix, database);
        this.parentMap.put(prefix, this.lnh);
        this.lmodMap = new Hashtable();
    }

    static {
        DYNAMIC_UPDOWN = false;
    }
}

