/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.AML;

import java.util.Enumeration;
import java.util.Hashtable;
import rice.pastry.AML.AML;
import rice.pastry.AML.AggrFunc;
import rice.pastry.AML.Attribute;
import rice.pastry.AML.Prefix;
import rice.pastry.AML.messaging.InstallMessage;
import rice.pastry.Assert;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeName;

public class AggrFuncTable {
    Hashtable afmib = new Hashtable();
    AML aml;

    public AggrFuncTable(AML aML) {
        this.aml = aML;
    }

    public AggrFunc getAggrFunc(Attribute attribute) {
        AggrFunc aggrFunc = (AggrFunc)this.afmib.get(attribute);
        if (aggrFunc == null) {
            return (AggrFunc)this.afmib.get(attribute.type());
        }
        return aggrFunc;
    }

    public void onInstall(InstallMessage installMessage) {
        AggrFunc aggrFunc = installMessage.getAggrFunc();
        if (Log.ifp(6)) {
            System.out.println(this.aml.lnh + ": installing new agfun " + aggrFunc);
        }
        if (!this.afmib.containsKey(aggrFunc.getAttrType())) {
            Hashtable hashtable;
            this.afmib.put(aggrFunc.getAttrType(), aggrFunc);
            NodeId nodeId = AML.getId(aggrFunc.getAttr());
            Prefix prefix = Prefix.getPrefixForId(nodeId, this.aml.lNode);
            if (Log.ifp(6)) {
                System.out.println(this.aml.lnh + ": prefix computation for id " + nodeId + " is " + prefix);
            }
            NodeHandle nodeHandle = this.aml.getParent(prefix);
            InstallMessage installMessage2 = new InstallMessage(installMessage.getDestination(), this.aml.lnh, installMessage.getAggrFunc());
            if (nodeHandle != null && !nodeHandle.equals(installMessage.getFromNode())) {
                nodeHandle.receiveMessage(installMessage2);
            }
            if ((hashtable = this.aml.getChildren(nodeId, -1)) != null) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    NodeHandle nodeHandle2 = (NodeHandle)enumeration.nextElement();
                    if (nodeHandle2.equals(installMessage.getFromNode())) continue;
                    nodeHandle2.receiveMessage(installMessage2);
                }
            }
        }
    }

    public boolean isApplicableToNodeWRTName(Attribute attribute, NodeName nodeName) {
        AggrFunc aggrFunc = this.getAggrFunc(attribute);
        Assert.myAssert(aggrFunc != null);
        NodeName nodeName2 = aggrFunc.getDomain();
        if (nodeName2 != null) {
            return nodeName2.commonLevels(nodeName) == nodeName2.numLevels();
        }
        return true;
    }
}

