/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.AML;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import rice.pastry.AML.AML;
import rice.pastry.AML.AncestorMIBEntry;
import rice.pastry.AML.Attribute;
import rice.pastry.AML.Database;
import rice.pastry.AML.LeaserModule;
import rice.pastry.AML.Prefix;
import rice.pastry.AML.messaging.UpdateMessage;
import rice.pastry.Assert;
import rice.pastry.Id;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;

public class AncestorMIB {
    AML aml;
    Hashtable amibDBs;

    public AncestorMIB(AML aML) {
        this.aml = aML;
        this.amibDBs = new Hashtable();
    }

    public Database getDB(Prefix prefix) {
        return (Database)this.amibDBs.get(prefix);
    }

    public boolean addEntries(Prefix prefix, Vector vector, Vector vector2) {
        boolean bl = true;
        if (Log.ifp(6)) {
            System.out.println(this.aml.lnh + " " + prefix + ": Adding entries " + vector2 + " to " + vector);
        }
        if (vector2 == null || vector2.size() == 0) {
            if (vector.size() != 0) {
                vector.removeAllElements();
            } else {
                bl = false;
            }
            return bl;
        }
        AncestorMIBEntry ancestorMIBEntry = (AncestorMIBEntry)vector2.lastElement();
        for (int i = 0; i < vector.size(); ++i) {
            AncestorMIBEntry ancestorMIBEntry2 = (AncestorMIBEntry)vector.get(i);
            if (ancestorMIBEntry2.name.equals(ancestorMIBEntry.name) && (ancestorMIBEntry.parentName == null ? ancestorMIBEntry2.parentName == null : ancestorMIBEntry.parentName.equals(ancestorMIBEntry2.parentName)) && ancestorMIBEntry2.prefixLength == ancestorMIBEntry.prefixLength) {
                vector.remove(i);
                --i;
                break;
            }
            if (ancestorMIBEntry.parentName != null && ancestorMIBEntry.parentName.equals(ancestorMIBEntry2.parentName) && ancestorMIBEntry2.prefixLength > ancestorMIBEntry.prefixLength) break;
            vector.remove(i);
            --i;
        }
        vector.addAll(0, vector2);
        if (Log.ifp(6)) {
            System.out.println("After adding entries, curr is " + vector);
        }
        return bl;
    }

    public Vector getEntriesMatchingPrefixLength(Vector vector, int n) {
        Vector<AncestorMIBEntry> vector2 = new Vector<AncestorMIBEntry>();
        for (int i = 0; i < vector.size(); ++i) {
            AncestorMIBEntry ancestorMIBEntry = (AncestorMIBEntry)vector.get(i);
            if (n < ancestorMIBEntry.prefixLength) continue;
            vector2.add(ancestorMIBEntry);
        }
        return vector2;
    }

    public void propagateAMIBDownToChild(Prefix prefix, Attribute attribute, Vector vector, NodeHandle nodeHandle) {
        int n = this.aml.getDownValue(attribute);
        if (n == 0) {
            return;
        }
        if (nodeHandle.equals(this.aml.lnh)) {
            Assert.myAssert(prefix.getLength() > 0);
            Prefix prefix2 = Prefix.getPrefixForIdWithLevel(AML.getId(attribute), prefix.getLength() - 2);
            Vector vector2 = this.getEntriesMatchingPrefixLength(vector, prefix2.getLength() * AML.idBaseBitLength + n);
            if (vector2.size() > 0) {
                UpdateMessage updateMessage = new UpdateMessage(this.aml.intf.getAddress(), this.aml.lnh, attribute, vector2);
                updateMessage.setFromParent();
                this.onParentUpdate(prefix2, updateMessage);
            }
        } else if (this.aml.aft.isApplicableToNodeWRTName(attribute, nodeHandle.getNodeName())) {
            NodeId nodeId = AML.getId(attribute);
            int n2 = 159 - nodeHandle.getNodeId().indexOfMSDB(nodeId);
            Vector vector3 = this.getEntriesMatchingPrefixLength(vector, n2 + n);
            if (vector3.size() > 0) {
                if (Log.ifp(6)) {
                    System.out.println(this.aml.lnh + " " + prefix + ":Sending amib " + vector3 + " downwards to " + nodeHandle);
                }
                UpdateMessage updateMessage = new UpdateMessage(this.aml.intf.getAddress(), this.aml.lnh, attribute, vector3);
                updateMessage.setFromParent();
                nodeHandle.receiveMessage(updateMessage);
            }
        }
    }

    public int getDownValueForChild(Prefix prefix, Attribute attribute, NodeHandle nodeHandle) {
        int n;
        LeaserModule leaserModule;
        int n2 = this.aml.getDownValue(attribute);
        if (AML.DYNAMIC_UPDOWN && (leaserModule = this.aml.getLeaserModule(prefix, attribute)) != null && (n = leaserModule.leaseLevelToChild(leaserModule.getChildVID(nodeHandle))) > n2) {
            n2 = n;
        }
        return n2;
    }

    public void propagateAMIBDown(Prefix prefix, Attribute attribute, Vector vector) {
        int n;
        Serializable serializable;
        Serializable serializable2;
        Object object;
        Hashtable hashtable;
        Vector<AncestorMIBEntry> vector2 = new Vector<AncestorMIBEntry>(vector);
        AncestorMIBEntry ancestorMIBEntry = this.aml.getLocalAmibEntry(prefix, attribute);
        vector2.add(0, ancestorMIBEntry);
        if (Log.ifp(6)) {
            System.out.println(this.aml.lnh + " " + prefix + ": propagateAMIBDown at " + prefix + " " + attribute + " " + vector2);
        }
        if ((hashtable = this.aml.childMap.get(prefix)) != null) {
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                Vector vector3;
                serializable2 = (NodeHandle)object.nextElement();
                if (!this.aml.aft.isApplicableToNodeWRTName(attribute, ((NodeHandle)serializable2).getNodeName())) continue;
                serializable = AML.getId(attribute);
                int n2 = 159 - ((NodeHandle)serializable2).getNodeId().indexOfMSDB((Id)serializable);
                n = this.getDownValueForChild(prefix, attribute, (NodeHandle)serializable2);
                if (n <= 0 || (vector3 = this.getEntriesMatchingPrefixLength(vector2, n2 + n)).size() <= 0) continue;
                if (Log.ifp(6)) {
                    System.out.println(this.aml.lnh + " " + prefix + ":Sending amib " + vector3 + " downwards to " + serializable2);
                }
                UpdateMessage updateMessage = new UpdateMessage(this.aml.intf.getAddress(), this.aml.lnh, attribute, vector3);
                updateMessage.setFromParent();
                serializable2.receiveMessage(updateMessage);
            }
        }
        if (prefix.getLength() > 0) {
            object = Prefix.getPrefixForIdWithLevel(AML.getId(attribute), prefix.getLength() - 2);
            n = this.getDownValueForChild(prefix, attribute, this.aml.lnh);
            if (n > 0) {
                serializable2 = this.getEntriesMatchingPrefixLength(vector2, ((Prefix)object).getLength() * AML.idBaseBitLength + n);
                if (((Vector)serializable2).size() > 0) {
                    serializable = new UpdateMessage(this.aml.intf.getAddress(), this.aml.lnh, attribute, serializable2);
                    ((UpdateMessage)serializable).setFromParent();
                    this.onParentUpdate((Prefix)object, (UpdateMessage)serializable);
                }
            }
        }
    }

    public void timeStampEntries(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            AncestorMIBEntry ancestorMIBEntry = (AncestorMIBEntry)vector.get(i);
            ancestorMIBEntry.updateTime = new Date();
        }
    }

    public void onParentUpdate(Prefix prefix, UpdateMessage updateMessage) {
        LeaserModule leaserModule;
        Attribute attribute = updateMessage.getAttr();
        Vector vector = (Vector)updateMessage.getValue();
        Vector vector2 = this.getAMIB(prefix, attribute);
        this.timeStampEntries(vector);
        if (this.addEntries(prefix, vector2, vector)) {
            this.putAMIB(prefix, attribute, vector2);
            this.propagateAMIBDown(prefix, attribute, vector2);
        }
        this.aml.probeTable.onParentUpdate(prefix, updateMessage);
        if (AML.DYNAMIC_UPDOWN && (leaserModule = this.aml.getLeaserModule(prefix, attribute)) != null) {
            leaserModule.onUpdateFromParent(160);
        }
    }

    public Vector getAMIB(Prefix prefix, Attribute attribute) {
        Vector vector;
        Database database = (Database)this.amibDBs.get(prefix);
        if (database == null) {
            database = new Database();
            this.amibDBs.put(prefix, database);
        }
        if ((vector = (Vector)database.get(attribute)) == null) {
            return new Vector();
        }
        return vector;
    }

    public void putAMIB(Prefix prefix, Attribute attribute, Vector vector) {
        Database database = (Database)this.amibDBs.get(prefix);
        if (database == null) {
            database = new Database();
            this.amibDBs.put(prefix, database);
        }
        database.applyUpdate(attribute, vector);
    }

    public void onParentUpdate(UpdateMessage updateMessage) {
        NodeHandle nodeHandle = updateMessage.getFromNode();
        Attribute attribute = updateMessage.getAttr();
        if (Log.ifp(6)) {
            System.out.println(this.aml.lnh + ": Parent update from " + nodeHandle + " for " + attribute);
        }
        if (!nodeHandle.equals(this.aml.getParent(AML.getId(attribute)))) {
            if (Log.ifp(6)) {
                System.out.println(this.aml.lnh + ": WRONG???? Got paren update from " + nodeHandle + " where as parent is " + this.aml.getParent(AML.getId(attribute)));
            }
            return;
        }
        Prefix prefix = Prefix.getPrefixForId(AML.getId(attribute), this.aml.lNode);
        this.onParentUpdate(prefix, updateMessage);
    }
}

