/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.AML;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import rice.pastry.AML.AML;
import rice.pastry.AML.Prefix;
import rice.pastry.AML.messaging.ChildMessage;
import rice.pastry.Assert;
import rice.pastry.Id;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeName;
import rice.pastry.PastryNode;
import rice.pastry.client.CommonAPIAppl;
import rice.pastry.hdht.HdhtDirectPastryNode;
import rice.pastry.hdht.HdhtWirePastryNode;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.Credentials;
import rice.pastry.security.PermissiveCredentials;

public class DHTAMLInterface
extends CommonAPIAppl
implements Observer {
    AML localAML;
    private static Credentials cred = new PermissiveCredentials();
    public static Address addr = new AMLAddress();

    public DHTAMLInterface(PastryNode pastryNode, AML aML) {
        super(pastryNode);
        this.localAML = aML;
        aML.setIntf(this);
    }

    public void deliver(Id id, Message message) {
        if (message instanceof ChildMessage) {
            ChildMessage childMessage = (ChildMessage)message;
            if (childMessage.getWasAdded()) {
                this.localAML.newChild(childMessage.getPrefix(), childMessage.getFromNode());
            } else {
                if (Log.ifp(6)) {
                    System.out.println(this.getNodeHandle() + ": Child " + childMessage.getFromNode() + " chose some other parent for prefix " + childMessage.getPrefix());
                }
                this.localAML.failedChild(childMessage.getFromNode(), childMessage.getPrefix());
            }
        } else {
            this.localAML.receiveMessage(message);
        }
    }

    public void forward(RouteMessage routeMessage) {
    }

    public void update(Observable observable, Object object) {
        Prefix prefix;
        Iterator iterator;
        Hashtable hashtable;
        NodeHandle nodeHandle = (NodeHandle)observable;
        if (((Integer)object).equals(NodeHandle.DECLARED_DEAD)) {
            System.out.println(this.getNodeHandle() + ": Received node dead event for " + nodeHandle);
            nodeHandle.deleteObserver(this);
        }
        if (((Integer)object).equals(NodeHandle.DECLARED_DEAD) && (hashtable = this.localAML.invParentMap.get(nodeHandle)) != null) {
            hashtable = (Hashtable)hashtable.clone();
            iterator = hashtable.keySet().iterator();
            while (iterator.hasNext()) {
                prefix = (Prefix)iterator.next();
                NodeHandle nodeHandle2 = this.getParent(prefix);
                if (nodeHandle2 != null && nodeHandle2.equals(nodeHandle)) continue;
                if (nodeHandle2 != null) {
                    nodeHandle2.receiveMessage(new ChildMessage(this.getAddress(), this.getNodeHandle(), prefix, true));
                }
                nodeHandle.receiveMessage(new ChildMessage(this.getAddress(), this.getNodeHandle(), prefix, false));
                this.localAML.newParent(prefix, nodeHandle2);
            }
        }
        if (((Integer)object).equals(NodeHandle.DECLARED_DEAD) && (hashtable = this.localAML.invChildMap.get(nodeHandle)) != null) {
            hashtable = (Hashtable)hashtable.clone();
            iterator = hashtable.keySet().iterator();
            while (iterator.hasNext()) {
                prefix = (Prefix)iterator.next();
                this.localAML.failedChild(nodeHandle, prefix);
            }
        }
    }

    public void nodeChange(NodeHandle nodeHandle, boolean bl) {
        if (bl) {
            nodeHandle.addObserver(this);
            int n = AML.idBaseBitLength;
            int n2 = this.getNodeId().indexOfMSDD(nodeHandle.getNodeId(), n);
            int n3 = n2 - 1;
            while (true) {
                if (n3 < AML.maxDiffDigit) {
                    for (int i = 0; i < 1 << n; ++i) {
                        NodeHandle nodeHandle2;
                        Prefix prefix = new Prefix(new NodeId(this.getNodeId().getDomainPrefix(n3, i, 0, n).copy()), AML.maxDiffDigit - n3);
                        NodeHandle nodeHandle3 = this.getParent(prefix);
                        if (nodeHandle3 == null || !nodeHandle3.equals(nodeHandle) || (nodeHandle2 = this.localAML.getParent(prefix)) != null && nodeHandle2.equals(nodeHandle)) continue;
                        nodeHandle.receiveMessage(new ChildMessage(this.getAddress(), this.getNodeHandle(), prefix, true));
                        if (nodeHandle2 != null) {
                            nodeHandle2.receiveMessage(new ChildMessage(this.getAddress(), this.getNodeHandle(), prefix, false));
                        }
                        this.localAML.newParent(prefix, nodeHandle);
                    }
                    ++n3;
                    continue;
                }
                break;
            }
        } else {
            Hashtable hashtable = this.localAML.invParentMap.get(nodeHandle);
            if (hashtable != null) {
                hashtable = (Hashtable)hashtable.clone();
                Iterator iterator = hashtable.keySet().iterator();
                while (iterator.hasNext()) {
                    Prefix prefix = (Prefix)iterator.next();
                    NodeHandle nodeHandle4 = this.getParent(prefix);
                    if (nodeHandle4 != null && nodeHandle4.equals(nodeHandle)) continue;
                    if (nodeHandle4 != null) {
                        nodeHandle4.receiveMessage(new ChildMessage(this.getAddress(), this.getNodeHandle(), prefix, true));
                    }
                    this.localAML.newParent(prefix, nodeHandle4);
                }
            }
        }
    }

    public void update(NodeHandle nodeHandle, boolean bl) {
        if (Log.ifp(8)) {
            System.out.println(this.getNodeHandle() + " LS: Node " + nodeHandle + " is added " + bl);
        }
        this.nodeChange(nodeHandle, bl);
    }

    public void routeSetChange(NodeHandle nodeHandle, boolean bl) {
        if (Log.ifp(8)) {
            System.out.println(this.getNodeHandle() + " RS: Node " + nodeHandle + " is added " + bl);
        }
        this.nodeChange(nodeHandle, bl);
    }

    public void notifyReady() {
        if (Log.ifp(10)) {
            System.out.println(this.getNodeHandle() + " Got notify ready");
        }
    }

    public AML getAML() {
        return this.localAML;
    }

    public Address getAddress() {
        return addr;
    }

    public Credentials getCredentials() {
        return cred;
    }

    public NodeHandle getParent(Prefix prefix) {
        NodeHandle nodeHandle = this.getNodeHandle();
        Prefix prefix2 = Prefix.getPrefixForId(prefix.id, nodeHandle);
        if (prefix2.getLength() >= prefix.getLength() + 1) {
            return null;
        }
        return this.getParent(prefix.id);
    }

    public NodeHandle getParent(NodeId nodeId) {
        RoutingTable routingTable = this.getRoutingTable();
        NodeId nodeId2 = this.getNodeId();
        LeafSet[] leafSetArray = null;
        NodeHandle nodeHandle = this.getNodeHandle();
        if (this.thePastryNode instanceof HdhtDirectPastryNode) {
            leafSetArray = ((HdhtDirectPastryNode)this.thePastryNode).getLeafSetArr();
        } else if (this.thePastryNode instanceof HdhtWirePastryNode) {
            leafSetArray = ((HdhtWirePastryNode)this.thePastryNode).getLeafSetArr();
        }
        if (nodeId == null || nodeId.equals(nodeHandle.getNodeId())) {
            return null;
        }
        int n = routingTable.baseBitLength();
        int n2 = nodeId2.indexOfMSDD(nodeId, n);
        int n3 = nodeId2.indexOfMSDD(nodeId, 1);
        NodeName nodeName = nodeHandle.getNodeName();
        Serializable serializable = null;
        if (n2 >= 0) {
            int n4 = nodeName.numLevels() - 1;
            boolean bl = false;
            while (!bl) {
                Serializable serializable2;
                int n5;
                int n6;
                int n7 = 1 << n;
                int n8 = nodeId.getDigit(n2, n);
                int n9 = nodeId2.getDigit(n2, n);
                Serializable serializable3 = nodeId2.distance(nodeId);
                int n10 = n3;
                boolean bl2 = false;
                RouteSet routeSet = routingTable.getBestEntry(nodeId);
                if (routeSet == null || (serializable = routeSet.closestNode()) == null || nodeName.commonLevels(serializable.getNodeName()) != n4) {
                    serializable = null;
                    for (n6 = 0; n6 < n7; ++n6) {
                        NodeHandle nodeHandle2;
                        routeSet = routingTable.getRouteSet(n2, n6);
                        if (routeSet == null || (nodeHandle2 = routeSet.closestNode()) == null || (n5 = nodeHandle2.getNodeId().indexOfMSDD(nodeId, 1)) > n10) continue;
                        if (nodeHandle2.getNodeName() == null) {
                            System.out.println("no name for node handle -- " + nodeHandle2);
                        }
                        if (nodeName.commonLevels(nodeHandle2.getNodeName()) != n4 || !nodeHandle2.isAlive()) continue;
                        serializable2 = nodeHandle2.getNodeId().distance(nodeId);
                        if (n5 >= n10 && ((Id.Distance)serializable3).compareTo(serializable2) <= 0) continue;
                        n10 = n5;
                        serializable3 = serializable2;
                        serializable = nodeHandle2;
                    }
                }
                if (serializable == null) {
                    Assert.myAssert(leafSetArray.length > n4);
                    n6 = leafSetArray[n4].cwSize();
                    int n11 = leafSetArray[n4].ccwSize();
                    for (n5 = -n11; n5 <= n6; ++n5) {
                        int n12;
                        if (n5 == 0 || (serializable2 = leafSetArray[n4].get(n5)) == null || (n12 = ((NodeHandle)serializable2).getNodeId().indexOfMSDD(nodeId, 1)) > n10) continue;
                        Id.Distance distance = ((NodeHandle)serializable2).getNodeId().distance(nodeId);
                        if (n12 >= n10 && ((Id.Distance)serializable3).compareTo(distance) <= 0 || !((NodeHandle)serializable2).isAlive()) continue;
                        serializable3 = distance;
                        n10 = n12;
                        serializable = serializable2;
                    }
                }
                if (serializable != null) {
                    bl = true;
                    continue;
                }
                if (n4 == 0) {
                    bl = true;
                    continue;
                }
                --n4;
            }
        }
        if (serializable != null && serializable.equals(nodeHandle)) {
            serializable = null;
        }
        return serializable;
    }

    private static class AMLAddress
    implements Address {
        private int myCode = -1842817281;

        private AMLAddress() {
        }

        public int hashCode() {
            return this.myCode;
        }

        public boolean equals(Object object) {
            return object instanceof AMLAddress;
        }

        public String toString() {
            return "[AMLAddress]";
        }
    }
}

