/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.AML;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import rice.pastry.AML.AML;
import rice.pastry.AML.AggrFunc;
import rice.pastry.AML.Attribute;
import rice.pastry.AML.Prefix;
import rice.pastry.AML.RaterModule;
import rice.pastry.AML.VirtualNodeID;
import rice.pastry.AML.messaging.LeaseMessage;
import rice.pastry.AML.messaging.ProbeMessage;
import rice.pastry.Assert;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;

public class LeaserModule {
    AML aml;
    Hashtable dataMap;
    public RaterModule rater;
    public VirtualNodeID lvid;
    public Attribute attr;

    public int hashCode() {
        return this.lvid.hashCode() + this.attr.hashCode();
    }

    public boolean equals(Object object) {
        LeaserModule leaserModule = (LeaserModule)object;
        return leaserModule.lvid.equals(this.lvid) && leaserModule.attr.equals(this.attr);
    }

    public void init() {
        this.rater = new RaterModule();
        this.dataMap = new Hashtable();
    }

    public LeaserModule(VirtualNodeID virtualNodeID, Attribute attribute, AML aML) {
        this.lvid = virtualNodeID;
        this.attr = attribute;
        this.aml = aML;
        this.init();
    }

    public LeaseData getLeaseData(VirtualNodeID virtualNodeID) {
        LeaseData leaseData = (LeaseData)this.dataMap.get(virtualNodeID);
        if (leaseData == null) {
            leaseData = new LeaseData();
            this.dataMap.put(virtualNodeID, leaseData);
        }
        return leaseData;
    }

    public boolean isLeasedFromAllChildren() {
        Object object;
        AggrFunc aggrFunc = this.aml.aft.getAggrFunc(this.attr);
        Assert.myAssert(aggrFunc != null);
        int n = this.aml.getUpValue(this.attr);
        int n2 = this.aml.getMatchingPrefixLength(this.lvid.prefix, this.attr);
        if (n > n2) {
            return true;
        }
        Hashtable hashtable = this.aml.childMap.get(this.lvid.prefix);
        Vector vector = new Vector();
        if (hashtable != null) {
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                NodeHandle nodeHandle = (NodeHandle)object.nextElement();
                NodeId nodeId = AML.getId(this.attr);
                int n3 = 159 - nodeHandle.getNodeId().indexOfMSDB(nodeId);
                if (n3 < this.aml.getUpValue(this.attr) || this.isLeasedFromChild(new VirtualNodeID(null, nodeHandle))) continue;
                return false;
            }
        }
        if (this.lvid.prefix().getLength() > 0) {
            object = Prefix.getPrefixForIdWithLevel(AML.getId(this.attr), this.lvid.prefix().getLength() - 2);
            int n4 = this.aml.getMatchingPrefixLength((Prefix)object, this.attr);
            if (n4 >= this.aml.getUpValue(this.attr) && !this.isLeasedFromChild(new VirtualNodeID((Prefix)object, this.lvid.nh()))) {
                return false;
            }
        }
        return true;
    }

    public boolean isGoodForLease(int n, VirtualNodeID virtualNodeID) {
        return true;
    }

    public void sendLeaseMessageToNode(int n, VirtualNodeID virtualNodeID) {
        if (virtualNodeID.nh.equals(this.lvid.nh)) {
            LeaserModule leaserModule = this.aml.getLeaserModule(virtualNodeID, this.attr);
            Assert.myAssert(leaserModule != null);
            leaserModule.onLeaseMessage(this.lvid, n);
        } else {
            NodeHandle nodeHandle = this.aml.getParent(this.lvid.prefix());
            LeaseMessage leaseMessage = new LeaseMessage(this.aml.intf.getAddress(), this.aml.lnh, this.attr, n);
            if (nodeHandle == null || !nodeHandle.equals(virtualNodeID.nh)) {
                leaseMessage.setFromParent();
            }
            virtualNodeID.nh().receiveMessage(leaseMessage);
        }
    }

    public void onProbeForLocalAggregate(VirtualNodeID virtualNodeID) {
        NodeHandle nodeHandle;
        int n;
        if (this.isLeasedFromAllChildren() && this.isGoodForLease(n = (nodeHandle = this.aml.getParent(this.lvid.prefix())) == null ? 160 : this.aml.getMatchingPrefixLength(this.lvid.prefix(), this.attr), virtualNodeID)) {
            this.sendLeaseMessageToNode(n, virtualNodeID);
            LeaseData leaseData = this.getLeaseData(virtualNodeID);
            leaseData.leaseTo = n;
        }
    }

    public void onProbeForAncestorAggregate(VirtualNodeID virtualNodeID, int n) {
        if (this.leaseLevelFromParent() >= n && this.isGoodForLease(n, virtualNodeID)) {
            this.sendLeaseMessageToNode(n, virtualNodeID);
            LeaseData leaseData = this.getLeaseData(virtualNodeID);
            leaseData.leaseTo = n;
        }
    }

    public void onProbe(ProbeMessage probeMessage) {
        Serializable serializable;
        int n = this.aml.getMatchingPrefixLength(this.lvid.prefix(), this.attr);
        VirtualNodeID virtualNodeID = null;
        if (probeMessage.getFromNode().equals(this.aml.lnh)) {
            serializable = null;
            if (probeMessage.fromParent) {
                serializable = Prefix.getPrefixForIdWithLevel(AML.getId(this.attr), this.lvid.prefix().getLength());
            } else {
                if (this.lvid.prefix().getLength() < 1) {
                    return;
                }
                serializable = Prefix.getPrefixForIdWithLevel(AML.getId(this.attr), this.lvid.prefix().getLength() - 2);
            }
            virtualNodeID = new VirtualNodeID(this.aml.lnh, (Prefix)serializable);
        } else {
            virtualNodeID = new VirtualNodeID(probeMessage.getFromNode(), null);
        }
        serializable = this.aml.getParent(this.lvid.prefix());
        if (n == probeMessage.level || serializable == null) {
            this.onProbeForLocalAggregate(virtualNodeID);
        } else if (n < probeMessage.level) {
            this.onProbeForAncestorAggregate(virtualNodeID, probeMessage.level);
        }
    }

    public boolean isLeasedToAnyNode(int n) {
        Iterator iterator = this.dataMap.keySet().iterator();
        while (iterator.hasNext()) {
            VirtualNodeID virtualNodeID = (VirtualNodeID)iterator.next();
            LeaseData leaseData = this.getLeaseData(virtualNodeID);
            if (leaseData.leaseTo < n) continue;
            return true;
        }
        return false;
    }

    public boolean isGoodForUnlease(int n, VirtualNodeID virtualNodeID) {
        return true;
    }

    public void sendUnleaseMessage(int n, VirtualNodeID virtualNodeID) {
        this.sendLeaseMessageToNode(-1, virtualNodeID);
    }

    public void onUpdateFromParent(int n) {
        VirtualNodeID virtualNodeID = this.getParentVID(this.lvid.prefix());
        if (this.leaseLevelFromParent() >= n && !this.isLeasedToAnyNode(n) && this.isGoodForUnlease(n, virtualNodeID)) {
            this.sendUnleaseMessage(n, virtualNodeID);
            LeaseData leaseData = this.getLeaseData(virtualNodeID);
            leaseData.leaseFrom = -1;
        }
    }

    public void onUpdateFromChild(VirtualNodeID virtualNodeID) {
        int n = this.aml.getMatchingPrefixLength(this.lvid.prefix(), this.attr);
        if (this.isLeasedFromChild(virtualNodeID) && !this.isLeasedToAnyNode(n) && this.isGoodForUnlease(n, virtualNodeID)) {
            this.sendUnleaseMessage(n, virtualNodeID);
            LeaseData leaseData = this.getLeaseData(virtualNodeID);
            leaseData.leaseFrom = -1;
        }
    }

    public VirtualNodeID getParentVID(Prefix prefix) {
        NodeHandle nodeHandle = this.aml.getParent(prefix);
        if (nodeHandle == null) {
            return null;
        }
        Prefix prefix2 = null;
        if (nodeHandle.equals(this.aml.lnh)) {
            prefix2 = Prefix.getPrefixForIdWithLevel(AML.getId(this.attr), this.lvid.prefix().getLength());
        }
        VirtualNodeID virtualNodeID = new VirtualNodeID(nodeHandle, prefix2);
        return virtualNodeID;
    }

    public boolean isLeasedToParent() {
        VirtualNodeID virtualNodeID = this.getParentVID(this.lvid.prefix);
        LeaseData leaseData = this.getLeaseData(virtualNodeID);
        return leaseData.leaseTo != -1;
    }

    public boolean isLeasedFromChild(VirtualNodeID virtualNodeID) {
        LeaseData leaseData = this.getLeaseData(virtualNodeID);
        return leaseData.leaseFrom != -1;
    }

    public int leaseLevelFromParent() {
        VirtualNodeID virtualNodeID = this.getParentVID(this.lvid.prefix);
        if (virtualNodeID == null) {
            return 160;
        }
        LeaseData leaseData = this.getLeaseData(virtualNodeID);
        return leaseData.leaseFrom;
    }

    public int leaseLevelToChild(VirtualNodeID virtualNodeID) {
        LeaseData leaseData = this.getLeaseData(virtualNodeID);
        return leaseData.leaseTo;
    }

    public VirtualNodeID getChildVID(NodeHandle nodeHandle) {
        Prefix prefix = null;
        if (nodeHandle.equals(this.aml.lnh)) {
            Assert.myAssert(this.lvid.prefix.getLength() > 0);
            prefix = Prefix.getPrefixForIdWithLevel(AML.getId(this.attr), this.lvid.prefix().getLength() - 2);
        }
        VirtualNodeID virtualNodeID = new VirtualNodeID(nodeHandle, prefix);
        return virtualNodeID;
    }

    public void onLeaseMessage(VirtualNodeID virtualNodeID, int n) {
        LeaseData leaseData = this.getLeaseData(virtualNodeID);
        if (n != -1) {
            leaseData.leaseFrom = n;
        } else {
            leaseData.leaseTo = -1;
        }
        if (Log.ifp(6)) {
            System.out.println(this.lvid + " got lease for level " + n + " from " + virtualNodeID);
        }
    }

    public void onLeaseMessage(LeaseMessage leaseMessage) {
        VirtualNodeID virtualNodeID = null;
        virtualNodeID = leaseMessage.isFromParent() ? this.getParentVID(this.lvid.prefix()) : this.getChildVID(leaseMessage.getFromNode());
        this.onLeaseMessage(virtualNodeID, leaseMessage.getLease());
    }

    public void onNewParent() {
    }

    public void onNewChild(VirtualNodeID virtualNodeID) {
    }

    public void onFailedChild(VirtualNodeID virtualNodeID) {
    }

    public class LeaseData {
        public int leaseTo = -1;
        public int leaseFrom = -1;
    }
}

