/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.AML;

import java.io.Serializable;
import rice.pastry.AML.AML;
import rice.pastry.Assert;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;

public class Prefix
implements Serializable {
    NodeId id;
    int len;

    public Prefix(NodeId nodeId, int n) {
        this.len = n;
        this.id = nodeId;
    }

    public boolean equals(Object object) {
        Prefix prefix = (Prefix)object;
        return prefix.id.equals(this.id) && prefix.len == this.len;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id + "(" + this.len + ")";
    }

    public NodeId getId() {
        return this.id;
    }

    public int getLength() {
        return this.len;
    }

    public void setLength(int n) {
        this.len = n;
    }

    public static int getMaxLength() {
        return AML.maxDiffDigit - 1;
    }

    public static Prefix getPrefixForId(NodeId nodeId, PastryNode pastryNode) {
        return Prefix.getPrefixForId(nodeId, pastryNode.getLocalHandle());
    }

    public static Prefix getPrefixForId(NodeId nodeId, NodeHandle nodeHandle) {
        int n = nodeHandle.getNodeId().indexOfMSDD(nodeId, AML.idBaseBitLength);
        return Prefix.getPrefixForIdWithDiffDigit(nodeId, n);
    }

    public static Prefix getPrefixForIdWithDiffDigit(NodeId nodeId, int n) {
        Assert.myAssert(n >= 0);
        Assert.myAssert(n <= AML.maxDiffDigit, "diffDigit is " + n + " and max is " + AML.maxDiffDigit);
        Prefix prefix = null;
        if (n == AML.maxDiffDigit) {
            NodeId nodeId2 = new NodeId();
            prefix = new Prefix(nodeId2, AML.maxDiffDigit - n);
        } else if (n > 0) {
            NodeId nodeId3 = new NodeId(nodeId.getDomainPrefix(n - 1, 0, 0, AML.idBaseBitLength).copy());
            prefix = new Prefix(nodeId3, AML.maxDiffDigit - n);
        } else {
            NodeId nodeId4 = new NodeId(nodeId.getDomainPrefix(n, 0, 0, AML.idBaseBitLength).copy());
            prefix = new Prefix(nodeId4, AML.maxDiffDigit - (n + 1));
        }
        return prefix;
    }

    public static Prefix getPrefixForIdWithLevel(NodeId nodeId, int n) {
        int n2 = 160;
        Assert.myAssert(AML.maxDiffDigit > n);
        int n3 = AML.maxDiffDigit - 1 - n;
        return Prefix.getPrefixForIdWithDiffDigit(nodeId, n3);
    }
}

