/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.AML;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import rice.pastry.AML.AML;
import rice.pastry.AML.AncestorMIBEntry;
import rice.pastry.AML.Attribute;
import rice.pastry.AML.HashHashTable;
import rice.pastry.AML.LeaserModule;
import rice.pastry.AML.Prefix;
import rice.pastry.AML.ProbeAction;
import rice.pastry.AML.ProbeCallBack;
import rice.pastry.AML.VirtualNodeID;
import rice.pastry.AML.messaging.ProbeMessage;
import rice.pastry.AML.messaging.UpdateMessage;
import rice.pastry.Assert;
import rice.pastry.Id;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.messaging.Message;

public class ProbeTable {
    HashHashTable probesToChild = new HashHashTable();
    HashHashTable probesToParent = new HashHashTable();
    AML aml;

    public ProbeTable(AML aML) {
        this.aml = aML;
    }

    public void onAnswer(ProbeMessage probeMessage, Object object) {
        ProbeCallBack probeCallBack = (ProbeCallBack)this.aml.probeCallBackTable.get(probeMessage);
        if (probeCallBack != null) {
            probeCallBack.onAnswer(probeMessage, object);
        } else {
            System.out.println(this.aml.lnh + ": Got probe response: " + object);
        }
    }

    public void newProbe(ProbeMessage probeMessage) {
        NodeHandle nodeHandle = probeMessage.getFromNode();
        Prefix prefix = null;
        prefix = probeMessage.fromParent ? Prefix.getPrefixForId(AML.getId(probeMessage.attr), this.aml.lnh) : (nodeHandle.equals(this.aml.lnh) ? new Prefix(new NodeId(), 0) : Prefix.getPrefixForId(AML.getId(probeMessage.attr), nodeHandle));
        this.newProbe(prefix, probeMessage);
    }

    public boolean storeProbeToChild(Prefix prefix, ProbeMessage probeMessage, Hashtable hashtable) {
        return this.probesToChild.insertEntry(prefix, probeMessage, hashtable);
    }

    public boolean storeProbeToParent(Prefix prefix, ProbeMessage probeMessage) {
        return this.probesToParent.insertEntry(prefix, probeMessage);
    }

    public ProbeMessage clone(ProbeMessage probeMessage) {
        ProbeMessage probeMessage2 = new ProbeMessage(this.aml.intf.getAddress(), this.aml.lnh, probeMessage.attr, probeMessage.origNodeName, probeMessage.serialNum);
        probeMessage2.level = probeMessage.level;
        probeMessage2.up = probeMessage.up;
        probeMessage2.down = probeMessage.down;
        probeMessage2.continuous = probeMessage.continuous;
        return probeMessage2;
    }

    public void sendProbeResponseToChild(Prefix prefix, ProbeMessage probeMessage, Vector vector) {
        Serializable serializable;
        Serializable serializable2 = (AncestorMIBEntry)vector.lastElement();
        if (probeMessage.level > ((AncestorMIBEntry)serializable2).prefixLength && ((AncestorMIBEntry)serializable2).parentName != null) {
            serializable = new AncestorMIBEntry(probeMessage.level, ((AncestorMIBEntry)serializable2).parentName, ((AncestorMIBEntry)serializable2).parentName, ((AncestorMIBEntry)serializable2).value);
            ((AncestorMIBEntry)serializable).updateTime = ((AncestorMIBEntry)serializable2).updateTime;
            vector.add(serializable);
        }
        serializable2 = new UpdateMessage(this.aml.intf.getAddress(), this.aml.lnh, probeMessage.attr, vector);
        ((UpdateMessage)serializable2).setFromParent();
        serializable = probeMessage.getFromNode();
        if (((NodeHandle)serializable).equals(this.aml.lnh)) {
            if (prefix.getLength() == 0) {
                this.onAnswer(probeMessage, vector);
            } else {
                Prefix prefix2 = Prefix.getPrefixForIdWithLevel(AML.getId(probeMessage.attr), prefix.getLength() - 2);
                this.aml.amib.onParentUpdate(prefix2, (UpdateMessage)serializable2);
            }
        } else {
            serializable.receiveMessage((Message)serializable2);
        }
    }

    public void respondWithLocalAggregate(Prefix prefix, ProbeMessage probeMessage) {
        Attribute attribute = probeMessage.attr;
        if (probeMessage.fromParent) {
            if (Log.ifp(6)) {
                System.out.println(this.aml.lnh + " " + prefix + ": responding with local aggr for pmsg from PARENT");
            }
            Object object = this.aml.getRedDBValue(prefix, attribute);
            this.aml.sendAggregateValueUp(prefix, attribute, object);
        } else {
            NodeHandle nodeHandle = probeMessage.getFromNode();
            if (Log.ifp(6)) {
                System.out.println(this.aml.lnh + " " + prefix + ": responding with local aggr for pmsg from CHILD " + nodeHandle);
            }
            Vector<AncestorMIBEntry> vector = new Vector<AncestorMIBEntry>();
            AncestorMIBEntry ancestorMIBEntry = this.aml.getLocalAmibEntry(prefix, attribute);
            vector.add(0, ancestorMIBEntry);
            UpdateMessage updateMessage = new UpdateMessage(this.aml.intf.getAddress(), this.aml.lnh, attribute, vector);
            updateMessage.setFromParent();
            if (nodeHandle.equals(this.aml.lnh)) {
                if (prefix.getLength() == 0) {
                    this.onAnswer(probeMessage, vector);
                } else {
                    Prefix prefix2 = Prefix.getPrefixForIdWithLevel(AML.getId(probeMessage.attr), prefix.getLength() - 2);
                    this.aml.amib.onParentUpdate(prefix2, updateMessage);
                }
            } else {
                nodeHandle.receiveMessage(updateMessage);
            }
        }
    }

    public ProbeAction actionForProbe(Prefix prefix, Attribute attribute, int n, int n2, int n3) {
        Object object;
        Object object2;
        int n4 = this.aml.getMatchingPrefixLength(prefix, attribute);
        int n5 = this.aml.getUpValue(attribute);
        int n6 = this.aml.getDownValue(attribute);
        NodeHandle nodeHandle = this.aml.getParent(prefix);
        Assert.myAssert(n2 <= n);
        if (n4 < n2 && nodeHandle != null) {
            return new ProbeAction(ProbeAction.SENDUP, null);
        }
        if (Log.ifp(6)) {
            System.out.println(this.aml.lnh + ", prefix " + prefix + ": got probe for level " + n + " " + n4);
        }
        if (n4 < n && nodeHandle != null) {
            LeaserModule leaserModule;
            if (n6 >= n - n4 && n5 >= n) {
                return new ProbeAction(ProbeAction.LOCALOP, null);
            }
            if (AML.DYNAMIC_UPDOWN && (leaserModule = this.aml.getLeaserModule(prefix, attribute)) != null && leaserModule.leaseLevelFromParent() >= n) {
                return new ProbeAction(ProbeAction.LOCALOP, null);
            }
            return new ProbeAction(ProbeAction.SENDUP, null);
        }
        if (prefix.getLength() == 0 || (n5 > n4 || n5 == -1) && n3 <= 0 || n4 == 0 && n5 == 0 && prefix.getLength() == 0) {
            return new ProbeAction(ProbeAction.LOCALOP, null);
        }
        Hashtable<NodeHandle, Integer> hashtable = new Hashtable<NodeHandle, Integer>();
        Hashtable hashtable2 = this.aml.childMap.get(prefix);
        if (hashtable2 != null) {
            object2 = hashtable2.keys();
            while (object2.hasMoreElements()) {
                NodeHandle nodeHandle2 = (NodeHandle)object2.nextElement();
                if (Log.ifp(8)) {
                    System.out.println(this.aml.lnh + ", prefix " + prefix + ": childSet has: " + nodeHandle2);
                }
                if (!this.aml.aft.isApplicableToNodeWRTName(attribute, nodeHandle2.getNodeName())) continue;
                object = AML.getId(attribute);
                int n7 = 159 - nodeHandle2.getNodeId().indexOfMSDB((Id)object);
                if (n7 >= n - n3) {
                    hashtable.put(nodeHandle2, new Integer(n7));
                    if (!Log.ifp(8)) continue;
                    System.out.println(this.aml.lnh + ", prefix " + prefix + ": Will wait on " + nodeHandle2);
                    continue;
                }
                if (n7 < n5) continue;
                LeaserModule leaserModule = this.aml.getLeaserModule(prefix, attribute);
                if (AML.DYNAMIC_UPDOWN && leaserModule != null && leaserModule.isLeasedFromChild(new VirtualNodeID(nodeHandle2, null))) continue;
                hashtable.put(nodeHandle2, new Integer(n7));
                if (!Log.ifp(8)) continue;
                System.out.println(this.aml.lnh + ", prefix " + prefix + ": Will wait on " + nodeHandle2);
            }
        }
        Assert.myAssert(prefix.getLength() > 0);
        object2 = Prefix.getPrefixForIdWithLevel(AML.getId(attribute), prefix.getLength() - 2);
        int n8 = this.aml.getMatchingPrefixLength((Prefix)object2, attribute);
        if (n8 >= n - n3) {
            hashtable.put(this.aml.lnh, new Integer(n8));
            if (Log.ifp(8)) {
                System.out.println(this.aml.lnh + ", prefix " + prefix + ": Will wait on " + this.aml.lnh);
            }
        } else if (n8 >= n5) {
            object = this.aml.getLeaserModule(prefix, attribute);
            if (!AML.DYNAMIC_UPDOWN || object == null || !((LeaserModule)object).isLeasedFromChild(new VirtualNodeID(this.aml.lnh, (Prefix)object2))) {
                hashtable.put(this.aml.lnh, new Integer(n8));
                if (Log.ifp(8)) {
                    System.out.println(this.aml.lnh + ", prefix " + prefix + ": Will wait on " + this.aml.lnh);
                }
            }
        }
        if (hashtable.size() > 0) {
            return new ProbeAction(ProbeAction.SENDDOWN, hashtable);
        }
        return new ProbeAction(ProbeAction.LOCALOP, null);
    }

    public void respondLocally(Prefix prefix, ProbeMessage probeMessage) {
        Attribute attribute = probeMessage.attr;
        int n = this.aml.getMatchingPrefixLength(prefix, attribute);
        if (probeMessage.level > n) {
            Vector<AncestorMIBEntry> vector = new Vector<AncestorMIBEntry>(this.aml.amib.getAMIB(prefix, attribute));
            vector.add(0, this.aml.getLocalAmibEntry(prefix, attribute));
            Vector vector2 = this.aml.amib.getEntriesMatchingPrefixLength(vector, probeMessage.level);
            this.sendProbeResponseToChild(prefix, probeMessage, vector2);
        } else {
            this.respondWithLocalAggregate(prefix, probeMessage);
        }
        if (probeMessage.continuous) {
            if (probeMessage.level > n && this.aml.getParent(prefix) != null) {
                this.storeProbeToParent(prefix, probeMessage);
            } else {
                this.storeProbeToChild(prefix, probeMessage, new Hashtable());
            }
        }
    }

    public void sendProbeToParent(Prefix prefix, ProbeMessage probeMessage) {
        NodeHandle nodeHandle = this.aml.getParent(prefix);
        this.storeProbeToParent(prefix, probeMessage);
        if (nodeHandle.equals(this.aml.lnh)) {
            Prefix prefix2 = Prefix.getPrefixForIdWithLevel(AML.getId(probeMessage.attr), prefix.getLength());
            this.newProbe(prefix2, this.clone(probeMessage));
        } else {
            nodeHandle.receiveMessage(this.clone(probeMessage));
        }
    }

    public void sendProbeToChildren(Prefix prefix, ProbeMessage probeMessage, Hashtable hashtable) {
        this.storeProbeToChild(prefix, probeMessage, hashtable);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            NodeHandle nodeHandle = (NodeHandle)enumeration.nextElement();
            ProbeMessage probeMessage2 = this.clone(probeMessage);
            probeMessage2.up = probeMessage2.level = ((Integer)hashtable.get(nodeHandle)).intValue();
            probeMessage2.down = probeMessage.down - (probeMessage.level - probeMessage2.level);
            probeMessage2.fromParent = true;
            if (nodeHandle.equals(this.aml.lnh)) {
                Prefix prefix2 = Prefix.getPrefixForIdWithLevel(AML.getId(probeMessage.attr), prefix.getLength() - 2);
                this.newProbe(prefix2, probeMessage2);
                continue;
            }
            nodeHandle.receiveMessage(probeMessage2);
        }
    }

    public void newProbe(Prefix prefix, ProbeMessage probeMessage) {
        LeaserModule leaserModule;
        Attribute attribute = probeMessage.attr;
        ProbeAction probeAction = this.actionForProbe(prefix, attribute, probeMessage.level, probeMessage.up, probeMessage.down);
        if (probeAction.type == ProbeAction.LOCALOP) {
            this.respondLocally(prefix, probeMessage);
        } else if (probeAction.type == ProbeAction.SENDUP) {
            this.sendProbeToParent(prefix, probeMessage);
        } else if (probeAction.type == ProbeAction.SENDDOWN) {
            this.sendProbeToChildren(prefix, probeMessage, probeAction.children);
        }
        if (AML.DYNAMIC_UPDOWN && (leaserModule = this.aml.getLeaserModule(prefix, attribute)) != null) {
            leaserModule.onProbe(probeMessage);
        }
    }

    public void onChildUpdate(Prefix prefix, Attribute attribute, Object object, NodeHandle nodeHandle) {
        Hashtable hashtable;
        if (Log.ifp(6)) {
            System.out.println(this.aml.lnh + " " + prefix + ": probe: Got child update from " + nodeHandle);
        }
        if ((hashtable = this.probesToChild.get(prefix)) == null || hashtable.size() == 0) {
            if (Log.ifp(6)) {
                System.out.println(this.aml.lnh + " " + prefix + ": probe: No entries in probeToChild table");
            }
            return;
        }
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            ProbeMessage probeMessage = (ProbeMessage)iterator.next();
            if (Log.ifp(6)) {
                System.out.println("pmsg considering: " + probeMessage.level);
            }
            if (!probeMessage.attr.equals(attribute)) continue;
            Hashtable hashtable2 = (Hashtable)hashtable.get(probeMessage);
            Assert.myAssert(hashtable2 != null, "pclist == null implies that some problem with above stmt!");
            if (hashtable2 != null && nodeHandle != null && hashtable2.containsKey(nodeHandle)) {
                hashtable2.remove(nodeHandle);
            }
            if (hashtable2 != null && hashtable2.size() != 0) continue;
            if (Log.ifp(6)) {
                System.out.println(this.aml.lnh + " " + prefix + ": pmsg for level " + probeMessage.level + " satisfied");
            }
            this.respondWithLocalAggregate(prefix, probeMessage);
            if (probeMessage.continuous) continue;
            iterator.remove();
            this.aml.probeCallBackTable.remove(probeMessage);
        }
    }

    public void onParentUpdate(Prefix prefix, UpdateMessage updateMessage) {
        Hashtable hashtable;
        if (Log.ifp(6)) {
            System.out.println(this.aml.lnh + " " + prefix + ": probetable got umsg from parent: " + updateMessage);
        }
        if ((hashtable = this.probesToParent.get(prefix)) == null || hashtable.size() == 0) {
            if (Log.ifp(6)) {
                System.out.println("No entries in probeToParent table");
            }
            return;
        }
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            ProbeMessage probeMessage = (ProbeMessage)iterator.next();
            if (Log.ifp(6)) {
                System.out.println("pmsg considering: " + probeMessage.level + " " + probeMessage.attr);
            }
            if (!probeMessage.attr.equals(updateMessage.getAttr())) continue;
            AncestorMIBEntry ancestorMIBEntry = (AncestorMIBEntry)((Vector)updateMessage.getValue()).lastElement();
            if (Log.ifp(6)) {
                System.out.println("umsg has level " + ancestorMIBEntry.prefixLength);
            }
            if (ancestorMIBEntry.prefixLength < probeMessage.level && ancestorMIBEntry.parentName != null) continue;
            Vector<AncestorMIBEntry> vector = new Vector<AncestorMIBEntry>((Vector)updateMessage.getValue());
            vector.add(0, this.aml.getLocalAmibEntry(prefix, probeMessage.attr));
            Vector vector2 = this.aml.amib.getEntriesMatchingPrefixLength(vector, probeMessage.level);
            this.sendProbeResponseToChild(prefix, probeMessage, vector2);
            if (probeMessage.continuous) continue;
            iterator.remove();
        }
    }

    public void onNewChild(Prefix prefix, NodeHandle nodeHandle) {
    }

    public void onChildFail(Prefix prefix, NodeHandle nodeHandle) {
    }

    public void onNewParent(Prefix prefix, NodeHandle nodeHandle) {
        Hashtable hashtable = this.probesToParent.deleteKey(prefix);
        if (hashtable != null) {
            Iterator iterator = hashtable.keySet().iterator();
            while (iterator.hasNext()) {
                ProbeMessage probeMessage = (ProbeMessage)iterator.next();
                this.newProbe(prefix, probeMessage);
            }
        }
    }
}

