/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.AML.testing;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import rice.pastry.AML.AML;
import rice.pastry.AML.DHTAMLInterface;
import rice.pastry.AML.HashHashTable;
import rice.pastry.AML.Prefix;
import rice.pastry.AML.ProbeCallBack;
import rice.pastry.AML.messaging.InstallMessage;
import rice.pastry.AML.messaging.LocalProbeMessage;
import rice.pastry.AML.messaging.ProbeMessage;
import rice.pastry.AML.messaging.UpdateMessage;
import rice.pastry.AML.testing.TestAggrFunc;
import rice.pastry.Assert;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastrySeed;
import rice.pastry.client.PastryAppl;
import rice.pastry.direct.TimedTreeMetricNetwork;
import rice.pastry.hdht.GenericNodeNameFactory;
import rice.pastry.hdht.HdhtDirectPastryNodeFactory;
import rice.pastry.messaging.Message;
import rice.pastry.standard.RandomNodeIdFactory;

public class AMLTest {
    private HdhtDirectPastryNodeFactory factory;
    private TimedTreeMetricNetwork simulator = new TimedTreeMetricNetwork();
    private Vector hdhtNodes;
    private Vector dataObjects;
    private Random rng;
    private static int numnodes = 1;
    private static int bf = 2;
    private static int nummsgs = 1;
    private Hashtable nodeMap = null;

    public AMLTest() {
        this.factory = new HdhtDirectPastryNodeFactory(new RandomNodeIdFactory(), this.simulator);
        GenericNodeNameFactory genericNodeNameFactory = new GenericNodeNameFactory(numnodes, bf);
        this.factory.setNodeNameFactory(genericNodeNameFactory);
        this.hdhtNodes = new Vector();
        this.dataObjects = new Vector();
        this.rng = new Random(PastrySeed.getSeed());
        this.nodeMap = new Hashtable();
    }

    private NodeHandle getBootstrap() {
        NodeHandle nodeHandle = null;
        try {
            PastryNode pastryNode = (PastryNode)this.hdhtNodes.lastElement();
            nodeHandle = pastryNode.getLocalHandle();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return nodeHandle;
    }

    public void makePastryNode() {
        PastryNode pastryNode = this.factory.newNode(this.getBootstrap());
        this.hdhtNodes.addElement(pastryNode);
        AML aML = new AML(pastryNode);
        DHTAMLInterface dHTAMLInterface = new DHTAMLInterface(pastryNode, aML);
        this.dataObjects.addElement(dHTAMLInterface);
        if (Log.ifp(5)) {
            System.out.println("created " + pastryNode);
        }
    }

    private boolean simulate() {
        return this.simulator.simulate();
    }

    public void checkMapsConsistency() {
        Object object;
        Serializable serializable;
        Object object2;
        Serializable serializable2;
        Serializable serializable3;
        Enumeration enumeration;
        Object object3;
        Serializable serializable4;
        DHTAMLInterface dHTAMLInterface;
        int n;
        System.out.println("Checking inverse mappings consistency");
        for (n = 0; n < numnodes; ++n) {
            dHTAMLInterface = (DHTAMLInterface)this.dataObjects.get(n);
            serializable4 = dHTAMLInterface.getNodeHandle();
            object3 = dHTAMLInterface.getAML();
            enumeration = ((AML)object3).invParentMap.keys();
            while (enumeration.hasMoreElements()) {
                serializable3 = (NodeHandle)enumeration.nextElement();
                serializable2 = ((AML)object3).invParentMap.get(serializable3);
                object2 = ((Hashtable)serializable2).keys();
                while (object2.hasMoreElements()) {
                    serializable = (Prefix)object2.nextElement();
                    object = ((AML)object3).getParent((Prefix)serializable);
                    if (object != null && ((NodeHandle)object).equals(serializable3)) continue;
                    Assert.myAssert(false, serializable4 + ": invParentCheck failed ");
                }
            }
            enumeration = ((AML)object3).invChildMap.keys();
            while (enumeration.hasMoreElements()) {
                serializable3 = (NodeHandle)enumeration.nextElement();
                serializable2 = ((AML)object3).invChildMap.get(serializable3);
                object2 = ((Hashtable)serializable2).keys();
                while (object2.hasMoreElements()) {
                    serializable = (Prefix)object2.nextElement();
                    object = ((AML)object3).childMap.get(serializable);
                    if (object != null && ((Hashtable)object).containsKey(serializable3)) continue;
                    if (object == null) {
                        System.out.println(" cset is null");
                    }
                    System.out.println(" Node Handle: " + serializable3 + " prefix " + serializable);
                    ((AML)object3).childMap.printMap();
                    Assert.myAssert(false, serializable4 + " failed ");
                }
            }
        }
        System.out.println("Done -- Checking inverse mappings consistency");
        System.out.println("Checking parentMap consistency");
        for (n = 0; n < numnodes; ++n) {
            dHTAMLInterface = (DHTAMLInterface)this.dataObjects.get(n);
            serializable4 = dHTAMLInterface.getAML().parentMap;
            object3 = dHTAMLInterface.getNodeHandle();
            enumeration = ((Hashtable)serializable4).keys();
            while (enumeration.hasMoreElements()) {
                serializable3 = (Prefix)enumeration.nextElement();
                serializable2 = dHTAMLInterface.getAML().getParent((Prefix)serializable3);
                if (((NodeHandle)serializable2).equals(object3)) continue;
                object2 = (DHTAMLInterface)this.dataObjects.get((Integer)this.nodeMap.get(serializable2));
                serializable = ((DHTAMLInterface)object2).getAML().childMap.get(serializable3);
                if (serializable != null && ((Hashtable)serializable).containsKey(object3)) continue;
                Assert.myAssert(false);
            }
        }
        System.out.println("Done -- Checking parentMap consistency");
        System.out.println("Checking childMap consistency");
        for (n = 0; n < numnodes; ++n) {
            dHTAMLInterface = (DHTAMLInterface)this.dataObjects.get(n);
            serializable4 = dHTAMLInterface.getNodeHandle();
            object3 = dHTAMLInterface.getAML().childMap;
            enumeration = ((HashHashTable)object3).keys();
            while (enumeration.hasMoreElements()) {
                serializable3 = (Prefix)enumeration.nextElement();
                serializable2 = ((HashHashTable)object3).get(serializable3);
                object2 = ((Hashtable)serializable2).keys();
                while (object2.hasMoreElements()) {
                    serializable = (NodeHandle)object2.nextElement();
                    object = (DHTAMLInterface)this.dataObjects.get((Integer)this.nodeMap.get(serializable));
                    NodeHandle nodeHandle = ((DHTAMLInterface)object).getAML().getParent((Prefix)serializable3);
                    if (nodeHandle != null && nodeHandle.equals(serializable4)) continue;
                    Assert.myAssert(false);
                }
            }
        }
        System.out.println("Done -- Checking childMap consistency");
    }

    public static void main(String[] stringArray) {
        Object object;
        int n;
        DHTAMLInterface dHTAMLInterface;
        String string = "nfile";
        boolean bl = false;
        int n2 = 160;
        int n3 = 160;
        int n4 = 160;
        boolean bl2 = false;
        int n5 = 1;
        Log.init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-nodes") && i + 1 < stringArray.length) {
                numnodes = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-bf") && i + 1 < stringArray.length) {
                bf = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-msgs") && i + 1 < stringArray.length) {
                nummsgs = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-fileName") && i + 1 < stringArray.length) {
                string = stringArray[i + 1];
            }
            if (stringArray[i].equals("-upValue") && i + 1 < stringArray.length) {
                n2 = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-downValue") && i + 1 < stringArray.length) {
                n3 = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-probeLevel") && i + 1 < stringArray.length) {
                n4 = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-numProbes") && i + 1 < stringArray.length) {
                n5 = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-checkMap")) {
                bl = true;
            }
            if (stringArray[i].equals("-cont")) {
                bl2 = true;
            }
            if (stringArray[i].equals("-lease")) {
                AML.DYNAMIC_UPDOWN = true;
            }
            if (!stringArray[i].equals("-help")) continue;
            System.out.println("Usage: HelloWorldHdht [-msgs m] [-nodes n] [-verbose|-silent|-verbosity v|-probeLevel i|-upValue u|-downValue d]");
            System.exit(1);
        }
        AMLTest aMLTest = new AMLTest();
        for (int i = 0; i < numnodes; ++i) {
            aMLTest.makePastryNode();
            while (aMLTest.simulate()) {
            }
            dHTAMLInterface = (DHTAMLInterface)aMLTest.dataObjects.get(i);
            aMLTest.nodeMap.put(dHTAMLInterface.getNodeHandle(), new Integer(i));
        }
        DHTAMLInterface dHTAMLInterface2 = (DHTAMLInterface)aMLTest.dataObjects.get(0);
        dHTAMLInterface = (DHTAMLInterface)aMLTest.dataObjects.get(numnodes - 1);
        if (bl) {
            aMLTest.checkMapsConsistency();
        }
        NodeHandle nodeHandle = dHTAMLInterface2.getNodeHandle();
        NodeHandle nodeHandle2 = dHTAMLInterface.getNodeHandle();
        TestAggrFunc testAggrFunc = new TestAggrFunc("nfile", n2, n3);
        InstallMessage installMessage = new InstallMessage(dHTAMLInterface2.getAddress(), nodeHandle, testAggrFunc);
        nodeHandle.receiveMessage(installMessage);
        double d = aMLTest.simulator.getTime();
        int n6 = 0;
        while (aMLTest.simulate()) {
            ++n6;
        }
        System.out.println("Msg Count " + n6 + " Time taken " + (aMLTest.simulator.getTime() - d));
        UpdateMessage updateMessage = new UpdateMessage(dHTAMLInterface2.getAddress(), nodeHandle, "nfile", string, new Integer(1));
        nodeHandle.receiveMessage(updateMessage);
        d = aMLTest.simulator.getTime();
        n6 = 0;
        while (aMLTest.simulate()) {
            ++n6;
        }
        System.out.println("Msg Count " + n6 + " Time taken " + (aMLTest.simulator.getTime() - d));
        ProbeCallBack probeCallBack = new ProbeCallBack(){

            public void onAnswer(ProbeMessage probeMessage, Object object) {
                System.out.println("call back invoked.. got answer: " + object);
            }
        };
        for (n = 0; n < n5; ++n) {
            object = new LocalProbeMessage(dHTAMLInterface2.getAddress(), nodeHandle, "nfile", string, nodeHandle.getNodeName().toString(), 10, probeCallBack);
            ((LocalProbeMessage)object).level = n4;
            ((LocalProbeMessage)object).continuous = bl2;
            nodeHandle.receiveMessage((Message)object);
            d = aMLTest.simulator.getTime();
            n6 = 0;
            while (aMLTest.simulate()) {
                ++n6;
            }
            System.out.println("Msg Count " + n6 + " Time taken " + (aMLTest.simulator.getTime() - d));
        }
        for (n = 0; n < n5; ++n) {
            object = (DHTAMLInterface)aMLTest.dataObjects.get(n % numnodes);
            NodeHandle nodeHandle3 = ((PastryAppl)object).getNodeHandle();
            updateMessage = new UpdateMessage(dHTAMLInterface.getAddress(), nodeHandle3, "nfile", string, new Integer(1));
            nodeHandle3.receiveMessage(updateMessage);
            d = aMLTest.simulator.getTime();
            n6 = 0;
            while (aMLTest.simulate()) {
                ++n6;
            }
            System.out.println("Msg Count " + n6 + " Time taken " + (aMLTest.simulator.getTime() - d));
        }
        for (n = 0; n < n5; ++n) {
            object = new LocalProbeMessage(dHTAMLInterface2.getAddress(), nodeHandle, "nfile", string, nodeHandle.getNodeName().toString(), 10, probeCallBack);
            ((LocalProbeMessage)object).level = n4;
            ((LocalProbeMessage)object).continuous = bl2;
            nodeHandle.receiveMessage((Message)object);
            d = aMLTest.simulator.getTime();
            n6 = 0;
            while (aMLTest.simulate()) {
                ++n6;
            }
            System.out.println("Msg Count " + n6 + " Time taken " + (aMLTest.simulator.getTime() - d));
        }
        LocalProbeMessage localProbeMessage = new LocalProbeMessage(dHTAMLInterface2.getAddress(), nodeHandle, "nfile", string, nodeHandle.getNodeName().toString(), 10, probeCallBack);
        localProbeMessage.level = n4;
        localProbeMessage.continuous = bl2;
        localProbeMessage.up = 160;
        localProbeMessage.down = 160;
        nodeHandle.receiveMessage(localProbeMessage);
        d = aMLTest.simulator.getTime();
        n6 = 0;
        while (aMLTest.simulate()) {
            ++n6;
        }
        System.out.println("Reaggregation -- Msg Count " + n6 + " Time taken " + (aMLTest.simulator.getTime() - d));
        if (bl2) {
            updateMessage = new UpdateMessage(dHTAMLInterface.getAddress(), dHTAMLInterface.getNodeHandle(), "nfile", string, new Integer(1));
            dHTAMLInterface.getNodeHandle().receiveMessage(updateMessage);
            d = aMLTest.simulator.getTime();
            n6 = 0;
            while (aMLTest.simulate()) {
                ++n6;
            }
            System.out.println("Msg Count " + n6 + " Time taken " + (aMLTest.simulator.getTime() - d));
        }
    }
}

