/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.AML.testing;

import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import rice.pastry.AML.AML;
import rice.pastry.AML.DHTAMLInterface;
import rice.pastry.AML.messaging.InstallMessage;
import rice.pastry.AML.messaging.LocalProbeMessage;
import rice.pastry.AML.messaging.UpdateMessage;
import rice.pastry.AML.testing.FileLocationAggrFunc;
import rice.pastry.AML.testing.FileLocationProbeCallBack;
import rice.pastry.Assert;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastrySeed;
import rice.pastry.direct.TimedTreeMetricNetwork;
import rice.pastry.hdht.GenericNodeNameFactory;
import rice.pastry.hdht.HdhtDirectPastryNodeFactory;
import rice.pastry.messaging.Message;
import rice.pastry.standard.RandomNodeIdFactory;

public class FileLocation {
    private HdhtDirectPastryNodeFactory factory;
    private TimedTreeMetricNetwork simulator;
    private Vector hdhtNodes;
    private Vector dataObjects;
    private Random rng;
    private static int numnodes = 1;
    private static int bf = 2;
    private static int nummsgs = 1;
    private Hashtable nodeMap = null;
    String fname = "nfile";
    int upValue = 160;
    int downValue = 0;
    int probeLevel = 160;
    boolean continuousProbe = false;
    int numProbes = 1;
    int numFiles = 10;
    int replFactor = 1;
    Vector files;
    Hashtable filesMap;
    Vector filesToNodes;
    Vector nodesToFiles;
    String attrType = "FileLocation";
    private static final Random random = new Random(1L);
    int queryNum = 0;

    public void init() {
        this.simulator = new TimedTreeMetricNetwork();
        this.factory = new HdhtDirectPastryNodeFactory(new RandomNodeIdFactory(), this.simulator);
        GenericNodeNameFactory genericNodeNameFactory = new GenericNodeNameFactory(numnodes, bf);
        this.factory.setNodeNameFactory(genericNodeNameFactory);
        this.hdhtNodes = new Vector();
        this.dataObjects = new Vector();
        this.rng = new Random(PastrySeed.getSeed());
        this.nodeMap = new Hashtable();
        this.files = new Vector();
        this.filesMap = new Hashtable();
    }

    private NodeHandle getBootstrap() {
        NodeHandle nodeHandle = null;
        try {
            PastryNode pastryNode = (PastryNode)this.hdhtNodes.lastElement();
            nodeHandle = pastryNode.getLocalHandle();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return nodeHandle;
    }

    public void makePastryNode() {
        PastryNode pastryNode = this.factory.newNode(this.getBootstrap());
        this.hdhtNodes.addElement(pastryNode);
        AML aML = new AML(pastryNode);
        DHTAMLInterface dHTAMLInterface = new DHTAMLInterface(pastryNode, aML);
        this.dataObjects.addElement(dHTAMLInterface);
        if (Log.ifp(5)) {
            System.out.println("created " + pastryNode);
        }
    }

    private boolean simulate() {
        return this.simulator.simulate();
    }

    public void createNodes() {
        for (int i = 0; i < numnodes; ++i) {
            this.makePastryNode();
            while (this.simulate()) {
            }
            DHTAMLInterface dHTAMLInterface = (DHTAMLInterface)this.dataObjects.get(i);
            this.nodeMap.put(dHTAMLInterface.getNodeHandle(), new Integer(i));
        }
    }

    public DHTAMLInterface getIntf(int n) {
        DHTAMLInterface dHTAMLInterface = (DHTAMLInterface)this.dataObjects.get(n);
        return dHTAMLInterface;
    }

    public NodeHandle getNode(int n) {
        Assert.myAssert(n < numnodes);
        DHTAMLInterface dHTAMLInterface = (DHTAMLInterface)this.dataObjects.get(n);
        NodeHandle nodeHandle = dHTAMLInterface.getNodeHandle();
        return nodeHandle;
    }

    public void installAggrFunc() {
        FileLocationAggrFunc fileLocationAggrFunc = new FileLocationAggrFunc(this.attrType, this.upValue, this.downValue);
        NodeHandle nodeHandle = this.getNode(0);
        InstallMessage installMessage = new InstallMessage(this.getIntf(0).getAddress(), nodeHandle, fileLocationAggrFunc);
        nodeHandle.receiveMessage(installMessage);
        while (this.simulate()) {
        }
    }

    public void createFiles() {
        for (int i = 0; i < this.numFiles; ++i) {
            String string = this.getRandString(10);
            this.files.addElement(string);
            this.filesMap.put(string, new Integer(i));
            System.out.println(i + "  " + string);
        }
    }

    public void assignFilesToNodes() {
        int n;
        this.nodesToFiles = new Vector();
        this.filesToNodes = new Vector();
        for (n = 0; n < numnodes; ++n) {
            this.nodesToFiles.addElement(new Vector());
        }
        Assert.myAssert(this.replFactor <= numnodes);
        for (n = 0; n < this.numFiles; ++n) {
            int[] nArray = new int[this.replFactor];
            this.filesToNodes.addElement(nArray);
            for (int i = 0; i < this.replFactor; ++i) {
                boolean bl = false;
                int n2 = -1;
                while (!bl) {
                    n2 = random.nextInt(numnodes);
                    bl = true;
                    for (int j = 0; j < i; ++j) {
                        if (nArray[j] != n2) continue;
                        bl = false;
                    }
                }
                nArray[i] = n2;
                ((Vector)this.nodesToFiles.get(n2)).addElement(new Integer(n));
            }
        }
    }

    public void printFileAssignments() {
        for (int i = 0; i < this.numFiles; ++i) {
            System.out.print(i + "  ");
            int[] nArray = (int[])this.filesToNodes.get(i);
            for (int j = 0; j < this.replFactor; ++j) {
                System.out.print(nArray[j] + " ");
            }
            System.out.println();
        }
    }

    public void doUpdates() {
        for (int i = 0; i < this.numFiles; ++i) {
            int[] nArray = (int[])this.filesToNodes.get(i);
            String string = (String)this.files.get(i);
            for (int j = 0; j < this.replFactor; ++j) {
                NodeHandle nodeHandle = this.getNode(nArray[j]);
                UpdateMessage updateMessage = new UpdateMessage(this.getIntf(0).getAddress(), nodeHandle, this.attrType, string, nodeHandle.getNodeName());
                nodeHandle.receiveMessage(updateMessage);
                while (this.simulate()) {
                }
            }
        }
    }

    public void queryFiles() {
        Object object;
        NodeHandle nodeHandle;
        int n;
        FileLocationProbeCallBack fileLocationProbeCallBack = new FileLocationProbeCallBack();
        for (n = 0; n < this.numFiles; ++n) {
            nodeHandle = this.getNode(random.nextInt(numnodes));
            object = new LocalProbeMessage(this.getIntf(0).getAddress(), nodeHandle, this.attrType, (String)this.files.get(n), nodeHandle.getNodeName().toString(), this.queryNum++, fileLocationProbeCallBack);
            ((LocalProbeMessage)object).level = 160;
            if (n == 0) {
                ((LocalProbeMessage)object).continuous = true;
            }
            nodeHandle.receiveMessage((Message)object);
            while (this.simulate()) {
            }
        }
        for (n = 0; n < this.numFiles; ++n) {
            nodeHandle = this.getNode(random.nextInt(numnodes));
            object = this.getRandString(10);
            System.out.println("searching for string " + (String)object);
            LocalProbeMessage localProbeMessage = new LocalProbeMessage(this.getIntf(0).getAddress(), nodeHandle, this.attrType, (String)object, nodeHandle.getNodeName().toString(), this.queryNum++, fileLocationProbeCallBack);
            localProbeMessage.level = 160;
            nodeHandle.receiveMessage(localProbeMessage);
            while (this.simulate()) {
            }
        }
    }

    public void deleteAndQuery() {
        Message message;
        NodeHandle nodeHandle;
        int[] nArray = (int[])this.filesToNodes.get(0);
        String string = (String)this.files.get(0);
        for (int i = 0; i < this.replFactor; ++i) {
            nodeHandle = this.getNode(nArray[i]);
            message = new UpdateMessage(this.getIntf(0).getAddress(), nodeHandle, this.attrType, string, null);
            nodeHandle.receiveMessage(message);
            while (this.simulate()) {
            }
        }
        FileLocationProbeCallBack fileLocationProbeCallBack = new FileLocationProbeCallBack();
        nodeHandle = this.getNode(random.nextInt(numnodes));
        message = new LocalProbeMessage(this.getIntf(0).getAddress(), nodeHandle, this.attrType, (String)this.files.get(0), nodeHandle.getNodeName().toString(), this.queryNum++, fileLocationProbeCallBack);
        ((LocalProbeMessage)message).level = 160;
        nodeHandle.receiveMessage(message);
        while (this.simulate()) {
        }
    }

    public void doit() {
        this.init();
        this.createNodes();
        this.installAggrFunc();
        this.createFiles();
        this.assignFilesToNodes();
        this.printFileAssignments();
        this.doUpdates();
        this.queryFiles();
        this.deleteAndQuery();
    }

    public String getRandString(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(33 + random.nextInt(94));
        }
        return new String(cArray);
    }

    public void parseArgs(String[] stringArray) {
        Log.init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-nodes") && i + 1 < stringArray.length) {
                numnodes = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-bf") && i + 1 < stringArray.length) {
                bf = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-upValue") && i + 1 < stringArray.length) {
                this.upValue = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-downValue") && i + 1 < stringArray.length) {
                this.downValue = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-probeLevel") && i + 1 < stringArray.length) {
                this.probeLevel = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-numProbes") && i + 1 < stringArray.length) {
                this.numProbes = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-numFiles") && i + 1 < stringArray.length) {
                this.numFiles = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-repl") && i + 1 < stringArray.length) {
                this.replFactor = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-cont")) {
                this.continuousProbe = true;
            }
            if (stringArray[i].equals("-lease")) {
                AML.DYNAMIC_UPDOWN = true;
            }
            if (!stringArray[i].equals("-help")) continue;
            System.out.println("Usage: FileLocation [-nodes n] [-verbose|-silent|-verbosity v] [-probeLevel i] [-upValue u] [-downValue d] [-lease] [-cont] [-numProbes n][-numFiles f] [-repl r]");
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        FileLocation fileLocation = new FileLocation();
        fileLocation.parseArgs(stringArray);
        fileLocation.doit();
    }
}

