/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.AML.testing;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import rice.pastry.AML.AML;
import rice.pastry.AML.AggrFunc;
import rice.pastry.AML.DHTAMLInterface;
import rice.pastry.AML.ProbeCallBack;
import rice.pastry.AML.messaging.InstallMessage;
import rice.pastry.AML.messaging.LocalProbeMessage;
import rice.pastry.AML.messaging.ProbeMessage;
import rice.pastry.AML.messaging.UpdateMessage;
import rice.pastry.AML.testing.TestBedAggrFunc;
import rice.pastry.Assert;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastrySeed;
import rice.pastry.dist.DistPastryNodeFactory;
import rice.pastry.hdht.HdhtWirePastryNodeFactory;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RoutingTable;
import rice.pastry.standard.IPNodeIdFactory;

public class RealTestBed {
    private HdhtWirePastryNodeFactory factory = new HdhtWirePastryNodeFactory(new IPNodeIdFactory(port), port, nname);
    private Vector pastryNodes = new Vector();
    private Vector helloClients = new Vector();
    private Random rng = new Random(PastrySeed.getSeed());
    private static int port = 5009;
    private static String bshost = null;
    private static int bsport = 5009;
    private static int numnodes = 5;
    private static int nummsgs = 2;
    public static int protocol = DistPastryNodeFactory.PROTOCOL_WIRE;
    private static String nname = null;
    private static int currentSerialNum = 0;
    private static int commandPort = 6789;
    private ServerSocket commandSocket = null;
    private Hashtable waitingSockets = null;
    private String prResponse = null;
    private static int up = 160;
    private static int down = 0;

    public RealTestBed() {
        currentSerialNum = 0;
        this.waitingSockets = new Hashtable();
        this.commandSocket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(Object object) {
        this.prResponse = new String("Got probe response answer: " + object);
        RealTestBed realTestBed = this;
        synchronized (realTestBed) {
            this.notifyAll();
        }
    }

    protected NodeHandle getBootstrap(boolean bl) {
        InetSocketAddress inetSocketAddress = null;
        if (bl && bshost != null) {
            inetSocketAddress = new InetSocketAddress(bshost, bsport);
        } else {
            try {
                inetSocketAddress = new InetSocketAddress(InetAddress.getLocalHost().getHostName(), bsport);
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println(unknownHostException);
            }
        }
        NodeHandle nodeHandle = this.factory.getNodeHandle(inetSocketAddress);
        return nodeHandle;
    }

    private static void doIinitstuff(String[] stringArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-help")) continue;
            System.out.println("Usage: DistHelloWorld [-msgs m] [-nodes n] [-port p] [-bootstrap bshost[:bsport]]");
            System.out.println("                     [-protocol (rmi|wire)] [-verbose|-silent|-verbosity v] [-help]");
            System.out.println("");
            System.out.println("  Ports p and bsport refer to RMI registry  or Socket port numbers (default = 5009).");
            System.out.println("  Without -bootstrap bshost[:bsport], only localhost:p is used for bootstrap.");
            System.out.println("  Default verbosity is 5, -verbose is 10, and -silent is -1 (error msgs only).");
            System.exit(1);
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].equals("-msgs") && n2 + 1 < stringArray.length) {
                nummsgs = Integer.parseInt(stringArray[n2 + 1]);
            }
            if (stringArray[n2].equals("-nname") && n2 + 1 < stringArray.length) {
                nname = stringArray[n2 + 1];
            }
            if (stringArray[n2].equals("-up") && n2 + 1 < stringArray.length) {
                up = Integer.parseInt(stringArray[n2 + 1]);
            }
            if (stringArray[n2].equals("-down") && n2 + 1 < stringArray.length) {
                down = Integer.parseInt(stringArray[n2 + 1]);
            }
            if (stringArray[n2].equals("-digitLength") && n2 + 1 < stringArray.length) {
                RoutingTable.idBaseBitLength = Integer.parseInt(stringArray[n2 + 1]);
            }
            if (!stringArray[n2].equals("-lease")) continue;
            AML.DYNAMIC_UPDOWN = true;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-port") || n2 + 1 >= stringArray.length) continue;
            n = Integer.parseInt(stringArray[n2 + 1]);
            if (n <= 0) break;
            port = n;
            bsport = n;
            break;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-bootstrap") || n2 + 1 >= stringArray.length) continue;
            String string = stringArray[n2 + 1];
            int n3 = string.indexOf(58);
            if (n3 == -1) {
                bshost = string;
                bsport = port;
                break;
            }
            bshost = string.substring(0, n3);
            bsport = Integer.parseInt(string.substring(n3 + 1));
            if (bsport > 0) break;
            bsport = port;
            break;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-nodes") || n2 + 1 >= stringArray.length) continue;
            n = Integer.parseInt(stringArray[n2 + 1]);
            if (n <= 0) break;
            numnodes = n;
            break;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-protocol") || n2 + 1 >= stringArray.length) continue;
            String string = stringArray[n2 + 1];
            if (string.equalsIgnoreCase("wire")) {
                protocol = DistPastryNodeFactory.PROTOCOL_WIRE;
                break;
            }
            if (string.equalsIgnoreCase("rmi")) {
                protocol = DistPastryNodeFactory.PROTOCOL_RMI;
                break;
            }
            System.out.println("ERROR: Unsupported protocol: " + string);
            break;
        }
        Assert.myAssert(nname != null, "Supply a node name: -nname <name>");
    }

    public PastryNode makePastryNode(boolean bl) {
        NodeHandle nodeHandle = this.getBootstrap(bl);
        PastryNode pastryNode = this.factory.newNode(nodeHandle);
        this.pastryNodes.addElement(pastryNode);
        AML aML = new AML(pastryNode);
        DHTAMLInterface dHTAMLInterface = new DHTAMLInterface(pastryNode, aML);
        this.helloClients.addElement(dHTAMLInterface);
        if (Log.ifp(5)) {
            System.out.println("created " + pastryNode);
        }
        return pastryNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        Log.init(stringArray);
        RealTestBed.doIinitstuff(stringArray);
        RealTestBed realTestBed = new RealTestBed();
        PastryNode pastryNode = realTestBed.makePastryNode(true);
        Object object = pastryNode;
        synchronized (object) {
            while (!pastryNode.isReady()) {
                try {
                    pastryNode.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println(interruptedException);
                }
            }
        }
        if (Log.ifp(5)) {
            System.out.println(numnodes + " nodes constructed");
        }
        System.out.println("checking local node handle: " + pastryNode.getLocalHandle());
        try {
            realTestBed.commandSocket = new ServerSocket(commandPort);
        }
        catch (Exception exception) {
            System.out.println("commandSocket creation failed " + exception);
        }
        object = null;
        Socket socket = null;
        block23: while (true) {
            try {
                System.out.println("Starting command socket listening");
                socket = realTestBed.commandSocket.accept();
                System.out.println("got connection from " + socket.getRemoteSocketAddress());
                bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            }
            catch (Exception exception) {
                System.out.println(exception);
                bufferedReader = null;
            }
            while (true) {
                Object object2;
                Object object3;
                Object object4;
                NodeHandle nodeHandle;
                DHTAMLInterface dHTAMLInterface;
                if (bufferedReader == null || socket.isClosed()) continue block23;
                try {
                    object = bufferedReader.readLine();
                }
                catch (Exception exception) {
                    System.out.println("unable to read from command line:" + exception);
                    bufferedReader = null;
                }
                if (object == null) continue;
                System.out.println("Read command " + (String)object);
                StringTokenizer stringTokenizer = new StringTokenizer((String)object);
                if (!stringTokenizer.hasMoreTokens()) continue;
                String string = stringTokenizer.nextToken();
                if (string.startsWith("install")) {
                    dHTAMLInterface = (DHTAMLInterface)realTestBed.helloClients.get(0);
                    nodeHandle = dHTAMLInterface.getNodeHandle();
                    object4 = new TestBedAggrFunc("nfile", up, down);
                    object3 = new InstallMessage(dHTAMLInterface.getAddress(), nodeHandle, (AggrFunc)object4);
                    nodeHandle.receiveMessage((Message)object3);
                    try {
                        object2 = new PrintWriter(socket.getOutputStream(), true);
                        ((PrintWriter)object2).println("Done");
                        ((PrintWriter)object2).flush();
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                    continue;
                }
                if (string.startsWith("update")) {
                    dHTAMLInterface = (DHTAMLInterface)realTestBed.helloClients.get(0);
                    nodeHandle = dHTAMLInterface.getNodeHandle();
                    object4 = new UpdateMessage(dHTAMLInterface.getAddress(), nodeHandle, "nfile", "nfile", new Integer(10));
                    nodeHandle.receiveMessage((Message)object4);
                    try {
                        object3 = new PrintWriter(socket.getOutputStream(), true);
                        ((PrintWriter)object3).println("Done");
                        ((PrintWriter)object3).flush();
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                    continue;
                }
                if (string.startsWith("probe")) {
                    dHTAMLInterface = (DHTAMLInterface)realTestBed.helloClients.get(0);
                    nodeHandle = dHTAMLInterface.getNodeHandle();
                    class RTBProbeCallBack
                    implements ProbeCallBack {
                        RealTestBed driv;

                        public RTBProbeCallBack(RealTestBed realTestBed) {
                            this.driv = realTestBed;
                        }

                        public void onAnswer(ProbeMessage probeMessage, Object object) {
                            this.driv.receiveMessage(object);
                        }
                    }
                    object4 = new RTBProbeCallBack(realTestBed);
                    object3 = new LocalProbeMessage(dHTAMLInterface.getAddress(), nodeHandle, "nfile", "nfile", nodeHandle.getNodeName().toString(), ++currentSerialNum, (ProbeCallBack)object4);
                    ((LocalProbeMessage)object3).level = 160;
                    realTestBed.prResponse = null;
                    object2 = realTestBed;
                    synchronized (object2) {
                        long l = System.currentTimeMillis();
                        nodeHandle.receiveMessage((Message)object3);
                        try {
                            while (realTestBed.prResponse == null) {
                                realTestBed.wait();
                            }
                            long l2 = System.currentTimeMillis();
                            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
                            printWriter.println(realTestBed.prResponse);
                            printWriter.println("Time took: " + (l2 - l));
                            printWriter.flush();
                        }
                        catch (Exception exception) {
                            System.out.println(exception);
                        }
                    }
                }
                if (!string.startsWith("quit")) continue;
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
                bufferedReader = null;
            }
            break;
        }
    }
}

