/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.util.Random;
import rice.p2p.commonapi.Id;

public class Id
implements rice.p2p.commonapi.Id {
    public static final int[] Null = new int[]{0, 0, 0, 0, 0};
    public static final int[] One = new int[]{1, 0, 0, 0, 0};
    public static final int[] NegOne = new int[]{-1, -1, -1, -1, -1};
    public static final int[] Half = new int[]{128, 0, 0, 0, 0};
    public static final int IdBitLength = 160;
    private static final int nlen = 5;
    private int[] Id = new int[5];

    public Id(byte[] byArray) {
        for (int i = 0; i < 20 && i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            int n2 = i / 4;
            this.Id[n2] = this.Id[n2] | n << i % 4 * 8;
        }
    }

    public Id(int[] nArray) {
        for (int i = 0; i < 5 && i < nArray.length; ++i) {
            this.Id[i] = nArray[i];
        }
    }

    public Id() {
        for (int i = 0; i < 5; ++i) {
            this.Id[i] = 0;
        }
    }

    public static int numDigits(int n) {
        return 160 / n;
    }

    public static Id makeRandomId(Random random) {
        byte[] byArray = new byte[20];
        random.nextBytes(byArray);
        return new Id(byArray);
    }

    public Id getCW() {
        Distance distance = new Distance(One);
        return this.add(distance);
    }

    public Id getCCW() {
        Distance distance = new Distance(NegOne);
        return this.add(distance);
    }

    public boolean isBetween(Id id, Id id2) {
        if (id.equals(id2)) {
            return false;
        }
        if (id.clockwise(id2)) {
            return this.clockwise(id2) && !this.clockwise(id);
        }
        return !this.clockwise(id) || this.clockwise(id2);
    }

    public int getDigit(int n, int n2) {
        int n3 = n2 * n + 160 % n2;
        int n4 = n3 / 32;
        int n5 = n3 % 32;
        long l = this.Id[n4];
        if (n5 + n2 > 32) {
            l = l & 0xFFFFFFFFL | (long)this.Id[n4 + 1] << 32;
        }
        return (int)(l >> n5) & (1 << n2) - 1;
    }

    public Id getDomainPrefix(int n, int n2, int n3, int n4) {
        Id id = new Id(this.Id);
        id.setDigit(n, n2, n4);
        for (int i = 0; i < n; ++i) {
            id.setDigit(i, n3, n4);
        }
        return id;
    }

    public Id getAlternateId(int n, int n2, int n3) {
        if (n > 1 << n2 || n3 < 0 || n3 >= n) {
            return null;
        }
        Id id = new Id(this.Id);
        int n4 = id.getDigit(rice.pastry.Id.numDigits(n2) - 1, n2) + (1 << n2) / n * n3;
        id.setDigit(rice.pastry.Id.numDigits(n2) - 1, n4, n2);
        return id;
    }

    public boolean isBetween(rice.p2p.commonapi.Id id, rice.p2p.commonapi.Id id2) {
        return this.isBetween((Id)id, (Id)id2);
    }

    public void setBit(int n, int n2) {
        int n3 = n / 32;
        int n4 = n % 32;
        int n5 = this.Id[n3];
        int n6 = 1 << n4;
        this.Id[n3] = n2 == 1 ? n5 | n6 : n5 & ~n6;
    }

    public void setDigit(int n, int n2, int n3) {
        int n4 = n3 * n + 160 % n3;
        int n5 = n4 / 32;
        int n6 = n4 % 32;
        int n7 = (1 << n3) - 1;
        if (n6 + n3 > 32) {
            long l = (long)(n2 & n7) << n6;
            long l2 = (long)n7 << n6 ^ 0xFFFFFFFFFFFFFFFFL;
            long l3 = this.Id[n5];
            l3 = l3 & 0xFFFFFFFFL | (long)this.Id[n5 + 1] << 32;
            l3 = l3 & l2 | l;
            this.Id[n5] = (int)l3;
            this.Id[n5 + 1] = (int)(l3 >> 32);
        } else {
            int n8 = (n2 & n7) << n6;
            int n9 = ~(n7 << n6);
            this.Id[n5] = this.Id[n5] & n9 | n8;
        }
    }

    public void blit(byte[] byArray) {
        for (int i = 0; i < 20; ++i) {
            int n = this.Id[i / 4] >> i % 4 * 8;
            byArray[i] = (byte)(n & 0xFF);
        }
    }

    public byte[] copy() {
        byte[] byArray = new byte[20];
        this.blit(byArray);
        return byArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Id id = (Id)object;
        for (int i = 0; i < 5; ++i) {
            if (this.Id[i] == id.Id[i]) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object object) {
        Id id = (Id)object;
        for (int i = 4; i >= 0; --i) {
            if (this.Id[i] == id.Id[i]) continue;
            long l = (long)this.Id[i] & 0xFFFFFFFFL;
            long l2 = (long)id.Id[i] & 0xFFFFFFFFL;
            if (l < l2) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public byte[] toByteArray() {
        return this.copy();
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < 5; ++i) {
            n ^= this.Id[i];
        }
        return n;
    }

    public Id add(Distance distance) {
        Id id = new Id();
        int n = 0;
        for (int i = 0; i < 5; ++i) {
            long l = (long)this.Id[i] & 0xFFFFFFFFL;
            long l2 = (long)distance.difference[i] & 0xFFFFFFFFL;
            long l3 = l + l2 + (long)n;
            n = l3 >= 0x100000000L ? 1 : 0;
            id.Id[i] = (int)l3;
        }
        return id;
    }

    public Distance distance(Id id) {
        int[] nArray = this.absDistance(id);
        if ((nArray[4] & Integer.MIN_VALUE) != 0) {
            this.invert(nArray);
        }
        Distance distance = new Distance(nArray);
        return distance;
    }

    public Distance longDistance(Id id) {
        int[] nArray = this.absDistance(id);
        if ((nArray[4] & Integer.MIN_VALUE) == 0) {
            this.invert(nArray);
        }
        Distance distance = new Distance(nArray);
        return distance;
    }

    public void xor(Id id) {
        for (int i = 0; i < 5; ++i) {
            int n = i;
            this.Id[n] = this.Id[n] ^ id.Id[i];
        }
    }

    public boolean equals(Id id) {
        if (id == null) {
            return false;
        }
        for (int i = 0; i < 5; ++i) {
            if (this.Id[i] == id.Id[i]) continue;
            return false;
        }
        return true;
    }

    public boolean clockwise(Id id) {
        int n;
        boolean bl = (this.Id[4] & Integer.MIN_VALUE) != (id.Id[4] & Integer.MIN_VALUE);
        int n2 = this.Id[4] & Integer.MAX_VALUE;
        int n3 = id.Id[4] & Integer.MAX_VALUE;
        if (n2 != n3) {
            return n3 > n2 ^ bl;
        }
        for (n = 3; n >= 0 && this.Id[n] == id.Id[n]; --n) {
        }
        if (n < 0) {
            return bl;
        }
        long l = (long)id.Id[n] & 0xFFFFFFFFL;
        long l2 = (long)this.Id[n] & 0xFFFFFFFFL;
        return l > l2 ^ bl;
    }

    public boolean checkBit(int n) {
        int n2 = n / 32;
        int n3 = this.Id[n2];
        int n4 = n % 32;
        int n5 = 1 << n4;
        return (n3 & n5) != 0;
    }

    public int indexOfMSDB(Id id) {
        for (int i = 4; i >= 0; --i) {
            int n = this.Id[i] ^ id.Id[i];
            if (n == 0) continue;
            int n2 = 0;
            int n3 = n & 0xFFFF0000;
            if (n3 != 0) {
                n = n3;
                n2 += 16;
            }
            if ((n3 = n & 0xFF00FF00) != 0) {
                n = n3;
                n2 += 8;
            }
            if ((n3 = n & 0xF0F0F0F0) != 0) {
                n = n3;
                n2 += 4;
            }
            if ((n3 = n & 0xCCCCCCCC) != 0) {
                n = n3;
                n2 += 2;
            }
            if ((n3 = n & 0xAAAAAAAA) != 0) {
                n = n3;
                ++n2;
            }
            return 32 * i + n2;
        }
        return -1;
    }

    public int indexOfMSDD(Id id, int n) {
        int n2 = this.indexOfMSDB(id);
        if ((n2 -= 160 % n) < 0) {
            return n2;
        }
        return n2 / n;
    }

    public String toString() {
        return "<0x" + this.toStringFull().substring(0, 6) + "..>";
    }

    public String toStringFull() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        int n = 40;
        for (int i = n - 1; i >= 0; --i) {
            int n2 = this.getDigit(i, 4);
            stringBuffer.append(stringArray[n2]);
        }
        return stringBuffer.toString();
    }

    public boolean clockwise(rice.p2p.commonapi.Id id) {
        return this.clockwise((Id)id);
    }

    public rice.p2p.commonapi.Id addToId(Id.Distance distance) {
        return this.add((Distance)distance);
    }

    public Id.Distance distanceFromId(rice.p2p.commonapi.Id id) {
        return this.distance((Id)id);
    }

    public Id.Distance longDistanceFromId(rice.p2p.commonapi.Id id) {
        return this.longDistance((Id)id);
    }

    private int[] absDistance(Id id) {
        int[] nArray = new int[5];
        int n = 0;
        if (this.compareTo(id) > 0) {
            for (int i = 0; i < 5; ++i) {
                long l = (long)this.Id[i] & 0xFFFFFFFFL;
                long l2 = (long)id.Id[i] & 0xFFFFFFFFL;
                long l3 = l - l2 - (long)n;
                n = l3 < 0L ? 1 : 0;
                nArray[i] = (int)l3;
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                long l = (long)id.Id[i] & 0xFFFFFFFFL;
                long l4 = (long)this.Id[i] & 0xFFFFFFFFL;
                long l5 = l - l4 - (long)n;
                n = l5 < 0L ? 1 : 0;
                nArray[i] = (int)l5;
            }
        }
        return nArray;
    }

    private void invert(int[] nArray) {
        int n = 0;
        for (int i = 0; i < 5; ++i) {
            long l = (long)nArray[i] & 0xFFFFFFFFL;
            if ((l = 0L - l - (long)n) < 0L) {
                n = 1;
            }
            nArray[i] = (int)l;
        }
    }

    public static class Distance
    implements Id.Distance {
        private int[] difference;

        public Distance() {
            this.difference = new int[5];
        }

        public Distance(byte[] byArray) {
            this.difference = new int[5];
            for (int i = 0; i < 20 && i < byArray.length; ++i) {
                int n = byArray[i] & 0xFF;
                int n2 = i / 4;
                this.difference[n2] = this.difference[n2] | n << i % 4 * 8;
            }
        }

        public Distance(int[] nArray) {
            this.difference = nArray;
        }

        public void blit(byte[] byArray) {
            for (int i = 0; i < 20; ++i) {
                int n = this.difference[i / 4] >> i % 4 * 8;
                byArray[i] = (byte)(n & 0xFF);
            }
        }

        public byte[] copy() {
            byte[] byArray = new byte[20];
            this.blit(byArray);
            return byArray;
        }

        public int compareTo(Object object) {
            Distance distance = (Distance)object;
            for (int i = 4; i >= 0; --i) {
                if (this.difference[i] == distance.difference[i]) continue;
                long l = (long)this.difference[i] & 0xFFFFFFFFL;
                long l2 = (long)distance.difference[i] & 0xFFFFFFFFL;
                if (l < l2) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public Distance shift(int n, int n2) {
            return this.shift(n, n2, false);
        }

        public Distance shift(int n, int n2, boolean bl) {
            int n3 = 0;
            int n4 = 0;
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    int n5 = n2 == 0 ? 0 : Integer.MIN_VALUE;
                    for (int j = 4; j >= 0; --j) {
                        n3 = this.difference[j] & 1;
                        this.difference[j] = this.difference[j] >>> 1 | n5;
                        n5 = n3 == 0 ? 0 : Integer.MIN_VALUE;
                    }
                    if (i != 0) continue;
                    n4 = n3;
                }
                if (bl && n4 > 0) {
                    this.inc();
                }
            } else {
                for (int i = 0; i < -n; ++i) {
                    int n6 = n2 == 0 ? 0 : 1;
                    for (int j = 0; j < 5; ++j) {
                        n3 = this.difference[j] & Integer.MIN_VALUE;
                        this.difference[j] = this.difference[j] << 1 | n6;
                        n6 = n3 == 0 ? 0 : 1;
                    }
                }
            }
            return this;
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < 5; ++i) {
                n ^= this.difference[i];
            }
            return n;
        }

        public String toString() {
            String string = "0x";
            String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
            for (int i = 19; i >= 0; --i) {
                int n = this.difference[i / 4] >> i % 4 * 8;
                string = string + stringArray[n >> 4 & 0xF] + stringArray[n & 0xF];
            }
            return "< Id.distance " + string + " >";
        }

        public Id.Distance shiftDistance(int n, int n2) {
            return this.shift(n, n2);
        }

        private void inc() {
            int n = 1;
            for (int i = 0; i < 5; ++i) {
                long l = (long)this.difference[i] & 0xFFFFFFFFL;
                long l2 = l + (long)n;
                n = l2 >= 0x100000000L ? 1 : 0;
                this.difference[i] = (int)l2;
            }
        }
    }
}

