/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.io.Serializable;
import rice.pastry.Id;

public class IdRange
implements rice.p2p.commonapi.IdRange,
Serializable {
    private boolean empty;
    private Id ccw;
    private Id cw;

    public IdRange(Id id, Id id2) {
        this.empty = false;
        this.ccw = id;
        this.cw = id2;
    }

    public IdRange() {
        this.empty = true;
        this.cw = this.ccw = new Id();
    }

    public IdRange(boolean bl) {
        this.empty = bl;
        this.cw = this.ccw = new Id();
    }

    public IdRange(IdRange idRange) {
        this.empty = idRange.empty;
        this.ccw = idRange.ccw;
        this.cw = idRange.cw;
    }

    public boolean equals(Object object) {
        IdRange idRange = (IdRange)object;
        if (this.empty && idRange.empty) {
            return true;
        }
        if (this.isFull() && idRange.isFull()) {
            return true;
        }
        return this.empty == idRange.empty && this.ccw.equals(idRange.ccw) && this.cw.equals(idRange.cw);
    }

    private Id.Distance size() {
        if (this.ccw.clockwise(this.cw)) {
            return this.ccw.distance(this.cw);
        }
        return this.ccw.longDistance(this.cw);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isFull() {
        return this.ccw.equals(this.cw) && !this.empty;
    }

    public boolean isAdjacent(IdRange idRange) {
        return (this.ccw.equals(idRange.cw) || idRange.ccw.equals(this.cw)) && !this.empty && !idRange.empty && !this.isFull() && !idRange.isFull();
    }

    public boolean contains(Id id) {
        if (this.ccw.equals(this.cw) && !this.empty) {
            return true;
        }
        return id.isBetween(this.ccw, this.cw);
    }

    public Id getCCW() {
        return this.ccw;
    }

    public Id getCW() {
        return this.cw;
    }

    private void setCCW(Id id) {
        this.ccw = id;
        this.empty = false;
    }

    private void setCW(Id id) {
        this.cw = id;
        this.empty = false;
    }

    public IdRange merge(IdRange idRange) {
        if (idRange.empty || this.ccw.equals(this.cw) && !this.empty) {
            return this;
        }
        if (this.empty || idRange.ccw.equals(idRange.cw) && !idRange.empty) {
            return idRange;
        }
        boolean bl = this.ccw.isBetween(idRange.ccw, idRange.cw) || this.ccw.equals(idRange.cw);
        boolean bl2 = this.cw.isBetween(idRange.ccw, idRange.cw);
        boolean bl3 = idRange.ccw.isBetween(this.ccw, this.cw) || idRange.ccw.equals(this.cw);
        boolean bl4 = idRange.cw.isBetween(this.ccw, this.cw);
        if (bl && bl2 && bl3 && bl4) {
            return new IdRange(this.ccw, this.ccw);
        }
        if (bl) {
            if (bl2) {
                return idRange;
            }
            return new IdRange(idRange.ccw, this.cw);
        }
        if (bl2) {
            return new IdRange(this.ccw, idRange.cw);
        }
        if (bl3) {
            return this;
        }
        return this;
    }

    public IdRange complement() {
        if (this.ccw.equals(this.cw) && !this.empty) {
            return new IdRange();
        }
        return new IdRange(this.cw, this.ccw);
    }

    public IdRange intersect(IdRange idRange) {
        boolean bl;
        if (this.empty || idRange.empty) {
            return new IdRange();
        }
        if (this.ccw.equals(this.cw)) {
            return idRange;
        }
        if (idRange.ccw.equals(idRange.cw)) {
            return this;
        }
        boolean bl2 = this.ccw.isBetween(idRange.ccw, idRange.cw);
        boolean bl3 = this.cw.isBetween(idRange.ccw, idRange.cw) && !this.cw.equals(idRange.ccw);
        boolean bl4 = idRange.ccw.isBetween(this.ccw, this.cw);
        boolean bl5 = bl = idRange.cw.isBetween(this.ccw, this.cw) && !idRange.cw.equals(this.ccw);
        if (bl2 && bl3 && bl4 && bl) {
            return new IdRange(this.ccw, idRange.cw);
        }
        if (bl2) {
            if (bl3) {
                return this;
            }
            return new IdRange(this.ccw, idRange.cw);
        }
        if (bl3) {
            return new IdRange(idRange.ccw, this.cw);
        }
        if (bl4) {
            return idRange;
        }
        return new IdRange();
    }

    public IdRange diff(IdRange idRange) {
        IdRange idRange2 = this.intersect(idRange.complement());
        if (idRange2.isEmpty()) {
            idRange2 = this.complement().intersect(idRange);
        }
        return idRange2;
    }

    public IdRange subtract(IdRange idRange, boolean bl) {
        if (!bl) {
            return this.intersect(idRange.complement());
        }
        return idRange.complement().intersect(this);
    }

    public IdRange ccwHalf() {
        if (this.empty) {
            return new IdRange();
        }
        if (this.isFull()) {
            return new IdRange(new Id(Id.Null), new Id(Id.Half));
        }
        Id id = this.ccw.add(this.size().shift(1, 0, true));
        return new IdRange(this.ccw, id);
    }

    public IdRange cwHalf() {
        if (this.empty) {
            return new IdRange();
        }
        if (this.isFull()) {
            return new IdRange(new Id(Id.Half), new Id(Id.Null));
        }
        Id id = this.ccw.add(this.size().shift(1, 0, true));
        return new IdRange(id, this.cw);
    }

    public String toString() {
        if (this.empty) {
            return "IdRange: empty";
        }
        return "IdRange: from:" + this.ccw + " to:" + this.cw;
    }

    public boolean containsId(rice.p2p.commonapi.Id id) {
        return this.contains((Id)id);
    }

    public rice.p2p.commonapi.Id getCCWId() {
        return this.getCCW();
    }

    public rice.p2p.commonapi.Id getCWId() {
        return this.getCW();
    }

    public rice.p2p.commonapi.IdRange getComplementRange() {
        return this.complement();
    }

    public rice.p2p.commonapi.IdRange mergeRange(rice.p2p.commonapi.IdRange idRange) {
        return this.merge((IdRange)idRange);
    }

    public rice.p2p.commonapi.IdRange diffRange(rice.p2p.commonapi.IdRange idRange) {
        return this.diff((IdRange)idRange);
    }

    public rice.p2p.commonapi.IdRange intersectRange(rice.p2p.commonapi.IdRange idRange) {
        return this.intersect((IdRange)idRange);
    }
}

