/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.TreeSet;
import rice.pastry.Id;
import rice.pastry.IdRange;

public class IdSet
implements rice.p2p.commonapi.IdSet {
    private TreeSet idSet;
    private Id cachedHash;
    private boolean validHash;

    public IdSet() {
        this.idSet = new TreeSet();
        this.validHash = false;
    }

    protected IdSet(TreeSet treeSet) {
        this.idSet = new TreeSet(treeSet);
        this.validHash = false;
    }

    public IdSet(IdSet idSet) {
        this.idSet = new TreeSet(idSet.idSet);
        this.cachedHash = idSet.cachedHash;
        this.validHash = idSet.validHash;
    }

    public int numElements() {
        return this.idSet.size();
    }

    public void addMember(Id id) {
        this.idSet.add(id);
        this.validHash = false;
    }

    public void removeMember(Id id) {
        this.idSet.remove(id);
        this.validHash = false;
    }

    public boolean isMember(Id id) {
        return this.idSet.contains(id);
    }

    public Id minMember() {
        return (Id)this.idSet.first();
    }

    public Id maxMember() {
        return (Id)this.idSet.last();
    }

    public IdSet subSet(Id id, Id id2) {
        IdSet idSet;
        if (id.compareTo(id2) <= 0) {
            idSet = new IdSet((TreeSet)this.idSet.subSet(id, id2));
        } else {
            idSet = new IdSet((TreeSet)this.idSet.tailSet(id));
            idSet.idSet.addAll(this.idSet.headSet(id2));
        }
        return idSet;
    }

    public IdSet subSet(IdRange idRange) {
        if (idRange.isEmpty()) {
            return new IdSet();
        }
        if (idRange.getCCW().equals(idRange.getCW())) {
            return this;
        }
        return this.subSet(idRange.getCCW(), idRange.getCW());
    }

    public Iterator getIterator() {
        return this.idSet.iterator();
    }

    public Id getHash() {
        if (this.validHash) {
            return this.cachedHash;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("No SHA support!");
            return null;
        }
        Iterator iterator = this.idSet.iterator();
        byte[] byArray = new byte[20];
        while (iterator.hasNext()) {
            Id id = (Id)iterator.next();
            id.blit(byArray);
            messageDigest.update(byArray);
        }
        byte[] byArray2 = messageDigest.digest();
        this.cachedHash = new Id(byArray2);
        this.validHash = true;
        return this.cachedHash;
    }

    public String toString() {
        Iterator iterator = this.getIterator();
        String string = "[ IdSet: ";
        while (iterator.hasNext()) {
            Id id = (Id)iterator.next();
            string = string + id + ",";
        }
        string = string + " ]";
        return string;
    }

    public void addId(rice.p2p.commonapi.Id id) {
        this.addMember((Id)id);
    }

    public void removeId(rice.p2p.commonapi.Id id) {
        this.removeMember((Id)id);
    }

    public boolean isMemberId(rice.p2p.commonapi.Id id) {
        return this.isMember((Id)id);
    }

    public rice.p2p.commonapi.IdSet subSet(rice.p2p.commonapi.IdRange idRange) {
        return this.subSet((IdRange)idRange);
    }

    public rice.p2p.commonapi.Id hash() {
        return this.getHash();
    }
}

