/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.util.Iterator;
import java.util.Observer;
import java.util.Vector;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.Node;
import rice.pastry.LocalNodeI;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeName;
import rice.pastry.ScheduledMessage;
import rice.pastry.client.PastryAppl;
import rice.pastry.commonapi.PastryEndpoint;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.Credentials;
import rice.pastry.security.PastrySecurityManager;

public abstract class PastryNode
implements MessageReceiver,
Node {
    protected NodeId myNodeId;
    private PastrySecurityManager mySecurityManager;
    private MessageDispatch myMessageDispatch;
    private LeafSet leafSet;
    private RoutingTable routeSet;
    protected NodeHandle localhandle;
    private boolean ready;
    protected Vector apps;

    protected PastryNode(NodeId nodeId) {
        this.myNodeId = nodeId;
        this.ready = false;
        this.apps = new Vector();
    }

    public void setElements(NodeHandle nodeHandle, PastrySecurityManager pastrySecurityManager, MessageDispatch messageDispatch, LeafSet leafSet, RoutingTable routingTable) {
        this.localhandle = nodeHandle;
        this.mySecurityManager = pastrySecurityManager;
        this.myMessageDispatch = messageDispatch;
        this.leafSet = leafSet;
        this.routeSet = routingTable;
    }

    public boolean setNodeName(NodeName nodeName) {
        if (this.localhandle != null) {
            this.localhandle.setNodeName(nodeName);
            return true;
        }
        return false;
    }

    public NodeName getNodeName() {
        if (this.localhandle != null) {
            return this.localhandle.getNodeName();
        }
        return null;
    }

    public NodeHandle getLocalHandle() {
        return this.localhandle;
    }

    public NodeId getNodeId() {
        return this.myNodeId;
    }

    public boolean isReady() {
        return this.ready;
    }

    public MessageDispatch getMessageDispatch() {
        return this.myMessageDispatch;
    }

    public void setMessageDispatch(MessageDispatch messageDispatch) {
        this.myMessageDispatch = messageDispatch;
    }

    public abstract void nodeIsReady();

    public abstract void initiateJoin(NodeHandle var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReady() {
        if (this.isReady()) {
            return;
        }
        this.ready = true;
        this.nodeIsReady();
        Vector vector = new Vector(this.apps);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ((PastryAppl)iterator.next()).notifyReady();
        }
        PastryNode pastryNode = this;
        synchronized (pastryNode) {
            this.notifyAll();
        }
    }

    public boolean isClosest(NodeId nodeId) {
        return this.leafSet.mostSimilar(nodeId) == 0;
    }

    public LeafSet getLeafSet() {
        return this.leafSet;
    }

    public RoutingTable getRoutingTable() {
        return this.routeSet;
    }

    public void addLeafSetObserver(Observer observer) {
        this.leafSet.addObserver(observer);
    }

    public void deleteLeafSetObserver(Observer observer) {
        this.leafSet.deleteObserver(observer);
    }

    public void addRouteSetObserver(Observer observer) {
        this.routeSet.addObserver(observer);
    }

    public void deleteRouteSetObserver(Observer observer) {
        this.routeSet.deleteObserver(observer);
    }

    public synchronized void receiveMessage(Message message) {
        LocalNodeI.pending.setPending(message.getStream(), this);
        if (this.mySecurityManager.verifyMessage(message)) {
            this.myMessageDispatch.dispatchMessage(message);
        }
    }

    public void registerReceiver(Credentials credentials, Address address, MessageReceiver messageReceiver) {
        if (!this.mySecurityManager.verifyAddressBinding(credentials, address)) {
            throw new Error("security failure");
        }
        this.myMessageDispatch.registerReceiver(address, messageReceiver);
    }

    public void registerApp(PastryAppl pastryAppl) {
        if (this.isReady()) {
            pastryAppl.notifyReady();
        }
        this.apps.add(pastryAppl);
    }

    public abstract ScheduledMessage scheduleMsg(Message var1, long var2);

    public abstract ScheduledMessage scheduleMsg(Message var1, long var2, long var4);

    public abstract ScheduledMessage scheduleMsgAtFixedRate(Message var1, long var2, long var4);

    public String toString() {
        NodeName nodeName = this.getNodeName();
        if (nodeName != null) {
            return "Pastry node (name: " + nodeName.toString() + ") " + this.myNodeId.toString();
        }
        return "Pastry node " + this.myNodeId.toString();
    }

    public Endpoint registerApplication(Application application, String string) {
        return new PastryEndpoint(this, application, string);
    }

    public Id getId() {
        return this.getNodeId();
    }

    public IdFactory getIdFactory() {
        return new PastryIdFactory();
    }
}

