/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.util.Hashtable;
import java.util.Vector;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.leafset.LeafSet;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;

public abstract class PastryNodeFactory {
    private Hashtable pingCache = new Hashtable();

    public abstract PastryNode newNode(NodeHandle var1);

    public abstract PastryNode newNode(NodeHandle var1, NodeId var2);

    public abstract LeafSet getLeafSet(NodeHandle var1);

    public abstract RouteSet[] getRouteRow(NodeHandle var1, int var2);

    public abstract int getProximity(NodeHandle var1, NodeHandle var2);

    private int proximity(NodeHandle nodeHandle, NodeHandle nodeHandle2) {
        Hashtable<NodeId, Integer> hashtable = (Hashtable<NodeId, Integer>)this.pingCache.get(nodeHandle.getNodeId());
        if (hashtable == null) {
            hashtable = new Hashtable<NodeId, Integer>();
            this.pingCache.put(nodeHandle.getNodeId(), hashtable);
        }
        if (hashtable.get(nodeHandle2.getNodeId()) == null) {
            int n = this.getProximity(nodeHandle, nodeHandle2);
            hashtable.put(nodeHandle2.getNodeId(), new Integer(n));
            return n;
        }
        return (Integer)hashtable.get(nodeHandle2.getNodeId());
    }

    public NodeHandle getNearest(NodeHandle nodeHandle, NodeHandle nodeHandle2) {
        if (nodeHandle2 == null) {
            return null;
        }
        NodeHandle nodeHandle3 = nodeHandle2;
        NodeHandle nodeHandle4 = nodeHandle2;
        int n = 160 / RoutingTable.idBaseBitLength;
        for (int i = 0; i < n; ++i) {
            nodeHandle4 = this.closestToMe(nodeHandle, nodeHandle4, this.getRouteRow(nodeHandle4, i));
        }
        while (!(nodeHandle3 = nodeHandle4).equals(nodeHandle4 = this.closestToMe(nodeHandle, nodeHandle4, this.getRouteRow(nodeHandle4, n - 1)))) {
        }
        if (nodeHandle4.getLocalNode() == null) {
            nodeHandle4.setLocalNode(nodeHandle.getLocalNode());
        }
        return nodeHandle4;
    }

    private NodeHandle closestToMe(NodeHandle nodeHandle, NodeHandle nodeHandle2, LeafSet leafSet) {
        int n;
        Vector<NodeHandle> vector = new Vector<NodeHandle>();
        for (n = 1; n <= leafSet.cwSize(); ++n) {
            vector.add(leafSet.get(n));
        }
        for (n = -leafSet.ccwSize(); n < 0; ++n) {
            vector.add(leafSet.get(n));
        }
        return this.closestToMe(nodeHandle, nodeHandle2, vector.toArray(new NodeHandle[0]));
    }

    private NodeHandle closestToMe(NodeHandle nodeHandle, NodeHandle nodeHandle2, RouteSet[] routeSetArray) {
        Vector<NodeHandle> vector = new Vector<NodeHandle>();
        for (int i = 0; i < routeSetArray.length; ++i) {
            RouteSet routeSet = routeSetArray[i];
            if (routeSet == null) continue;
            for (int j = 0; j < routeSet.size(); ++j) {
                vector.add(routeSet.get(j));
            }
        }
        return this.closestToMe(nodeHandle, nodeHandle2, vector.toArray(new NodeHandle[0]));
    }

    private NodeHandle closestToMe(NodeHandle nodeHandle, NodeHandle nodeHandle2, NodeHandle[] nodeHandleArray) {
        NodeHandle nodeHandle3 = nodeHandle2;
        int n = this.proximity(nodeHandle, nodeHandle3);
        for (int i = 0; i < nodeHandleArray.length; ++i) {
            NodeHandle nodeHandle4 = nodeHandleArray[i];
            if (this.proximity(nodeHandle, nodeHandle4) >= n || !nodeHandle4.isAlive()) continue;
            n = this.proximity(nodeHandle, nodeHandle4);
            nodeHandle3 = nodeHandle4;
        }
        return nodeHandle3;
    }
}

