/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.client;

import rice.pastry.Id;
import rice.pastry.IdRange;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSet;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteMessage;
import rice.pastry.security.Credentials;

public abstract class CommonAPIAppl
extends PastryAppl {
    public CommonAPIAppl(PastryNode pastryNode) {
        super(pastryNode);
    }

    public CommonAPIAppl(PastryNode pastryNode, String string) {
        super(pastryNode, string);
    }

    public void route(Id id, Message message, NodeHandle nodeHandle) {
        if (Log.ifp(8)) {
            System.out.println("[" + this.thePastryNode + "] route " + message + " to " + id);
        }
        RouteMessage routeMessage = new RouteMessage(id, message, nodeHandle, this.getAddress());
        this.thePastryNode.receiveMessage(routeMessage);
    }

    public NodeSet localLookup(Id id, int n, boolean bl) {
        return this.getRoutingTable().alternateRoutes(id, n);
    }

    public NodeSet neighborSet(int n) {
        return this.getLeafSet().neighborSet(n);
    }

    public NodeSet replicaSet(Id id, int n) {
        return this.getLeafSet().replicaSet(id, n);
    }

    public IdRange range(NodeHandle nodeHandle, int n, Id id, boolean bl) {
        if (bl) {
            return this.getLeafSet().range(nodeHandle, n);
        }
        IdRange idRange = this.getLeafSet().range(nodeHandle, n, false);
        IdRange idRange2 = this.getLeafSet().range(nodeHandle, n, true);
        if (idRange2 == null || idRange.contains(id) || id.isBetween(idRange2.getCW(), idRange.getCCW())) {
            return idRange;
        }
        return idRange2;
    }

    public IdRange range(NodeHandle nodeHandle, int n, Id id) {
        return this.range(nodeHandle, n, id, false);
    }

    public abstract Credentials getCredentials();

    public abstract void deliver(Id var1, Message var2);

    public void forward(RouteMessage routeMessage) {
    }

    public void update(NodeHandle nodeHandle, boolean bl) {
    }

    public void notifyReady() {
    }

    public final void messageForAppl(Message message) {
    }

    public final void leafSetChange(NodeHandle nodeHandle, boolean bl) {
        this.update(nodeHandle, bl);
    }

    public void receiveMessage(Message message) {
        if (Log.ifp(8)) {
            System.out.println("[" + this.thePastryNode + "] recv " + message);
        }
        if (message instanceof RouteMessage) {
            RouteMessage routeMessage = (RouteMessage)message;
            this.forward(routeMessage);
            if (routeMessage.nextHop != null) {
                NodeHandle nodeHandle = routeMessage.nextHop;
                if (this.getNodeId().equals(nodeHandle.getNodeId())) {
                    this.deliver(routeMessage.getTarget(), routeMessage.unwrap());
                } else {
                    routeMessage.routeMessage(this.getNodeId());
                }
            }
        } else {
            this.deliver(null, message);
        }
    }
}

