/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.client;

import java.util.Observable;
import java.util.Observer;
import rice.pastry.Id;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeSetUpdate;
import rice.pastry.PastryNode;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RoutingTable;
import rice.pastry.routing.SendOptions;
import rice.pastry.security.Credentials;
import rice.pastry.standard.StandardAddress;

public abstract class PastryAppl
implements MessageReceiver {
    protected String instance;
    protected PastryNode thePastryNode;
    protected Address address;

    public PastryAppl(PastryNode pastryNode) {
        this.thePastryNode = pastryNode;
        this.thePastryNode.registerReceiver(this.getCredentials(), this.getAddress(), this);
        this.thePastryNode.addLeafSetObserver(new LeafSetObserver());
        this.thePastryNode.addRouteSetObserver(new RouteSetObserver());
        this.thePastryNode.registerApp(this);
    }

    public PastryAppl(PastryNode pastryNode, String string) {
        this.instance = string;
        this.address = new StandardAddress(this.getClass(), string);
        this.thePastryNode = pastryNode;
        this.thePastryNode.registerReceiver(this.getCredentials(), this.getAddress(), this);
        this.thePastryNode.addLeafSetObserver(new LeafSetObserver());
        this.thePastryNode.addRouteSetObserver(new RouteSetObserver());
        this.thePastryNode.registerApp(this);
    }

    public Address getAddress() {
        return this.address;
    }

    public final void registerReceiver(Credentials credentials, Address address, MessageReceiver messageReceiver) {
        this.thePastryNode.registerReceiver(credentials, address, messageReceiver);
    }

    public final void sendMessage(Message message) {
        if (Log.ifp(8)) {
            System.out.println("[" + this.thePastryNode + "] send " + message);
        }
        this.thePastryNode.receiveMessage(message);
    }

    public void receiveMessage(Message message) {
        if (Log.ifp(8)) {
            System.out.println("[" + this.thePastryNode + "] recv " + message);
        }
        if (message instanceof RouteMessage) {
            RouteMessage routeMessage = (RouteMessage)message;
            if (this.enrouteMessage(routeMessage.unwrap(), routeMessage.getTarget(), routeMessage.nextHop.getNodeId(), routeMessage.getOptions())) {
                routeMessage.routeMessage(this.thePastryNode.getNodeId());
            }
        } else {
            this.messageForAppl(message);
        }
    }

    public final NodeId getNodeId() {
        return this.thePastryNode.getNodeId();
    }

    public NodeHandle getNodeHandle() {
        return this.thePastryNode.getLocalHandle();
    }

    public boolean routeMsgDirect(NodeHandle nodeHandle, Message message, Credentials credentials, SendOptions sendOptions) {
        if (Log.ifp(8)) {
            System.out.println("[" + this.thePastryNode + "] routemsgdirect " + message + " to " + nodeHandle);
        }
        if (!nodeHandle.isAlive()) {
            return false;
        }
        nodeHandle.receiveMessage(message);
        return nodeHandle.isAlive();
    }

    public void routeMsg(Id id, Message message, Credentials credentials, SendOptions sendOptions) {
        if (Log.ifp(8)) {
            System.out.println("[" + this.thePastryNode + "] routemsg " + message + " to " + id);
        }
        RouteMessage routeMessage = new RouteMessage(id, message, credentials, sendOptions, this.getAddress());
        this.thePastryNode.receiveMessage(routeMessage);
    }

    public LeafSet getLeafSet() {
        return this.thePastryNode.getLeafSet();
    }

    public RoutingTable getRoutingTable() {
        return this.thePastryNode.getRoutingTable();
    }

    public boolean isClosest(NodeId nodeId) {
        return this.thePastryNode.isClosest(nodeId);
    }

    public abstract Credentials getCredentials();

    public abstract void messageForAppl(Message var1);

    public boolean enrouteMessage(Message message, Id id, NodeId nodeId, SendOptions sendOptions) {
        return true;
    }

    public void leafSetChange(NodeHandle nodeHandle, boolean bl) {
    }

    public void routeSetChange(NodeHandle nodeHandle, boolean bl) {
    }

    public void notifyReady() {
    }

    private class RouteSetObserver
    implements Observer {
        private RouteSetObserver() {
        }

        public void update(Observable observable, Object object) {
            NodeSetUpdate nodeSetUpdate = (NodeSetUpdate)object;
            NodeHandle nodeHandle = nodeSetUpdate.handle();
            boolean bl = nodeSetUpdate.wasAdded();
            PastryAppl.this.routeSetChange(nodeHandle, bl);
        }
    }

    private class LeafSetObserver
    implements Observer {
        private LeafSetObserver() {
        }

        public void update(Observable observable, Object object) {
            NodeSetUpdate nodeSetUpdate = (NodeSetUpdate)object;
            NodeHandle nodeHandle = nodeSetUpdate.handle();
            boolean bl = nodeSetUpdate.wasAdded();
            PastryAppl.this.leafSetChange(nodeHandle, bl);
        }
    }
}

