/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.commonapi;

import java.util.TimerTask;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.RouteMessage;
import rice.pastry.Id;
import rice.pastry.IdRange;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.commonapi.PastryEndpointMessage;
import rice.pastry.messaging.Message;
import rice.pastry.routing.SendOptions;
import rice.pastry.security.Credentials;
import rice.pastry.security.PermissiveCredentials;

public class PastryEndpoint
extends PastryAppl
implements Endpoint {
    protected Credentials credentials = new PermissiveCredentials();
    protected Application application;

    public PastryEndpoint(PastryNode pastryNode, Application application, String string) {
        super(pastryNode, application.getClass().getName() + string);
        this.application = application;
    }

    public rice.p2p.commonapi.Id getId() {
        return this.thePastryNode.getNodeId();
    }

    public void route(rice.p2p.commonapi.Id id, rice.p2p.commonapi.Message message, rice.p2p.commonapi.NodeHandle nodeHandle) {
        if (Log.ifp(8)) {
            System.out.println("[" + this.thePastryNode + "] route " + message + " to " + id);
        }
        PastryEndpointMessage pastryEndpointMessage = new PastryEndpointMessage(this.getAddress(), message);
        rice.pastry.routing.RouteMessage routeMessage = new rice.pastry.routing.RouteMessage((Id)id, (Message)pastryEndpointMessage, (NodeHandle)nodeHandle, this.getAddress());
        this.thePastryNode.receiveMessage(routeMessage);
    }

    public TimerTask scheduleMessage(rice.p2p.commonapi.Message message, long l) {
        PastryEndpointMessage pastryEndpointMessage = new PastryEndpointMessage(this.getAddress(), message);
        return this.thePastryNode.scheduleMsg(pastryEndpointMessage, l);
    }

    public TimerTask scheduleMessage(rice.p2p.commonapi.Message message, long l, long l2) {
        PastryEndpointMessage pastryEndpointMessage = new PastryEndpointMessage(this.getAddress(), message);
        return this.thePastryNode.scheduleMsg(pastryEndpointMessage, l, l2);
    }

    public NodeHandleSet localLookup(rice.p2p.commonapi.Id id, int n, boolean bl) {
        return this.getRoutingTable().alternateRoutes((Id)id, n);
    }

    public NodeHandleSet neighborSet(int n) {
        return this.getLeafSet().neighborSet(n);
    }

    public NodeHandleSet replicaSet(rice.p2p.commonapi.Id id, int n) {
        return this.getLeafSet().replicaSet((Id)id, n);
    }

    public rice.p2p.commonapi.IdRange range(rice.p2p.commonapi.NodeHandle nodeHandle, int n, rice.p2p.commonapi.Id id, boolean bl) {
        Id id2 = (Id)id;
        if (bl) {
            return this.getLeafSet().range((NodeHandle)nodeHandle, n);
        }
        IdRange idRange = this.getLeafSet().range((NodeHandle)nodeHandle, n, false);
        IdRange idRange2 = this.getLeafSet().range((NodeHandle)nodeHandle, n, true);
        if (idRange2 == null || idRange.contains(id2) || id2.isBetween(idRange2.getCW(), idRange.getCCW())) {
            return idRange;
        }
        return idRange2;
    }

    public rice.p2p.commonapi.IdRange range(rice.p2p.commonapi.NodeHandle nodeHandle, int n, rice.p2p.commonapi.Id id) {
        return this.range(nodeHandle, n, id, false);
    }

    public rice.p2p.commonapi.NodeHandle getLocalNodeHandle() {
        return this.thePastryNode.getLocalHandle();
    }

    public final void messageForAppl(Message message) {
        if (Log.ifp(8)) {
            System.out.println("[" + this.thePastryNode + "] deliver " + message + " from " + message.getSenderId());
        }
        if (message instanceof PastryEndpointMessage) {
            this.application.deliver(null, ((PastryEndpointMessage)message).getMessage());
        } else {
            System.out.println("Received unknown message " + message + " - dropping on floor");
        }
    }

    public final boolean enrouteMessage(rice.p2p.commonapi.Message message, rice.p2p.commonapi.Id id, NodeId nodeId, SendOptions sendOptions) {
        if (message instanceof RouteMessage) {
            if (Log.ifp(8)) {
                System.out.println("[" + this.thePastryNode + "] forward " + message);
            }
            return this.application.forward((RouteMessage)((Object)message));
        }
        return true;
    }

    public void leafSetChange(NodeHandle nodeHandle, boolean bl) {
        this.application.update(nodeHandle, bl);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void receiveMessage(Message message) {
        if (Log.ifp(8)) {
            System.out.println("[" + this.thePastryNode + "] recv " + message);
        }
        if (message instanceof rice.pastry.routing.RouteMessage) {
            rice.pastry.routing.RouteMessage routeMessage = (rice.pastry.routing.RouteMessage)message;
            if (Log.ifp(8)) {
                System.out.println("[" + this.thePastryNode + "] forward " + message);
            }
            if (this.application.forward(routeMessage) && routeMessage.nextHop != null) {
                NodeHandle nodeHandle = routeMessage.nextHop;
                if (this.getNodeId().equals(nodeHandle.getNodeId())) {
                    PastryEndpointMessage pastryEndpointMessage = (PastryEndpointMessage)routeMessage.unwrap();
                    if (Log.ifp(8)) {
                        System.out.println("[" + this.thePastryNode + "] deliver " + pastryEndpointMessage + " from " + pastryEndpointMessage.getSenderId());
                    }
                    this.application.deliver(routeMessage.getTarget(), pastryEndpointMessage.getMessage());
                } else {
                    routeMessage.routeMessage(this.getNodeId());
                }
            }
        } else {
            this.messageForAppl(message);
        }
    }
}

