/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.messaging.Message;

public class DirectNodeHandle
extends NodeHandle {
    private PastryNode remoteNode;
    private NetworkSimulator simulator;

    public DirectNodeHandle(PastryNode pastryNode, PastryNode pastryNode2, NetworkSimulator networkSimulator) {
        this.setLocalNode(pastryNode);
        this.remoteNode = pastryNode2;
        this.simulator = networkSimulator;
    }

    public PastryNode getRemote() {
        return this.remoteNode;
    }

    public NodeId getNodeId() {
        return this.remoteNode.getNodeId();
    }

    public boolean isAlive() {
        return this.simulator.isAlive(this.remoteNode.getNodeId());
    }

    public NetworkSimulator getSimulator() {
        return this.simulator;
    }

    public void notifyObservers(Object object) {
        this.setChanged();
        super.notifyObservers(object);
    }

    public boolean ping() {
        return this.isAlive();
    }

    public int proximity() {
        this.assertLocalNode();
        int n = this.simulator.proximity(this.getLocalNode().getNodeId(), this.remoteNode.getNodeId());
        return n;
    }

    public void receiveMessage(Message message) {
        if (this.simulator.isAlive(message.getSenderId())) {
            this.simulator.deliverMessage(message, this.remoteNode);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        NodeHandle nodeHandle = (NodeHandle)object;
        return this.getNodeId().equals(nodeHandle.getNodeId());
    }

    public int hashCode() {
        return this.getNodeId().hashCode();
    }
}

