/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.NodeName;
import rice.pastry.NodeNameFactory;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.DirectSecurityManager;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.PastrySecurityManager;
import rice.pastry.standard.StandardJoinProtocol;
import rice.pastry.standard.StandardLeafSetProtocol;
import rice.pastry.standard.StandardRouteSetProtocol;
import rice.pastry.standard.StandardRouter;

public class DirectPastryNodeFactory
extends PastryNodeFactory {
    protected NodeIdFactory nidFactory;
    protected NetworkSimulator simulator;
    protected NodeNameFactory nameFactory;
    protected static final int rtMax = 1;
    protected static final int lSetSize = 24;

    public DirectPastryNodeFactory(NodeIdFactory nodeIdFactory, NetworkSimulator networkSimulator) {
        this.nidFactory = nodeIdFactory;
        this.simulator = networkSimulator;
        this.nameFactory = null;
    }

    public void setNodeNameFactory(NodeNameFactory nodeNameFactory) {
        this.nameFactory = nodeNameFactory;
    }

    public NetworkSimulator getNetworkSimulator() {
        return this.simulator;
    }

    public PastryNode newNode(NodeHandle nodeHandle) {
        return this.newNode(nodeHandle, this.nidFactory.generateNodeId());
    }

    public PastryNode newNode(NodeHandle nodeHandle, NodeId nodeId) {
        Object object;
        DirectPastryNode directPastryNode = new DirectPastryNode(nodeId, this.simulator);
        DirectNodeHandle directNodeHandle = new DirectNodeHandle(directPastryNode, directPastryNode, this.simulator);
        if (this.nameFactory != null) {
            object = this.nameFactory.generateNodeName();
            System.err.println("generated name :" + object);
            directNodeHandle.setNodeName((NodeName)object);
        }
        this.simulator.registerNodeId(directNodeHandle);
        object = new DirectSecurityManager(this.simulator);
        MessageDispatch messageDispatch = new MessageDispatch();
        RoutingTable routingTable = new RoutingTable(directNodeHandle, 1);
        LeafSet leafSet = new LeafSet(directNodeHandle, 24);
        StandardRouter standardRouter = new StandardRouter(directNodeHandle, routingTable, leafSet, (PastrySecurityManager)object);
        StandardLeafSetProtocol standardLeafSetProtocol = new StandardLeafSetProtocol(directPastryNode, directNodeHandle, (PastrySecurityManager)object, leafSet, routingTable);
        StandardRouteSetProtocol standardRouteSetProtocol = new StandardRouteSetProtocol(directNodeHandle, (PastrySecurityManager)object, routingTable);
        StandardJoinProtocol standardJoinProtocol = new StandardJoinProtocol(directPastryNode, directNodeHandle, (PastrySecurityManager)object, routingTable, leafSet);
        messageDispatch.registerReceiver(standardRouter.getAddress(), standardRouter);
        messageDispatch.registerReceiver(standardLeafSetProtocol.getAddress(), standardLeafSetProtocol);
        messageDispatch.registerReceiver(standardRouteSetProtocol.getAddress(), standardRouteSetProtocol);
        messageDispatch.registerReceiver(standardJoinProtocol.getAddress(), standardJoinProtocol);
        directPastryNode.setElements(directNodeHandle, (PastrySecurityManager)object, messageDispatch, leafSet, routingTable);
        directPastryNode.setDirectElements();
        ((DirectSecurityManager)object).setLocalPastryNode(directPastryNode);
        directPastryNode.doneNode(this.getNearest(directNodeHandle, nodeHandle));
        return directPastryNode;
    }

    public LeafSet getLeafSet(NodeHandle nodeHandle) {
        DirectNodeHandle directNodeHandle = (DirectNodeHandle)nodeHandle;
        return directNodeHandle.getRemote().getLeafSet();
    }

    public RouteSet[] getRouteRow(NodeHandle nodeHandle, int n) {
        DirectNodeHandle directNodeHandle = (DirectNodeHandle)nodeHandle;
        return directNodeHandle.getRemote().getRoutingTable().getRow(n);
    }

    public int getProximity(NodeHandle nodeHandle, NodeHandle nodeHandle2) {
        return this.simulator.proximity(nodeHandle.getNodeId(), nodeHandle2.getNodeId());
    }
}

