/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.util.Date;
import java.util.Hashtable;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.security.Credentials;
import rice.pastry.security.PastrySecurityManager;

public class DirectSecurityManager
implements PastrySecurityManager {
    private PastryNode pnode = null;
    private NetworkSimulator sim;
    private Hashtable pool;

    public DirectSecurityManager(NetworkSimulator networkSimulator) {
        this.sim = networkSimulator;
        this.pool = new Hashtable();
    }

    public void setLocalPastryNode(PastryNode pastryNode) {
        this.pnode = pastryNode;
    }

    public boolean verifyMessage(Message message) {
        return true;
    }

    public boolean verifyAddressBinding(Credentials credentials, Address address) {
        return true;
    }

    public NodeHandle verifyNodeHandle(NodeHandle nodeHandle) {
        NodeId nodeId;
        NodeId nodeId2 = this.pnode.getNodeId();
        if (nodeId2.equals(nodeId = nodeHandle.getNodeId())) {
            return this.pnode.getLocalHandle();
        }
        if (nodeHandle instanceof DirectNodeHandle) {
            DirectNodeHandle directNodeHandle = (DirectNodeHandle)nodeHandle;
            DirectNodeHandle directNodeHandle2 = (DirectNodeHandle)this.pool.get(nodeHandle.getNodeId());
            if (directNodeHandle2 == null) {
                directNodeHandle2 = new DirectNodeHandle(this.pnode, directNodeHandle.getRemote(), this.sim);
                directNodeHandle2.setNodeName(directNodeHandle.getNodeName());
                this.pool.put(nodeHandle.getNodeId(), directNodeHandle2);
                this.sim.registerNodeId(directNodeHandle2);
            }
            return directNodeHandle2;
        }
        throw new Error("node handle of unknown type");
    }

    public Date getTimestamp() {
        return new Date();
    }
}

