/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeName;
import rice.pastry.PastryNode;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.TestRecord;
import rice.pastry.messaging.Message;

public class TreeMetricNetwork
implements NetworkSimulator {
    private HashMap nodeMap = new HashMap();
    private Vector msgQueue = new Vector();
    private TestRecord testRecord = null;

    public boolean isAlive(NodeId nodeId) {
        NodeRecord nodeRecord = (NodeRecord)this.nodeMap.get(nodeId);
        if (nodeRecord == null) {
            return true;
        }
        return nodeRecord.alive;
    }

    public DirectNodeHandle getClosest(NodeId nodeId) {
        Iterator iterator = this.nodeMap.values().iterator();
        DirectNodeHandle directNodeHandle = null;
        int n = Integer.MAX_VALUE;
        while (iterator.hasNext()) {
            NodeRecord nodeRecord = (NodeRecord)iterator.next();
            DirectNodeHandle directNodeHandle2 = (DirectNodeHandle)nodeRecord.handles.elementAt(0);
            NodeId nodeId2 = directNodeHandle2.getNodeId();
            if (!directNodeHandle2.isAlive() || !directNodeHandle2.getLocalNode().isReady() || nodeId == nodeId2 || this.proximity(nodeId, nodeId2) >= n) continue;
            n = this.proximity(nodeId, nodeId2);
            directNodeHandle = directNodeHandle2;
        }
        return directNodeHandle;
    }

    public void setAlive(NodeId nodeId, boolean bl) {
        NodeRecord nodeRecord = (NodeRecord)this.nodeMap.get(nodeId);
        if (nodeRecord == null) {
            throw new Error("setting node alive for unknown node");
        }
        if (nodeRecord.alive != bl) {
            nodeRecord.alive = bl;
            DirectNodeHandle[] directNodeHandleArray = nodeRecord.handles.toArray(new DirectNodeHandle[0]);
            for (int i = 0; i < directNodeHandleArray.length; ++i) {
                if (bl) {
                    directNodeHandleArray[i].notifyObservers(NodeHandle.DECLARED_LIVE);
                    continue;
                }
                directNodeHandleArray[i].notifyObservers(NodeHandle.DECLARED_DEAD);
            }
        }
    }

    public void registerNodeId(DirectNodeHandle directNodeHandle) {
        NodeId nodeId = directNodeHandle.getNodeId();
        if (this.nodeMap.get(nodeId) != null) {
            NodeRecord nodeRecord = (NodeRecord)this.nodeMap.get(nodeId);
            nodeRecord.handles.add(directNodeHandle);
        } else {
            this.nodeMap.put(nodeId, new NodeRecord(directNodeHandle));
        }
    }

    public int proximity(NodeId nodeId, NodeId nodeId2) {
        NodeRecord nodeRecord = (NodeRecord)this.nodeMap.get(nodeId);
        NodeRecord nodeRecord2 = (NodeRecord)this.nodeMap.get(nodeId2);
        if (nodeRecord == null || nodeRecord2 == null) {
            throw new Error("asking about node proximity for unknown node(s)");
        }
        return nodeRecord.proximity(nodeRecord2);
    }

    public void deliverMessage(Message message, PastryNode pastryNode) {
        if (this.isAlive(message.getSenderId())) {
            MessageDelivery messageDelivery = new MessageDelivery(message, pastryNode);
            this.msgQueue.addElement(messageDelivery);
        }
    }

    public boolean simulate() {
        if (this.msgQueue.size() == 0) {
            return false;
        }
        MessageDelivery messageDelivery = (MessageDelivery)this.msgQueue.firstElement();
        this.msgQueue.removeElementAt(0);
        messageDelivery.deliver();
        return true;
    }

    public void setTestRecord(TestRecord testRecord) {
        this.testRecord = testRecord;
    }

    public TestRecord getTestRecord() {
        return this.testRecord;
    }

    public NodeRecord getNodeRecord(DirectNodeHandle directNodeHandle) {
        return new NodeRecord(directNodeHandle);
    }

    public static void main(String[] stringArray) {
        TreeMetricNetwork treeMetricNetwork = new TreeMetricNetwork();
        DirectPastryNode directPastryNode = new DirectPastryNode(null, treeMetricNetwork);
        DirectPastryNode directPastryNode2 = new DirectPastryNode(null, treeMetricNetwork);
        directPastryNode.setNodeName(new NodeName("begonia.cs.utexas.edu"));
        directPastryNode2.setNodeName(new NodeName("rose.cs.utexas.edu"));
        DirectNodeHandle directNodeHandle = new DirectNodeHandle(directPastryNode, directPastryNode2, null);
        NodeRecord nodeRecord = treeMetricNetwork.getNodeRecord(directNodeHandle);
        DirectNodeHandle directNodeHandle2 = new DirectNodeHandle(directPastryNode2, directPastryNode, null);
        NodeRecord nodeRecord2 = treeMetricNetwork.getNodeRecord(directNodeHandle2);
        System.out.println("proximity between " + directNodeHandle.getLocalNode().getNodeName() + " and " + directNodeHandle2.getLocalNode().getNodeName() + " is " + nodeRecord.proximity(nodeRecord2));
    }

    private class NodeRecord {
        public boolean alive = true;
        public int maxLevels = 100;
        public Vector handles = new Vector();

        public NodeRecord(DirectNodeHandle directNodeHandle) {
            this.handles.add(directNodeHandle);
        }

        public int proximity(NodeRecord nodeRecord) {
            DirectNodeHandle directNodeHandle = (DirectNodeHandle)this.handles.get(0);
            NodeName nodeName = directNodeHandle.getLocalNode().getNodeName();
            NodeName nodeName2 = ((DirectNodeHandle)nodeRecord.handles.get(0)).getLocalNode().getNodeName();
            return this.maxLevels - nodeName.commonLevels(nodeName2);
        }
    }

    private class MessageDelivery {
        private Message msg;
        private PastryNode node;

        public MessageDelivery(Message message, PastryNode pastryNode) {
            this.msg = message;
            this.node = pastryNode;
        }

        public void deliver() {
            this.node.receiveMessage(this.msg);
        }
    }
}

