/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.dist;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetSocketAddress;
import java.util.Observable;
import java.util.Observer;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.dist.DistNodeHandle;
import rice.pastry.dist.DistPastryNode;
import rice.pastry.messaging.Message;

public abstract class DistCoalesedNodeHandle
extends DistNodeHandle {
    public static int DEFAULT_DISTANCE = Integer.MAX_VALUE;
    private transient boolean verified = false;
    private transient DistCoalesedNodeHandle redirect = null;
    protected transient boolean isInPool = false;
    protected transient boolean alive = true;
    protected transient boolean isLocal = false;
    private transient int distance = DEFAULT_DISTANCE;

    public DistCoalesedNodeHandle(NodeId nodeId, InetSocketAddress inetSocketAddress) {
        super(nodeId, inetSocketAddress);
    }

    private final void verify() {
        if (!this.verified && this.getLocalNode() != null) {
            DistCoalesedNodeHandle distCoalesedNodeHandle = (DistCoalesedNodeHandle)((DistPastryNode)this.getLocalNode()).getNodeHandlePool().coalesce(this);
            if (distCoalesedNodeHandle != this) {
                this.redirect = distCoalesedNodeHandle;
            }
            this.verified = true;
        }
    }

    public void afterSetLocalNode() {
        this.alive = true;
        this.isLocal = this.nodeId != null && this.getLocalNode().getNodeId().equals(this.nodeId);
        this.verify();
    }

    public final boolean isAlive() {
        this.verify();
        if (this.redirect != null) {
            return this.redirect.isAlive();
        }
        if (this.isLocal && !this.alive) {
            System.out.println("panic; local node dead");
        }
        return this.alive;
    }

    public final void markAlive() {
        this.verify();
        if (this.redirect != null) {
            this.redirect.markAlive();
            return;
        }
        if (!this.alive) {
            if (Log.ifp(5)) {
                System.out.println(this.getLocalNode() + "found " + this.nodeId + " to be alive after all");
            }
            this.alive = true;
            this.distance = Integer.MAX_VALUE;
            this.setChanged();
            this.notifyObservers(DECLARED_LIVE);
        }
    }

    public final void markDead() {
        this.verify();
        if (this.redirect != null) {
            this.redirect.markDead();
            return;
        }
        if (this.alive) {
            if (Log.ifp(5)) {
                if (this.getLocalNode() == null) {
                    System.out.println("Incoming node handle " + this.nodeId + " found remote node to be dead");
                } else {
                    System.out.println(this.getLocalNode() + " found " + this.nodeId + " to be dead");
                }
            }
            this.alive = false;
            this.distance = Integer.MAX_VALUE;
            this.setChanged();
            this.notifyObservers(DECLARED_DEAD);
        }
    }

    public final int proximity() {
        this.verify();
        if (this.redirect != null) {
            return this.redirect.proximity();
        }
        if (this.isLocal) {
            return 0;
        }
        return this.distance;
    }

    protected final void setProximity(int n) {
        this.distance = n;
        this.setChanged();
        this.notifyObservers(PROXIMITY_CHANGED);
    }

    public final boolean ping() {
        this.verify();
        if (this.redirect != null) {
            return this.redirect.pingImpl();
        }
        return this.pingImpl();
    }

    protected abstract boolean pingImpl();

    public final void receiveMessage(Message message) {
        this.verify();
        if (this.redirect != null) {
            this.redirect.receiveMessageImpl(message);
        } else {
            this.receiveMessageImpl(message);
        }
    }

    protected abstract void receiveMessageImpl(Message var1);

    public final String toString() {
        this.verify();
        if (this.redirect != null) {
            return this.redirect.toStringImpl();
        }
        return this.toStringImpl();
    }

    protected abstract String toStringImpl();

    public boolean getIsInPool() {
        return this.isInPool;
    }

    public void setIsInPool(boolean bl) {
        this.isInPool = bl;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof NodeHandle)) {
            return false;
        }
        NodeHandle nodeHandle = (NodeHandle)object;
        return this.nodeId.equals(nodeHandle.getNodeId());
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.verified = false;
        this.isInPool = false;
        this.alive = true;
        this.distance = DEFAULT_DISTANCE;
        this.isLocal = false;
    }

    protected void debug(String string) {
        if (Log.ifp(8)) {
            if (this.getLocalNode() != null) {
                System.out.println(this.getLocalNode().getNodeId() + " (" + this.nodeId + "): " + string);
            } else {
                System.out.println(this.getLocalNode() + " (" + this.nodeId + "): " + string);
            }
        }
    }

    public void addObserver(Observer observer) {
        this.verify();
        if (this.redirect != null) {
            this.redirect.addObserver(observer);
        } else {
            super.addObserver(observer);
        }
    }

    public int countObservers() {
        this.verify();
        if (this.redirect != null) {
            return this.redirect.countObservers();
        }
        return super.countObservers();
    }

    public void deleteObserver(Observer observer) {
        this.verify();
        if (this.redirect != null) {
            this.redirect.deleteObserver(observer);
        } else {
            super.deleteObserver(observer);
        }
    }

    public void deleteObservers() {
        this.verify();
        if (this.redirect != null) {
            this.redirect.deleteObservers();
        } else {
            super.deleteObservers();
        }
    }

    public boolean hasChanged() {
        this.verify();
        if (this.redirect != null) {
            return this.redirect.hasChanged();
        }
        return super.hasChanged();
    }

    public void notifyObservers() {
        this.verify();
        if (this.redirect != null) {
            this.redirect.notifyObservers();
        } else {
            super.notifyObservers();
        }
    }

    public void notifyObservers(Object object) {
        this.verify();
        if (this.redirect != null) {
            this.redirect.notifyObservers(object);
        } else {
            super.notifyObservers(object);
        }
    }

    protected void setChanged() {
        this.verify();
        if (this.redirect != null) {
            this.redirect.setChanged();
        } else {
            super.setChanged();
        }
    }

    protected void clearChanged() {
        this.verify();
        if (this.redirect != null) {
            this.redirect.clearChanged();
        } else {
            super.clearChanged();
        }
    }

    public void update(Observable observable, Object object) {
        System.out.println("DistCoalesedNodeHandle::update(): should not be here!!!!");
    }
}

