/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.dist;

import java.util.Timer;
import java.util.TimerTask;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.ScheduledMessage;
import rice.pastry.dist.DistNodeHandlePool;
import rice.pastry.join.InitiateJoin;
import rice.pastry.leafset.InitiateLeafSetMaintenance;
import rice.pastry.messaging.Message;
import rice.pastry.routing.InitiateRouteSetMaintenance;

public abstract class DistPastryNode
extends PastryNode {
    protected int leafSetMaintFreq;
    protected int routeSetMaintFreq;
    private Timer timer = new Timer(true);
    private ScheduledMessage joinEvent;

    protected DistPastryNode(NodeId nodeId) {
        super(nodeId);
    }

    public abstract DistNodeHandlePool getNodeHandlePool();

    public final void initiateJoin(NodeHandle nodeHandle) {
        if (nodeHandle != null) {
            this.joinEvent = this.scheduleMsg(new InitiateJoin(nodeHandle), 0L, 5000L);
        } else {
            this.setReady();
        }
    }

    public void nodeIsReady() {
        if (this.joinEvent != null) {
            this.joinEvent.cancel();
        }
    }

    public void doneNode(NodeHandle nodeHandle) {
        if (this.leafSetMaintFreq > 0) {
            this.scheduleMsgAtFixedRate(new InitiateLeafSetMaintenance(), this.leafSetMaintFreq * 1000, this.leafSetMaintFreq * 1000);
        }
        if (this.routeSetMaintFreq > 0) {
            this.scheduleMsgAtFixedRate(new InitiateRouteSetMaintenance(), this.routeSetMaintFreq * 1000, this.routeSetMaintFreq * 1000);
        }
    }

    public void kill() {
        this.timer.cancel();
    }

    public ScheduledMessage scheduleMsg(Message message, long l) {
        ScheduledMessage scheduledMessage = new ScheduledMessage(this, message);
        this.timer.schedule((TimerTask)scheduledMessage, l);
        return scheduledMessage;
    }

    public ScheduledMessage scheduleMsg(Message message, long l, long l2) {
        ScheduledMessage scheduledMessage = new ScheduledMessage(this, message);
        this.timer.schedule((TimerTask)scheduledMessage, l, l2);
        return scheduledMessage;
    }

    public ScheduledMessage scheduleMsgAtFixedRate(Message message, long l, long l2) {
        ScheduledMessage scheduledMessage = new ScheduledMessage(this, message);
        this.timer.scheduleAtFixedRate((TimerTask)scheduledMessage, l, l2);
        return scheduledMessage;
    }
}

