/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.hdht;

import java.util.Observer;
import rice.pastry.Assert;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.PastrySecurityManager;

public class HdhtDirectPastryNode
extends DirectPastryNode {
    private NetworkSimulator simulator;
    private LeafSet[] leafSet;

    public HdhtDirectPastryNode(NodeId nodeId, NetworkSimulator networkSimulator) {
        super(nodeId, networkSimulator);
        this.simulator = networkSimulator;
    }

    public void setElements(NodeHandle nodeHandle, PastrySecurityManager pastrySecurityManager, MessageDispatch messageDispatch, LeafSet[] leafSetArray, RoutingTable routingTable) {
        super.setElements(nodeHandle, pastrySecurityManager, messageDispatch, null, routingTable);
        this.leafSet = leafSetArray;
    }

    public boolean isClosest(NodeId nodeId) {
        return this.leafSet[0].mostSimilar(nodeId) == 0;
    }

    public void printLeafSet() {
        for (int i = 0; i < this.leafSet.length; ++i) {
            System.out.println(this.getNodeId() + " LeafSet at level " + i + "  " + this.leafSet[i]);
        }
    }

    public LeafSet getLeafSet() {
        Assert.myAssert(false, "can not get leafset");
        return null;
    }

    public LeafSet[] getLeafSetArr() {
        return this.leafSet;
    }

    public LeafSet getLeafSetLevel(int n) {
        return this.leafSet[n];
    }

    public void addLeafSetObserver(Observer observer) {
        int n = this.getNodeName().numLevels();
        for (int i = 0; i < n; ++i) {
            this.leafSet[i].addObserver(observer);
        }
    }

    public void deleteLeafSetObserver(Observer observer) {
        int n = this.getNodeName().numLevels();
        for (int i = 0; i < n; ++i) {
            this.leafSet[i].deleteObserver(observer);
        }
    }
}

