/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.hdht;

import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.NodeName;
import rice.pastry.PastryNode;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.DirectSecurityManager;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.hdht.HdhtDirectPastryNode;
import rice.pastry.hdht.HdhtJoinProtocol;
import rice.pastry.hdht.HdhtLeafSetProtocol;
import rice.pastry.hdht.HdhtRouter;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.PastrySecurityManager;
import rice.pastry.standard.StandardJoinProtocol;
import rice.pastry.standard.StandardLeafSetProtocol;
import rice.pastry.standard.StandardRouteSetProtocol;
import rice.pastry.standard.StandardRouter;

public class HdhtDirectPastryNodeFactory
extends DirectPastryNodeFactory {
    public HdhtDirectPastryNodeFactory(NodeIdFactory nodeIdFactory, NetworkSimulator networkSimulator) {
        super(nodeIdFactory, networkSimulator);
    }

    public PastryNode newNode(NodeHandle nodeHandle) {
        return this.newNode(nodeHandle, this.nidFactory.generateNodeId());
    }

    public PastryNode newNode(NodeHandle nodeHandle, NodeId nodeId) {
        Object object;
        HdhtDirectPastryNode hdhtDirectPastryNode = new HdhtDirectPastryNode(nodeId, this.simulator);
        DirectNodeHandle directNodeHandle = new DirectNodeHandle(hdhtDirectPastryNode, hdhtDirectPastryNode, this.simulator);
        if (this.nameFactory != null) {
            object = this.nameFactory.generateNodeName();
            directNodeHandle.setNodeName((NodeName)object);
        }
        this.simulator.registerNodeId(directNodeHandle);
        object = new DirectSecurityManager(this.simulator);
        MessageDispatch messageDispatch = new MessageDispatch();
        RoutingTable routingTable = new RoutingTable(directNodeHandle, 1);
        int n = directNodeHandle.getNodeName().numLevels();
        LeafSet[] leafSetArray = new LeafSet[n];
        for (int i = 0; i < n; ++i) {
            leafSetArray[i] = new LeafSet(directNodeHandle, 24, i);
        }
        HdhtRouter hdhtRouter = new HdhtRouter(directNodeHandle, routingTable, leafSetArray, (PastrySecurityManager)object);
        HdhtLeafSetProtocol hdhtLeafSetProtocol = new HdhtLeafSetProtocol(hdhtDirectPastryNode, directNodeHandle, (PastrySecurityManager)object, leafSetArray, routingTable);
        StandardRouteSetProtocol standardRouteSetProtocol = new StandardRouteSetProtocol(directNodeHandle, (PastrySecurityManager)object, routingTable);
        HdhtJoinProtocol hdhtJoinProtocol = new HdhtJoinProtocol(hdhtDirectPastryNode, directNodeHandle, (PastrySecurityManager)object, routingTable, leafSetArray);
        messageDispatch.registerReceiver(hdhtRouter.getAddress(), hdhtRouter);
        messageDispatch.registerReceiver(hdhtLeafSetProtocol.getAddress(), hdhtLeafSetProtocol);
        messageDispatch.registerReceiver(standardRouteSetProtocol.getAddress(), standardRouteSetProtocol);
        messageDispatch.registerReceiver(hdhtJoinProtocol.getAddress(), hdhtJoinProtocol);
        hdhtDirectPastryNode.setElements((NodeHandle)directNodeHandle, (PastrySecurityManager)object, messageDispatch, leafSetArray, routingTable);
        hdhtDirectPastryNode.setDirectElements();
        ((DirectSecurityManager)object).setLocalPastryNode(hdhtDirectPastryNode);
        hdhtDirectPastryNode.doneNode(this.simulator.getClosest(nodeId));
        return hdhtDirectPastryNode;
    }

    public PastryNode newPastryNode(NodeHandle nodeHandle) {
        return this.newPastryNode(nodeHandle, this.nidFactory.generateNodeId());
    }

    public PastryNode newPastryNode(NodeHandle nodeHandle, NodeId nodeId) {
        Object object;
        DirectPastryNode directPastryNode = new DirectPastryNode(nodeId, this.simulator);
        DirectNodeHandle directNodeHandle = new DirectNodeHandle(directPastryNode, directPastryNode, this.simulator);
        if (this.nameFactory != null) {
            object = this.nameFactory.generateNodeName();
            directNodeHandle.setNodeName((NodeName)object);
        }
        this.simulator.registerNodeId(directNodeHandle);
        object = new DirectSecurityManager(this.simulator);
        MessageDispatch messageDispatch = new MessageDispatch();
        RoutingTable routingTable = new RoutingTable(directNodeHandle, 1);
        LeafSet leafSet = new LeafSet(directNodeHandle, 24);
        StandardRouter standardRouter = new StandardRouter(directNodeHandle, routingTable, leafSet, (PastrySecurityManager)object);
        StandardLeafSetProtocol standardLeafSetProtocol = new StandardLeafSetProtocol(directPastryNode, directNodeHandle, (PastrySecurityManager)object, leafSet, routingTable);
        StandardRouteSetProtocol standardRouteSetProtocol = new StandardRouteSetProtocol(directNodeHandle, (PastrySecurityManager)object, routingTable);
        StandardJoinProtocol standardJoinProtocol = new StandardJoinProtocol(directPastryNode, directNodeHandle, (PastrySecurityManager)object, routingTable, leafSet);
        messageDispatch.registerReceiver(standardRouter.getAddress(), standardRouter);
        messageDispatch.registerReceiver(standardLeafSetProtocol.getAddress(), standardLeafSetProtocol);
        messageDispatch.registerReceiver(standardRouteSetProtocol.getAddress(), standardRouteSetProtocol);
        messageDispatch.registerReceiver(standardJoinProtocol.getAddress(), standardJoinProtocol);
        directPastryNode.setElements(directNodeHandle, (PastrySecurityManager)object, messageDispatch, leafSet, routingTable);
        directPastryNode.setDirectElements();
        ((DirectSecurityManager)object).setLocalPastryNode(directPastryNode);
        directPastryNode.doneNode(this.simulator.getClosest(nodeId));
        return directPastryNode;
    }
}

