/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.hdht;

import rice.pastry.Id;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.hdht.HdhtBroadcastLeafSet;
import rice.pastry.hdht.HdhtJoinRequest;
import rice.pastry.join.InitiateJoin;
import rice.pastry.join.JoinAddress;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.BroadcastRouteRow;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.Credentials;
import rice.pastry.security.PastrySecurityManager;
import rice.pastry.security.PermissiveCredentials;

public class HdhtJoinProtocol
implements MessageReceiver {
    private PastryNode localNode;
    private NodeHandle localHandle;
    private PastrySecurityManager security;
    private RoutingTable routeTable;
    private LeafSet[] leafSet;
    private Address address;

    public HdhtJoinProtocol(PastryNode pastryNode, NodeHandle nodeHandle, PastrySecurityManager pastrySecurityManager, RoutingTable routingTable, LeafSet[] leafSetArray) {
        this.localNode = pastryNode;
        this.localHandle = nodeHandle;
        this.security = pastrySecurityManager;
        this.address = new JoinAddress();
        this.routeTable = routingTable;
        this.leafSet = leafSetArray;
    }

    public Address getAddress() {
        return this.address;
    }

    public void receiveMessage(Message message) {
        if (message instanceof HdhtJoinRequest) {
            if (Log.ifp(6)) {
                System.out.println("Received join request " + message);
            }
            HdhtJoinRequest hdhtJoinRequest = (HdhtJoinRequest)message;
            NodeHandle nodeHandle = hdhtJoinRequest.getHandle();
            nodeHandle = this.security.verifyNodeHandle(nodeHandle);
            if (Log.ifp(6)) {
                System.out.println("liveness of nh " + nodeHandle.isAlive());
            }
            if (nodeHandle.isAlive() && Log.ifp(6)) {
                System.out.println("nh is alive " + nodeHandle + " jr accepted is " + hdhtJoinRequest.accepted());
            }
            if (!hdhtJoinRequest.accepted()) {
                hdhtJoinRequest.acceptJoin(this.localHandle);
                nodeHandle.receiveMessage(hdhtJoinRequest);
            } else {
                NodeHandle nodeHandle2 = hdhtJoinRequest.getJoinHandle();
                if ((nodeHandle2 = this.security.verifyNodeHandle(nodeHandle2)).getNodeId().equals(this.localHandle.getNodeId()) && !this.localNode.isReady()) {
                    System.out.println("NodeId collision, unable to join: " + this.localHandle.getNodeId());
                } else if (nodeHandle2.isAlive()) {
                    this.routeTable.put(nodeHandle2);
                    this.broadcastRows(hdhtJoinRequest);
                    LeafSet[] leafSetArray = hdhtJoinRequest.getLeafSet();
                    for (int i = 0; i < leafSetArray.length; ++i) {
                        HdhtBroadcastLeafSet hdhtBroadcastLeafSet = new HdhtBroadcastLeafSet(nodeHandle2, leafSetArray[i], 1, i);
                        this.localHandle.receiveMessage(hdhtBroadcastLeafSet);
                    }
                }
            }
        } else if (message instanceof RouteMessage) {
            int n;
            RouteMessage routeMessage = (RouteMessage)message;
            HdhtJoinRequest hdhtJoinRequest = (HdhtJoinRequest)routeMessage.unwrap();
            NodeId nodeId = this.localHandle.getNodeId();
            NodeHandle nodeHandle = hdhtJoinRequest.getHandle();
            NodeId nodeId2 = nodeHandle.getNodeId();
            nodeHandle = this.security.verifyNodeHandle(nodeHandle);
            int n2 = RoutingTable.baseBitLength();
            int n3 = nodeId.indexOfMSDD(nodeId2, n2);
            int n4 = hdhtJoinRequest.lastRow();
            if (nodeId.equals(nodeId2)) {
                return;
            }
            for (n = n4 - 1; n3 > 0 && n >= n3; --n) {
                RouteSet[] routeSetArray = this.routeTable.getRow(n);
                hdhtJoinRequest.pushRow(routeSetArray);
            }
            for (n = 0; n <= this.localHandle.getNodeName().commonLevels(nodeHandle.getNodeName()); ++n) {
                hdhtJoinRequest.pushLeafSet(this.leafSet[n], n);
            }
            routeMessage.routeMessage(nodeId);
        } else if (message instanceof InitiateJoin) {
            InitiateJoin initiateJoin = (InitiateJoin)message;
            NodeHandle nodeHandle = initiateJoin.getHandle();
            if ((nodeHandle = this.security.verifyNodeHandle(nodeHandle)).isAlive()) {
                HdhtJoinRequest hdhtJoinRequest = new HdhtJoinRequest(this.localHandle);
                RouteMessage routeMessage = new RouteMessage((Id)this.localHandle.getNodeId(), (Message)hdhtJoinRequest, (Credentials)new PermissiveCredentials(), this.address);
                nodeHandle.receiveMessage(routeMessage);
            }
        }
    }

    public void broadcastRows(HdhtJoinRequest hdhtJoinRequest) {
        BroadcastRouteRow broadcastRouteRow;
        RouteSet[] routeSetArray;
        int n;
        int n2 = hdhtJoinRequest.numRows();
        for (n = hdhtJoinRequest.lastRow(); n < n2; ++n) {
            routeSetArray = hdhtJoinRequest.getRow(n);
            if (routeSetArray == null) continue;
            broadcastRouteRow = new BroadcastRouteRow(this.localHandle, routeSetArray);
            this.localHandle.receiveMessage(broadcastRouteRow);
        }
        for (n = hdhtJoinRequest.lastRow(); n < n2; ++n) {
            routeSetArray = hdhtJoinRequest.getRow(n);
            broadcastRouteRow = new BroadcastRouteRow(this.localHandle, routeSetArray);
            for (int i = 0; i < routeSetArray.length; ++i) {
                RouteSet routeSet = routeSetArray[i];
                if (routeSet == null) continue;
                NodeHandle nodeHandle = routeSet.closestNode();
                if (nodeHandle != null) {
                    nodeHandle = this.security.verifyNodeHandle(nodeHandle);
                }
                if (nodeHandle == null) continue;
                nodeHandle.receiveMessage(broadcastRouteRow);
            }
        }
    }
}

