/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.hdht;

import java.io.Serializable;
import java.util.Date;
import rice.pastry.NodeHandle;
import rice.pastry.join.JoinAddress;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.Credentials;

public class HdhtJoinRequest
extends Message
implements Serializable {
    private NodeHandle handle;
    private NodeHandle joinHandle;
    private int rowCount;
    private RouteSet[][] rows;
    private LeafSet[] leafSet;

    public HdhtJoinRequest(NodeHandle nodeHandle) {
        super(new JoinAddress());
        this.handle = nodeHandle;
        this.initialize();
        this.setPriority(true);
    }

    public HdhtJoinRequest(NodeHandle nodeHandle, Date date) {
        super((Address)new JoinAddress(), date);
        this.handle = nodeHandle;
        this.initialize();
        this.setPriority(true);
    }

    public HdhtJoinRequest(NodeHandle nodeHandle, Credentials credentials) {
        super((Address)new JoinAddress(), credentials);
        this.handle = nodeHandle;
        this.initialize();
        this.setPriority(true);
    }

    public HdhtJoinRequest(NodeHandle nodeHandle, Credentials credentials, Date date) {
        super(new JoinAddress(), credentials, date);
        this.handle = nodeHandle;
        this.initialize();
        this.setPriority(true);
    }

    public NodeHandle getHandle() {
        return this.handle;
    }

    public NodeHandle getJoinHandle() {
        return this.joinHandle;
    }

    public LeafSet[] getLeafSet() {
        return this.leafSet;
    }

    public boolean accepted() {
        return this.joinHandle != null;
    }

    public void acceptJoin(NodeHandle nodeHandle) {
        this.joinHandle = nodeHandle;
    }

    public int lastRow() {
        return this.rowCount;
    }

    public void pushRow(RouteSet[] routeSetArray) {
        this.rows[--this.rowCount] = routeSetArray;
    }

    public void pushLeafSet(LeafSet leafSet, int n) {
        this.leafSet[n] = leafSet;
    }

    public RouteSet[] getRow(int n) {
        return this.rows[n];
    }

    public int numRows() {
        return this.rows.length;
    }

    private void initialize() {
        this.joinHandle = null;
        this.rowCount = 160 / RoutingTable.baseBitLength();
        this.rows = new RouteSet[this.rowCount][];
        this.leafSet = new LeafSet[this.handle.getNodeName().numLevels()];
    }

    public String toString() {
        return "HdhtJoinRequest(" + (this.handle != null ? this.handle.getNodeId() : null) + "," + (this.joinHandle != null ? this.joinHandle.getNodeId() : null) + ")";
    }
}

