/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.hdht;

import java.util.HashSet;
import java.util.Iterator;
import rice.pastry.Assert;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.hdht.HdhtBroadcastLeafSet;
import rice.pastry.hdht.HdhtRequestLeafSet;
import rice.pastry.leafset.InitiateLeafSetMaintenance;
import rice.pastry.leafset.LeafSet;
import rice.pastry.leafset.LeafSetProtocolAddress;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.PastrySecurityManager;

public class HdhtLeafSetProtocol
implements MessageReceiver {
    private final boolean failstop = true;
    private NodeHandle localHandle;
    private PastryNode localNode;
    private PastrySecurityManager security;
    private LeafSet[] leafSet;
    private RoutingTable routeTable;
    private Address address;
    private int numJoinInitMessages = 0;

    public HdhtLeafSetProtocol(PastryNode pastryNode, NodeHandle nodeHandle, PastrySecurityManager pastrySecurityManager, LeafSet[] leafSetArray, RoutingTable routingTable) {
        this.localNode = pastryNode;
        this.localHandle = nodeHandle;
        this.security = pastrySecurityManager;
        this.leafSet = leafSetArray;
        this.routeTable = routingTable;
        this.address = new LeafSetProtocolAddress();
    }

    public Address getAddress() {
        return this.address;
    }

    public void receiveMessage(Message message) {
        if (message instanceof HdhtBroadcastLeafSet) {
            HdhtBroadcastLeafSet hdhtBroadcastLeafSet = (HdhtBroadcastLeafSet)message;
            int n = hdhtBroadcastLeafSet.type();
            NodeHandle nodeHandle = hdhtBroadcastLeafSet.from();
            LeafSet leafSet = hdhtBroadcastLeafSet.leafSet();
            int n2 = hdhtBroadcastLeafSet.level();
            Assert.myAssert(this.leafSet.length > n2);
            Assert.myAssert(nodeHandle.getNodeName() != null, "From node does not have a name?: " + nodeHandle);
            if (hdhtBroadcastLeafSet.type() != 1) {
                // empty if block
            }
            boolean bl = false;
            if (leafSet != null) {
                bl = this.mergeLeafSet(leafSet, nodeHandle, n2);
            }
            if (n == 1) {
                ++this.numJoinInitMessages;
                if (this.numJoinInitMessages == this.leafSet.length) {
                    this.localNode.setReady();
                }
            }
            if (n == 1) {
                this.broadcast(n2);
            }
            if (n == 3 && bl) {
                this.broadcast(n2);
            }
            if (leafSet != null) {
                this.checkLeafSet(leafSet, nodeHandle, true, n2);
            }
        } else if (message instanceof HdhtRequestLeafSet) {
            HdhtRequestLeafSet hdhtRequestLeafSet = (HdhtRequestLeafSet)message;
            NodeHandle nodeHandle = hdhtRequestLeafSet.returnHandle();
            nodeHandle = this.security.verifyNodeHandle(nodeHandle);
            int n = hdhtRequestLeafSet.level();
            Assert.myAssert(n < this.leafSet.length);
            if (nodeHandle.isAlive()) {
                HdhtBroadcastLeafSet hdhtBroadcastLeafSet = new HdhtBroadcastLeafSet(this.localHandle, this.leafSet[n], 0, n);
                nodeHandle.receiveMessage(hdhtBroadcastLeafSet);
            }
        } else if (message instanceof InitiateLeafSetMaintenance) {
            this.maintainHdhtLeafSet();
        } else {
            throw new Error("message received is of unknown type");
        }
    }

    protected boolean checkLeafSet(LeafSet leafSet, NodeHandle nodeHandle, boolean bl, int n) {
        if (!nodeHandle.equals(leafSet.get(0))) {
            nodeHandle = leafSet.get(0);
        }
        if (nodeHandle.getNodeName().commonLevels(this.localHandle.getNodeName()) < n) {
            return false;
        }
        HashSet hashSet = bl ? new HashSet(this.leafSet[n].maxSize() * 2) : null;
        HdhtBroadcastLeafSet hdhtBroadcastLeafSet = new HdhtBroadcastLeafSet(this.localHandle, this.leafSet[n], 3, n);
        boolean bl2 = leafSet.merge(this.leafSet[n], this.localHandle, null, this.security, true, hashSet);
        if (bl2) {
            nodeHandle = this.security.verifyNodeHandle(nodeHandle);
            nodeHandle.receiveMessage(hdhtBroadcastLeafSet);
            if (bl) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    NodeHandle nodeHandle2 = (NodeHandle)iterator.next();
                    nodeHandle2.receiveMessage(hdhtBroadcastLeafSet);
                }
            }
        }
        return bl2;
    }

    protected boolean mergeLeafSet(LeafSet leafSet, NodeHandle nodeHandle, int n) {
        for (int i = -leafSet.ccwSize(); i < leafSet.cwSize(); ++i) {
            NodeHandle nodeHandle2 = leafSet.get(i);
            if (this.localHandle.getNodeName().commonLevels(nodeHandle2.getNodeName()) >= n) continue;
            return false;
        }
        return this.leafSet[n].merge(leafSet, leafSet.get(0), this.routeTable, this.security, false, null);
    }

    protected void broadcast(int n) {
        this.broadcast(2, n);
    }

    protected void broadcast(int n, int n2) {
        HdhtBroadcastLeafSet hdhtBroadcastLeafSet = new HdhtBroadcastLeafSet(this.localHandle, this.leafSet[n2], n, n2);
        int n3 = this.leafSet[n2].cwSize();
        int n4 = this.leafSet[n2].ccwSize();
        for (int i = -n4; i <= n3; ++i) {
            NodeHandle nodeHandle;
            if (i == 0 || (nodeHandle = this.leafSet[n2].get(i)) == null || !nodeHandle.isAlive()) continue;
            nodeHandle.receiveMessage(hdhtBroadcastLeafSet);
        }
    }

    public void maintainHdhtLeafSet() {
        for (int i = 0; i < this.leafSet.length; ++i) {
            this.maintainLeafSet(i);
        }
    }

    public void maintainLeafSet(int n) {
        NodeHandle nodeHandle;
        int n2;
        if (Log.ifp(7)) {
            System.out.println("maintainLeafSet " + this.localHandle.getNodeId());
        }
        boolean bl = false;
        for (n2 = -this.leafSet[n].ccwSize(); n2 < 0; ++n2) {
            nodeHandle = this.leafSet[n].get(n2);
            if (nodeHandle == null || nodeHandle.ping()) continue;
            this.leafSet[n].remove(nodeHandle.getNodeId());
            bl = true;
        }
        for (n2 = this.leafSet[n].cwSize(); n2 > 0; --n2) {
            nodeHandle = this.leafSet[n].get(n2);
            if (nodeHandle == null || nodeHandle.ping()) continue;
            this.leafSet[n].remove(nodeHandle.getNodeId());
            bl = true;
        }
        if (bl || this.leafSet[n].size() < this.leafSet[n].maxSize()) {
            this.requestLeafSet(n);
        }
    }

    private void requestLeafSet(int n) {
        NodeHandle nodeHandle;
        int n2;
        HdhtRequestLeafSet hdhtRequestLeafSet = new HdhtRequestLeafSet(this.localHandle, n);
        int n3 = this.leafSet[n].cwSize();
        int n4 = this.leafSet[n].ccwSize();
        boolean bl = true;
        for (n2 = -n4; n2 < 0; ++n2) {
            nodeHandle = this.leafSet[n].get(n2);
            if (nodeHandle == null || !nodeHandle.isAlive()) continue;
            nodeHandle.receiveMessage(hdhtRequestLeafSet);
            bl = false;
            break;
        }
        if (bl && this.leafSet[n].size() > 0) {
            System.out.println("Ring failure at" + this.localHandle.getNodeId() + "all ccw leafset entries failed");
        }
        bl = true;
        for (n2 = n3; n2 > 0; --n2) {
            nodeHandle = this.leafSet[n].get(n2);
            if (nodeHandle == null || !nodeHandle.isAlive()) continue;
            nodeHandle.receiveMessage(hdhtRequestLeafSet);
            bl = false;
            break;
        }
        if (bl && this.leafSet[n].size() > 0) {
            System.out.println("Ring failure at" + this.localHandle.getNodeId() + "all cw leafset entries failed");
        }
    }
}

