/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.hdht;

import java.io.Serializable;
import rice.pastry.Assert;
import rice.pastry.Id;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeName;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.BroadcastRouteRow;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RouterAddress;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.PastrySecurityManager;

public class HdhtRouter
implements MessageReceiver {
    private NodeId localId;
    private NodeHandle localHandle;
    private RoutingTable routeTable;
    private LeafSet[] leafSet;
    private PastrySecurityManager security;
    private Address routeAddress;

    public HdhtRouter(NodeHandle nodeHandle, RoutingTable routingTable, LeafSet[] leafSetArray, PastrySecurityManager pastrySecurityManager) {
        this.localHandle = nodeHandle;
        this.localId = nodeHandle.getNodeId();
        this.routeTable = routingTable;
        this.leafSet = leafSetArray;
        this.security = pastrySecurityManager;
        this.routeAddress = new RouterAddress();
    }

    public Address getAddress() {
        return this.routeAddress;
    }

    public void receiveMessage(Message message) {
        if (message instanceof RouteMessage) {
            RouteMessage routeMessage = (RouteMessage)message;
            if (Log.ifp(10)) {
                System.out.println(this.localHandle.getNodeId() + " received " + routeMessage);
            }
            if (!routeMessage.routeMessage(this.localHandle.getNodeId())) {
                this.receiveRouteMessage(routeMessage);
            }
        } else {
            throw new Error("message " + message + " bounced at HdhtRouter");
        }
    }

    public void receiveRouteMessage(RouteMessage routeMessage) {
        Id id = routeMessage.getTarget();
        if (id == null || id.equals(this.localHandle.getNodeId())) {
            routeMessage.nextHop = this.localHandle;
            routeMessage.setPrevNode(this.localHandle);
            this.localHandle.receiveMessage(routeMessage);
            return;
        }
        HdhtRouter hdhtRouter = this;
        int n = hdhtRouter.routeTable.baseBitLength();
        int n2 = this.localId.indexOfMSDD(id, n);
        int n3 = this.localId.indexOfMSDD(id, 1);
        NodeName nodeName = this.localHandle.getNodeName();
        Serializable serializable = null;
        if (n2 >= 0) {
            int n4 = nodeName.numLevels() - 1;
            boolean bl = false;
            while (!bl) {
                Serializable serializable2;
                int n5;
                int n6;
                int n7 = 1 << n;
                int n8 = id.getDigit(n2, n);
                int n9 = this.localId.getDigit(n2, n);
                Serializable serializable3 = this.localId.distance(id);
                int n10 = n3;
                boolean bl2 = false;
                RouteSet routeSet = this.routeTable.getBestEntry(id);
                if (routeSet == null || (serializable = routeSet.closestNode()) == null || nodeName.commonLevels(((NodeHandle)serializable).getNodeName()) != n4) {
                    serializable = null;
                    for (n6 = 0; n6 < n7; ++n6) {
                        NodeHandle nodeHandle;
                        routeSet = this.routeTable.getRouteSet(n2, n6);
                        if (routeSet == null || (nodeHandle = routeSet.closestNode()) == null || (n5 = nodeHandle.getNodeId().indexOfMSDD(id, 1)) > n10 || nodeName.commonLevels(nodeHandle.getNodeName()) != n4 || !nodeHandle.isAlive()) continue;
                        serializable2 = nodeHandle.getNodeId().distance(id);
                        if (n5 >= n10 && ((Id.Distance)serializable3).compareTo(serializable2) <= 0) continue;
                        n10 = n5;
                        serializable3 = serializable2;
                        serializable = nodeHandle;
                    }
                }
                if (serializable == null) {
                    Assert.myAssert(this.leafSet.length > n4);
                    n6 = this.leafSet[n4].cwSize();
                    int n11 = this.leafSet[n4].ccwSize();
                    for (n5 = -n11; n5 <= n6; ++n5) {
                        int n12;
                        if (n5 == 0 || (serializable2 = this.leafSet[n4].get(n5)) == null || (n12 = ((NodeHandle)serializable2).getNodeId().indexOfMSDD(id, 1)) > n10) continue;
                        Id.Distance distance = ((NodeHandle)serializable2).getNodeId().distance(id);
                        if (n12 >= n10 && ((Id.Distance)serializable3).compareTo(distance) <= 0) continue;
                        serializable3 = distance;
                        serializable = serializable2;
                        n10 = n12;
                        if (((NodeHandle)serializable).isAlive()) continue;
                        this.leafSet[n4].remove(((NodeHandle)serializable).getNodeId());
                        this.receiveRouteMessage(routeMessage);
                        return;
                    }
                } else {
                    this.checkForRouteTableHole(routeMessage, (NodeHandle)serializable);
                }
                if (serializable != null) {
                    bl = true;
                    continue;
                }
                if (n4 == 0) {
                    bl = true;
                    continue;
                }
                --n4;
            }
            if (serializable == null) {
                serializable = this.localHandle;
            }
        }
        routeMessage.nextHop = serializable;
        routeMessage.setPrevNode(this.localHandle);
        this.localHandle.receiveMessage(routeMessage);
    }

    private void checkForRouteTableHole(RouteMessage routeMessage, NodeHandle nodeHandle) {
        Id id;
        if (routeMessage.getPrevNode() == null) {
            return;
        }
        NodeId nodeId = routeMessage.getPrevNode().getNodeId();
        int n = nodeId.indexOfMSDD(id = routeMessage.getTarget(), RoutingTable.baseBitLength());
        if (n == this.localId.indexOfMSDD(id, RoutingTable.baseBitLength())) {
            RouteSet[] routeSetArray = this.routeTable.getRow(n);
            BroadcastRouteRow broadcastRouteRow = new BroadcastRouteRow(this.localHandle, routeSetArray);
            NodeHandle nodeHandle2 = this.security.verifyNodeHandle(routeMessage.getPrevNode());
            if (nodeHandle2.isAlive()) {
                nodeHandle2.receiveMessage(broadcastRouteRow);
            }
        }
    }
}

