/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.hdht;

import java.io.IOException;
import java.net.InetSocketAddress;
import rice.pastry.Assert;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.NodeName;
import rice.pastry.PastryNode;
import rice.pastry.dist.DistNodeHandle;
import rice.pastry.hdht.HdhtJoinProtocol;
import rice.pastry.hdht.HdhtLeafSetProtocol;
import rice.pastry.hdht.HdhtRouter;
import rice.pastry.hdht.HdhtWirePastryNode;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.PastrySecurityManager;
import rice.pastry.standard.StandardRouteSetProtocol;
import rice.pastry.wire.DatagramManager;
import rice.pastry.wire.SelectorManager;
import rice.pastry.wire.SocketManager;
import rice.pastry.wire.WireNodeHandle;
import rice.pastry.wire.WireNodeHandlePool;
import rice.pastry.wire.WirePastryNodeFactory;
import rice.pastry.wire.WirePastrySecurityManager;
import rice.pastry.wire.messaging.socket.NodeIdRequestMessage;
import rice.pastry.wire.messaging.socket.NodeIdResponseMessage;

public class HdhtWirePastryNodeFactory
extends WirePastryNodeFactory {
    private String nname = null;

    public HdhtWirePastryNodeFactory(NodeIdFactory nodeIdFactory, int n) {
        super(nodeIdFactory, n);
    }

    public HdhtWirePastryNodeFactory(NodeIdFactory nodeIdFactory, int n, String string) {
        super(nodeIdFactory, n);
        this.nname = string;
    }

    public NodeHandle generateNodeHandle(InetSocketAddress inetSocketAddress) {
        WireNodeHandle wireNodeHandle = null;
        System.out.println("Wire: Contacting bootstrap node " + inetSocketAddress);
        try {
            NodeIdResponseMessage nodeIdResponseMessage = (NodeIdResponseMessage)this.getResponse(inetSocketAddress, new NodeIdRequestMessage());
            wireNodeHandle = new WireNodeHandle(inetSocketAddress, nodeIdResponseMessage.getNodeId());
            wireNodeHandle.setNodeName(new NodeName(nodeIdResponseMessage.getName()));
            return wireNodeHandle;
        }
        catch (IOException iOException) {
            System.out.println("Error connecting to address " + inetSocketAddress + ": " + iOException);
            System.out.println("Couldn't find a bootstrap node, starting a new ring...");
            return null;
        }
    }

    public PastryNode newNode(NodeHandle nodeHandle) {
        return this.newNode(nodeHandle, this.nidFactory.generateNodeId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PastryNode newNode(NodeHandle nodeHandle, NodeId nodeId) {
        final HdhtWirePastryNode hdhtWirePastryNode = new HdhtWirePastryNode(nodeId);
        SelectorManager selectorManager = new SelectorManager(hdhtWirePastryNode);
        DatagramManager datagramManager = null;
        SocketManager socketManager = null;
        InetSocketAddress inetSocketAddress = null;
        Object object = this;
        synchronized (object) {
            datagramManager = new DatagramManager(hdhtWirePastryNode, selectorManager, this.port);
            selectorManager.registerForWakeup(datagramManager);
            socketManager = new SocketManager(hdhtWirePastryNode, this.port, selectorManager.getSelector());
            inetSocketAddress = this.getAddress(this.port);
            ++this.port;
        }
        object = new WireNodeHandle(inetSocketAddress, nodeId);
        Assert.myAssert(this.nname != null, "No name given to this node!");
        ((NodeHandle)object).setNodeName(new NodeName(this.nname));
        WireNodeHandlePool wireNodeHandlePool = new WireNodeHandlePool(hdhtWirePastryNode);
        WirePastrySecurityManager wirePastrySecurityManager = new WirePastrySecurityManager((WireNodeHandle)object, wireNodeHandlePool);
        MessageDispatch messageDispatch = new MessageDispatch();
        RoutingTable routingTable = new RoutingTable((NodeHandle)object, 1);
        int n = ((NodeHandle)object).getNodeName().numLevels();
        LeafSet[] leafSetArray = new LeafSet[n];
        for (int i = 0; i < n; ++i) {
            leafSetArray[i] = new LeafSet((NodeHandle)object, 24, i);
        }
        HdhtRouter hdhtRouter = new HdhtRouter((NodeHandle)object, routingTable, leafSetArray, wirePastrySecurityManager);
        HdhtLeafSetProtocol hdhtLeafSetProtocol = new HdhtLeafSetProtocol(hdhtWirePastryNode, (NodeHandle)object, wirePastrySecurityManager, leafSetArray, routingTable);
        StandardRouteSetProtocol standardRouteSetProtocol = new StandardRouteSetProtocol((NodeHandle)object, wirePastrySecurityManager, routingTable);
        HdhtJoinProtocol hdhtJoinProtocol = new HdhtJoinProtocol(hdhtWirePastryNode, (NodeHandle)object, wirePastrySecurityManager, routingTable, leafSetArray);
        messageDispatch.registerReceiver(hdhtRouter.getAddress(), hdhtRouter);
        messageDispatch.registerReceiver(hdhtLeafSetProtocol.getAddress(), hdhtLeafSetProtocol);
        messageDispatch.registerReceiver(standardRouteSetProtocol.getAddress(), standardRouteSetProtocol);
        messageDispatch.registerReceiver(hdhtJoinProtocol.getAddress(), hdhtJoinProtocol);
        hdhtWirePastryNode.setElements((NodeHandle)object, (PastrySecurityManager)wirePastrySecurityManager, messageDispatch, leafSetArray, routingTable);
        hdhtWirePastryNode.setSocketElements(inetSocketAddress, selectorManager, datagramManager, socketManager, wireNodeHandlePool, 60, 900);
        wirePastrySecurityManager.setLocalPastryNode(hdhtWirePastryNode);
        wireNodeHandlePool.coalesce((DistNodeHandle)object);
        ((NodeHandle)object).setLocalNode(hdhtWirePastryNode);
        if (nodeHandle != null) {
            nodeHandle.setLocalNode(hdhtWirePastryNode);
        }
        Thread thread = new Thread("Thread for node " + nodeId, (WireNodeHandle)object, nodeHandle){
            private final /* synthetic */ WireNodeHandle val$localhandle;
            private final /* synthetic */ NodeHandle val$bootstrap;
            {
                this.val$localhandle = wireNodeHandle;
                this.val$bootstrap = nodeHandle;
            }

            public void run() {
                try {
                    1.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Interrupted in newNode!");
                }
                hdhtWirePastryNode.doneNode(HdhtWirePastryNodeFactory.this.getNearest(this.val$localhandle, this.val$bootstrap));
            }
        };
        hdhtWirePastryNode.setThread(thread);
        thread.start();
        return hdhtWirePastryNode;
    }
}

