/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.leafset;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import rice.pastry.Assert;
import rice.pastry.Id;
import rice.pastry.IdRange;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeSet;
import rice.pastry.leafset.SimilarSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.PastrySecurityManager;

public class LeafSet
extends Observable
implements Serializable {
    private NodeId baseId;
    private NodeHandle baseHandle;
    private SimilarSet cwSet;
    private SimilarSet ccwSet;
    private int theSize;
    private int level;

    public LeafSet(NodeHandle nodeHandle, int n) {
        this.baseHandle = nodeHandle;
        this.baseId = nodeHandle.getNodeId();
        this.theSize = n;
        this.level = -1;
        this.cwSet = new SimilarSet(nodeHandle, n / 2, true);
        this.ccwSet = new SimilarSet(nodeHandle, n / 2, false);
    }

    public LeafSet(NodeHandle nodeHandle, int n, int n2) {
        this.baseHandle = nodeHandle;
        this.baseId = nodeHandle.getNodeId();
        this.theSize = n;
        this.level = n2;
        this.cwSet = new SimilarSet(nodeHandle, n / 2, true);
        this.ccwSet = new SimilarSet(nodeHandle, n / 2, false);
    }

    public boolean put(NodeHandle nodeHandle) {
        NodeId nodeId;
        if (this.level != -1) {
            Assert.myAssert(nodeHandle.getNodeName().commonLevels(this.baseHandle.getNodeName()) >= this.level, this.baseHandle.getNodeName() + "In leafset level " + this.level + " trying to insert " + nodeHandle.getNodeName());
        }
        if ((nodeId = nodeHandle.getNodeId()).equals(this.baseId)) {
            return false;
        }
        if (this.member(nodeId)) {
            return false;
        }
        boolean bl = this.cwSet.put(nodeHandle) | this.ccwSet.put(nodeHandle);
        return bl;
    }

    public boolean test(NodeHandle nodeHandle) {
        NodeId nodeId = nodeHandle.getNodeId();
        if (nodeId.equals(this.baseId)) {
            return false;
        }
        if (this.member(nodeId)) {
            return false;
        }
        return this.cwSet.test(nodeHandle) | this.ccwSet.test(nodeHandle);
    }

    public boolean overlaps() {
        return this.size() > 0 && (this.ccwSet.member(this.cwSet.get(this.cwSet.size() - 1).getNodeId()) || this.cwSet.member(this.ccwSet.get(this.ccwSet.size() - 1).getNodeId()));
    }

    public NodeHandle get(NodeId nodeId) {
        NodeHandle nodeHandle = this.cwSet.get(nodeId);
        if (nodeHandle != null) {
            return nodeHandle;
        }
        return this.ccwSet.get(nodeId);
    }

    public int getIndex(NodeId nodeId) throws NoSuchElementException {
        if (this.baseId.equals(nodeId)) {
            return 0;
        }
        int n = this.cwSet.getIndex(nodeId);
        if (n >= 0) {
            return n + 1;
        }
        n = this.ccwSet.getIndex(nodeId);
        if (n >= 0) {
            return -n - 1;
        }
        throw new NoSuchElementException();
    }

    public NodeHandle get(int n) {
        if (n == 0) {
            return this.baseHandle;
        }
        if (n >= 0) {
            return this.cwSet.get(n - 1);
        }
        return this.ccwSet.get(-n - 1);
    }

    public boolean member(NodeId nodeId) {
        return this.cwSet.member(nodeId) || this.ccwSet.member(nodeId);
    }

    public NodeHandle remove(NodeId nodeId) {
        NodeHandle nodeHandle = this.cwSet.remove(nodeId);
        NodeHandle nodeHandle2 = this.ccwSet.remove(nodeId);
        if (nodeHandle != null) {
            return nodeHandle;
        }
        return nodeHandle2;
    }

    public int maxSize() {
        return this.theSize;
    }

    public int size() {
        return this.cwSet.size() + this.ccwSet.size();
    }

    public int cwSize() {
        return this.cwSet.size();
    }

    public int ccwSize() {
        return this.ccwSet.size();
    }

    private int complement(int n) {
        int n2;
        if (n == 0) {
            return 0;
        }
        if (n < 0) {
            if (n < -this.ccwSize()) {
                return n;
            }
            n2 = this.cwSet.getIndex(this.ccwSet.get(-n - 1).getNodeId()) + 1;
        } else {
            if (n > this.cwSize()) {
                return n;
            }
            n2 = -this.ccwSet.getIndex(this.cwSet.get(n - 1).getNodeId()) - 1;
        }
        if (n2 == 0) {
            n2 = n;
        }
        return n2;
    }

    public int mostSimilar(Id id) {
        int n;
        int n2;
        if (this.baseId.clockwise(id)) {
            n2 = this.cwSet.mostSimilar(id);
            if (n2 < this.cwSet.size() - 1) {
                return n2 + 1;
            }
            n = this.ccwSet.mostSimilar(id);
        } else {
            n = this.ccwSet.mostSimilar(id);
            if (n < this.ccwSet.size() - 1) {
                return -n - 1;
            }
            n2 = this.cwSet.mostSimilar(id);
        }
        Id.Distance distance = this.cwSet.get(n2).getNodeId().distance(id);
        Id.Distance distance2 = this.ccwSet.get(n).getNodeId().distance(id);
        int n3 = distance.compareTo(distance2);
        if (n3 < 0 || n3 == 0 && id.clockwise(this.cwSet.get(n2).getNodeId())) {
            return n2 + 1;
        }
        return -n - 1;
    }

    public NodeSet neighborSet(int n) {
        int n2;
        int n3 = this.cwSize();
        int n4 = this.ccwSize();
        NodeHandle nodeHandle = this.get(n3);
        NodeHandle nodeHandle2 = this.get(-n4);
        NodeSet nodeSet = this.replicaSet(this.baseId, n);
        if (!nodeSet.member(nodeHandle.getNodeId()) && !nodeSet.member(nodeHandle2.getNodeId())) {
            return nodeSet;
        }
        if (!nodeSet.member(nodeHandle.getNodeId())) {
            for (n2 = 1; n2 <= n3; ++n2) {
                nodeSet.put(this.get(n2));
            }
        }
        if (!nodeSet.member(nodeHandle2.getNodeId())) {
            for (n2 = 1; n2 <= n4; ++n2) {
                nodeSet.put(this.get(-n2));
            }
        }
        return nodeSet;
    }

    public NodeSet replicaSet(Id id, int n) {
        NodeSet nodeSet = new NodeSet();
        if (n < 1) {
            return nodeSet;
        }
        if (!(this.overlaps() || this.size() <= 0 || id.isBetween(this.get(-this.ccwSet.size()).getNodeId(), this.get(this.cwSet.size()).getNodeId()) || id.equals(this.get(this.cwSet.size()).getNodeId()))) {
            return nodeSet;
        }
        int n2 = this.mostSimilar(id);
        nodeSet.put(this.get(n2));
        int n3 = n2;
        int n4 = n2;
        int n5 = 0;
        while (nodeSet.size() < n && n5 < 3) {
            int n6;
            Id.Distance distance;
            NodeHandle nodeHandle = this.get(n3);
            NodeHandle nodeHandle2 = this.get(n4);
            Id.Distance distance2 = nodeHandle.getNodeId().distance(id);
            if (distance2.compareTo(distance = nodeHandle2.getNodeId().distance(id)) <= 0) {
                nodeSet.put(nodeHandle);
                n6 = n3;
                if (n3 == this.cwSet.size()) {
                    if ((n3 = this.complement(n3)) == n6) {
                        return nodeSet;
                    }
                    ++n5;
                }
                ++n3;
                continue;
            }
            nodeSet.put(nodeHandle2);
            n6 = n4;
            if (-n4 == this.ccwSet.size()) {
                if ((n4 = this.complement(n4)) == n6) {
                    return nodeSet;
                }
                ++n5;
            }
            --n4;
        }
        return nodeSet;
    }

    private int getUniqueCount() {
        Vector<NodeId> vector = new Vector<NodeId>();
        for (int i = -this.ccwSize(); i <= this.cwSize(); ++i) {
            if (vector.contains(this.get(i).getNodeId())) continue;
            vector.add(this.get(i).getNodeId());
        }
        return vector.size();
    }

    private int mod(int n, int n2) {
        if (n < 0) {
            return n2 + n % n2;
        }
        return n % n2;
    }

    public IdRange range(NodeHandle nodeHandle, int n) {
        NodeHandle nodeHandle2;
        NodeHandle nodeHandle3;
        if (n < 0) {
            return null;
        }
        if (!this.member(nodeHandle.getNodeId()) && !this.baseId.equals(nodeHandle.getNodeId())) {
            return null;
        }
        int n2 = this.getIndex(nodeHandle.getNodeId());
        int n3 = this.getUniqueCount();
        if (this.overlaps() || n3 == 1) {
            if (n + 1 >= n3) {
                return new IdRange(nodeHandle.getNodeId(), nodeHandle.getNodeId());
            }
            nodeHandle3 = this.get(this.mod(n2 - n - 1 + this.ccwSet.size(), n3) - this.ccwSet.size());
            nodeHandle2 = this.get(this.mod(n2 + n + 1 + this.ccwSet.size(), n3) - this.ccwSet.size());
        } else {
            nodeHandle3 = this.get(n2 - n - 1);
            nodeHandle2 = this.get(n2 + n + 1);
        }
        if (nodeHandle3 == null || nodeHandle2 == null) {
            return null;
        }
        IdRange idRange = new IdRange(nodeHandle.getNodeId(), nodeHandle2.getNodeId()).ccwHalf();
        IdRange idRange2 = new IdRange(nodeHandle3.getNodeId(), nodeHandle.getNodeId()).cwHalf();
        return idRange2.merge(idRange);
    }

    public IdRange range(NodeHandle nodeHandle, int n, boolean bl) {
        IdRange idRange = this.range(nodeHandle, n);
        IdRange idRange2 = this.range(nodeHandle, n - 1);
        if (idRange == null || idRange2 == null) {
            return idRange;
        }
        IdRange idRange3 = !bl ? idRange.diff(idRange2) : idRange2.diff(idRange);
        return idRange3;
    }

    public boolean merge(LeafSet leafSet, NodeHandle nodeHandle, RoutingTable routingTable, PastrySecurityManager pastrySecurityManager, boolean bl, Set set) {
        boolean bl2;
        Serializable serializable;
        int n;
        boolean bl3 = false;
        int n2 = leafSet.cwSize();
        int n3 = leafSet.ccwSize();
        int n4 = leafSet.cwSet.getIndex(this.baseId);
        int n5 = leafSet.ccwSet.getIndex(this.baseId);
        if (n4 < 0) {
            if (n5 < 0) {
                if (leafSet.size() < 2) {
                    n5 = 0;
                    n4 = 0;
                } else {
                    n = leafSet.mostSimilar(this.baseId);
                    serializable = leafSet.get(n).getNodeId();
                    if (n == -leafSet.ccwSize() || n == leafSet.cwSize()) {
                        // empty if block
                    }
                    if (n == 0) {
                        if (this.baseId.clockwise((Id)serializable)) {
                            n4 = n;
                            n5 = leafSet.complement(n - 1);
                        } else {
                            n4 = leafSet.complement(n + 1);
                            n5 = n;
                        }
                    } else if (n < 0) {
                        if (this.baseId.clockwise((Id)serializable)) {
                            n4 = n;
                            n5 = leafSet.complement(n - 1);
                        } else {
                            n4 = n + 1;
                            n5 = leafSet.complement(n);
                        }
                    } else if (this.baseId.clockwise((Id)serializable)) {
                        n4 = leafSet.complement(n);
                        n5 = n - 1;
                    } else {
                        n5 = n;
                        n4 = leafSet.complement(n + 1);
                    }
                }
            } else {
                n5 = -n5 - 2;
                n4 = n5 + 2;
            }
        } else if (n5 < 0) {
            n5 = (n4 += 2) - 2;
        } else {
            n = n5;
            n5 = n4;
            n4 = -n;
        }
        for (n = n4; n <= n2; ++n) {
            serializable = n == 0 ? nodeHandle : leafSet.get(n);
            if (!((NodeHandle)(serializable = pastrySecurityManager.verifyNodeHandle((NodeHandle)serializable))).isAlive()) continue;
            if (bl) {
                bl2 = this.cwSet.test((NodeHandle)serializable);
            } else {
                bl2 = this.cwSet.put((NodeHandle)serializable);
                if (((NodeHandle)serializable).getNodeName() == null) {
                    System.out.println("Culprit found: nh does not have node name " + serializable);
                    System.out.println("got this update from " + nodeHandle);
                    Assert.myAssert(false);
                }
                routingTable.put((NodeHandle)serializable);
            }
            bl3 |= bl2;
            if (set == null || !bl2) continue;
            set.add(serializable);
        }
        for (n = n5; n >= -n3; --n) {
            serializable = n == 0 ? nodeHandle : leafSet.get(n);
            if (!((NodeHandle)(serializable = pastrySecurityManager.verifyNodeHandle((NodeHandle)serializable))).isAlive()) continue;
            if (bl) {
                bl2 = this.ccwSet.test((NodeHandle)serializable);
            } else {
                bl2 = this.ccwSet.put((NodeHandle)serializable);
                routingTable.put((NodeHandle)serializable);
            }
            bl3 |= bl2;
            if (set == null || !bl2) continue;
            set.add(serializable);
        }
        if (this.overlaps()) {
            for (n = -n3; n <= n2; ++n) {
                serializable = n == 0 ? nodeHandle : leafSet.get(n);
                if (!((NodeHandle)(serializable = pastrySecurityManager.verifyNodeHandle((NodeHandle)serializable))).isAlive()) continue;
                bl2 = bl ? this.test((NodeHandle)serializable) : this.put((NodeHandle)serializable);
                bl3 |= bl2;
                if (set == null || !bl2) continue;
                set.add(serializable);
            }
        }
        return bl3;
    }

    public void addObserver(Observer observer) {
        this.cwSet.addObserver(observer);
        this.ccwSet.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.cwSet.deleteObserver(observer);
        this.ccwSet.deleteObserver(observer);
    }

    public String toString() {
        int n;
        String string = "leafset: ";
        for (n = -this.ccwSet.size(); n < 0; ++n) {
            string = string + this.get(n).getNodeId();
        }
        string = string + " [ " + this.baseId + " ] ";
        for (n = 1; n <= this.cwSet.size(); ++n) {
            string = string + this.get(n).getNodeId();
        }
        return string;
    }
}

