/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.leafset;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeSetI;
import rice.pastry.NodeSetUpdate;

public class SimilarSet
extends Observable
implements NodeSetI,
Serializable,
Observer {
    private NodeHandle ln;
    private boolean clockwise;
    private NodeHandle[] nodes;
    private int theSize;

    protected void swap(int n, int n2) {
        NodeHandle nodeHandle = this.nodes[n];
        this.nodes[n] = this.nodes[n2];
        this.nodes[n2] = nodeHandle;
    }

    public SimilarSet(NodeHandle nodeHandle, int n, boolean bl) {
        this.ln = nodeHandle;
        this.clockwise = bl;
        this.theSize = 0;
        this.nodes = new NodeHandle[n];
    }

    public boolean test(NodeHandle nodeHandle) {
        NodeId nodeId = nodeHandle.getNodeId();
        if (nodeId.equals(this.ln.getNodeId())) {
            return false;
        }
        for (int i = 0; i < this.theSize; ++i) {
            if (!nodeId.equals(this.nodes[i].getNodeId())) continue;
            return false;
        }
        if (this.theSize < this.nodes.length) {
            return true;
        }
        return !(this.clockwise ? !nodeId.isBetween(this.ln.getNodeId(), this.nodes[this.theSize - 1].getNodeId()) : !nodeId.isBetween(this.nodes[this.theSize - 1].getNodeId(), this.ln.getNodeId()));
    }

    public boolean put(NodeHandle nodeHandle) {
        NodeId nodeId = nodeHandle.getNodeId();
        if (!this.test(nodeHandle)) {
            return false;
        }
        if (this.theSize < this.nodes.length) {
            this.nodes[this.theSize] = nodeHandle;
            ++this.theSize;
        } else {
            --this.theSize;
            this.setChanged();
            this.notifyObservers(new NodeSetUpdate(this.nodes[this.theSize], false));
            this.nodes[this.theSize].deleteObserver(this);
            ++this.theSize;
            this.nodes[this.theSize - 1] = nodeHandle;
        }
        if (this.clockwise) {
            for (int i = this.theSize - 1; i > 0 && nodeId.isBetween(this.ln.getNodeId(), this.nodes[i - 1].getNodeId()); --i) {
                this.swap(i, i - 1);
            }
        } else {
            for (int i = this.theSize - 1; i > 0 && nodeId.isBetween(this.nodes[i - 1].getNodeId(), this.ln.getNodeId()); --i) {
                this.swap(i, i - 1);
            }
        }
        this.setChanged();
        this.notifyObservers(new NodeSetUpdate(nodeHandle, true));
        nodeHandle.addObserver(this);
        return true;
    }

    public void update(Observable observable, Object object) {
        if ((Integer)object == NodeHandle.DECLARED_DEAD) {
            this.remove(((NodeHandle)observable).getNodeId());
        }
    }

    public NodeHandle get(NodeId nodeId) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nodeId)) continue;
            return this.nodes[i];
        }
        return null;
    }

    public NodeHandle get(int n) {
        if (n < -1 || n >= this.theSize) {
            return null;
        }
        if (n == -1) {
            return this.ln;
        }
        return this.nodes[n];
    }

    public boolean member(NodeId nodeId) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nodeId)) continue;
            return true;
        }
        return false;
    }

    public NodeHandle remove(NodeId nodeId) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nodeId)) continue;
            return this.remove(i);
        }
        return null;
    }

    public NodeHandle remove(int n) {
        if (n < 0 || n >= this.theSize) {
            return null;
        }
        NodeHandle nodeHandle = this.nodes[n];
        for (int i = n + 1; i < this.theSize; ++i) {
            this.nodes[i - 1] = this.nodes[i];
        }
        --this.theSize;
        this.setChanged();
        this.notifyObservers(new NodeSetUpdate(nodeHandle, false));
        nodeHandle.deleteObserver(this);
        return nodeHandle;
    }

    public int getIndex(NodeId nodeId) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nodeId)) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.theSize;
    }

    public int mostSimilar(Id id) {
        if (this.theSize == 0) {
            return -1;
        }
        Id.Distance distance = this.ln.getNodeId().distance(id);
        int n = -1;
        for (int i = 0; i < this.theSize; ++i) {
            Id.Distance distance2 = this.nodes[i].getNodeId().distance(id);
            int n2 = distance2.compareTo(distance);
            if ((this.clockwise || n2 >= 0) && (!this.clockwise || n2 > 0)) continue;
            distance = distance2;
            n = i;
        }
        return n;
    }

    public boolean putHandle(rice.p2p.commonapi.NodeHandle nodeHandle) {
        return this.put((NodeHandle)nodeHandle);
    }

    public rice.p2p.commonapi.NodeHandle getHandle(rice.p2p.commonapi.Id id) {
        return this.getHandle((NodeId)id);
    }

    public rice.p2p.commonapi.NodeHandle getHandle(int n) {
        return this.get(n);
    }

    public boolean memberHandle(rice.p2p.commonapi.Id id) {
        return this.member((NodeId)id);
    }

    public rice.p2p.commonapi.NodeHandle removeHandle(rice.p2p.commonapi.Id id) {
        return this.remove((NodeId)id);
    }

    public int getIndexHandle(rice.p2p.commonapi.Id id) throws NoSuchElementException {
        return this.getIndex((NodeId)id);
    }
}

